/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.util;

import de.sciss.fscape.Application;
import de.sciss.fscape.gui.PathField;
import de.sciss.io.IOUtil;
import de.sciss.util.Param;
import de.sciss.util.ParamSpace;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PrefsUtil {
    public static final String KEY_VERSION = "version";
    public static final String KEY_USERPATHS = "usrpaths";
    public static final String KEY_OPENRECENT = "recent";
    public static final String KEY_LOOKANDFEEL = "lookandfeel";
    public static final String KEY_INTRUDINGSIZE = "intrudingsize";
    public static final String KEY_LOCATION = "location";
    public static final String KEY_SIZE = "size";
    public static final String KEY_VISIBLE = "visible";
    public static final String KEY_BACKUP = "makebackups";
    public static final String KEY_BAKDIR = "backupdir";
    public static final String KEY_LAF_TYPE = "laf-type";
    public static final String VALUE_LAF_TYPE_NATIVE = "native";
    public static final String VALUE_LAF_TYPE_METAL = "metal";
    public static final String VALUE_LAF_TYPE_SUBMIN_LIGHT = "light";
    public static final String VALUE_LAF_TYPE_SUBMIN_DARK = "dark";
    public static final String KEY_LAF_WINDOWS = "lafdecoration";

    public static List createDefaults(Preferences preferences, double d) {
        boolean bl = System.getProperty("os.name").contains("Mac OS");
        ArrayList<String> arrayList = new ArrayList<String>();
        PrefsUtil.putDontOverwrite(IOUtil.getUserPrefs(), "tmpdir", System.getProperty("java.io.tmpdir"));
        PrefsUtil.putBooleanDontOverwrite(preferences, KEY_BACKUP, true);
        if (preferences.get(KEY_BAKDIR, null) == null) {
            File file = new File(new File(System.getProperty("user.home"), Application.name), "bak");
            if (!file.isDirectory()) {
                try {
                    IOUtil.createEmptyDirectory((File)file);
                }
                catch (IOException iOException) {
                    arrayList.add(file.getAbsolutePath() + " : Could not create directory");
                }
            }
            PrefsUtil.putDontOverwrite(preferences, KEY_BAKDIR, file.getAbsolutePath());
        }
        preferences.put(KEY_VERSION, Application.version);
        PrefsUtil.putDontOverwrite(preferences, "audioFileRes", PathField.getSoundResID(1));
        PrefsUtil.putDontOverwrite(preferences, "audioFileRate", PathField.getSoundRateID(2));
        PrefsUtil.putDontOverwrite(preferences, "headroom", new Param(-0.2, ParamSpace.spcAmpDecibels.unit).toString());
        return arrayList;
    }

    private static boolean putDontOverwrite(Preferences preferences, String string, String string2) {
        boolean bl;
        boolean bl2 = bl = preferences.get(string, null) == null;
        if (bl) {
            preferences.put(string, string2);
        }
        return bl;
    }

    private static boolean putBooleanDontOverwrite(Preferences preferences, String string, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = preferences.get(string, null) == null;
        if (bl2) {
            preferences.putBoolean(string, bl);
        }
        return bl2;
    }

    public static Rectangle stringToRectangle(String string) {
        Rectangle rectangle = null;
        if (string != null) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                rectangle = new Rectangle(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rectangle;
    }

    public static Point stringToPoint(String string) {
        Point point = null;
        if (string != null) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                point = new Point(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return point;
    }

    public static Dimension stringToDimension(String string) {
        Dimension dimension = null;
        if (string != null) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                dimension = new Dimension(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return dimension;
    }

    public static String rectangleToString(Rectangle rectangle) {
        return rectangle != null ? rectangle.x + " " + rectangle.y + " " + rectangle.width + " " + rectangle.height : null;
    }

    public static String pointToString(Point point) {
        return point != null ? point.x + " " + point.y : null;
    }

    public static String dimensionToString(Dimension dimension) {
        return dimension != null ? dimension.width + " " + dimension.height : null;
    }

    public static KeyStroke prefsToStroke(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(32);
        KeyStroke keyStroke = null;
        try {
            if (n < 0) {
                return null;
            }
            keyStroke = KeyStroke.getKeyStroke(Integer.parseInt(string.substring(n + 1)), Integer.parseInt(string.substring(0, n)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return keyStroke;
    }

    public static String strokeToPrefs(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return null;
        }
        return String.valueOf(keyStroke.getModifiers()) + ' ' + String.valueOf(keyStroke.getKeyCode());
    }

    public static void removeAll(Preferences preferences, boolean bl) throws BackingStoreException {
        int n;
        String[] stringArray = preferences.keys();
        for (n = 0; n < stringArray.length; ++n) {
            preferences.remove(stringArray[n]);
        }
        if (bl) {
            String[] stringArray2 = preferences.childrenNames();
            for (n = 0; n < stringArray2.length; ++n) {
                PrefsUtil.removeAll(preferences.node(stringArray2[n]), true);
            }
        }
    }

    public static Action getDebugDumpAction() {
        AbstractAction abstractAction = new AbstractAction("Dump preferences tree"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.debugDump(Application.userPrefs);
            }

            private void debugDump(Preferences preferences) {
                System.err.println("------- debugDump prefs : " + preferences.name() + " -------");
                try {
                    int n;
                    String[] stringArray = preferences.keys();
                    for (n = 0; n < stringArray.length; ++n) {
                        String string = preferences.get(stringArray[n], null);
                        System.err.println("  key = '" + stringArray[n] + "' ; value = '" + string + "'");
                    }
                    String[] stringArray2 = preferences.childrenNames();
                    for (n = 0; n < stringArray2.length; ++n) {
                        this.debugDump(preferences.node(stringArray2[n]));
                    }
                }
                catch (BackingStoreException backingStoreException) {
                    System.err.println(backingStoreException.getLocalizedMessage());
                }
            }
        };
        return abstractAction;
    }

    public static void toXML(Preferences preferences, boolean bl, Document document, Element element, Map map) throws IOException {
        try {
            int n;
            String[] stringArray = preferences.keys();
            Element element2 = (Element)element.appendChild(document.createElement("map"));
            for (n = 0; n < stringArray.length; ++n) {
                String string = preferences.get(stringArray[n], null);
                if (string == null) continue;
                Element element3 = (Element)element2.appendChild(document.createElement("entry"));
                element3.setAttribute("key", stringArray[n]);
                element3.setAttribute("value", string);
            }
            if (bl) {
                String[] stringArray2 = preferences.childrenNames();
                for (n = 0; n < stringArray2.length; ++n) {
                    element2 = (Element)element.appendChild(document.createElement("node"));
                    element2.setAttribute("name", stringArray2[n]);
                    PrefsUtil.toXML(preferences.node(stringArray2[n]), true, document, element2, map);
                }
            }
        }
        catch (DOMException dOMException) {
            throw IOUtil.map((Exception)dOMException);
        }
        catch (BackingStoreException backingStoreException) {
            throw IOUtil.map((Exception)backingStoreException);
        }
    }

    public static void fromXML(Preferences preferences, Document document, Element element, Map map) throws IOException {
        try {
            Element element2;
            Node node;
            int n;
            NodeList nodeList = element.getChildNodes();
            for (n = 0; n < nodeList.getLength(); ++n) {
                node = nodeList.item(n);
                if (!(node instanceof Element)) continue;
                element2 = (Element)node;
                NodeList nodeList2 = element2.getElementsByTagName("entry");
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    Element element3 = (Element)nodeList2.item(i);
                    preferences.put(element3.getAttribute("key"), element3.getAttribute("value"));
                }
                break;
            }
            while (n < nodeList.getLength()) {
                node = nodeList.item(n);
                if (node instanceof Element) {
                    element2 = (Element)node;
                    PrefsUtil.fromXML(preferences.node(element2.getAttribute("name")), document, element2, map);
                }
                ++n;
            }
        }
        catch (DOMException dOMException) {
            throw IOUtil.map((Exception)dOMException);
        }
    }
}

