/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.data;

import com.alee.managers.language.data.Value;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CompareUtils;
import com.alee.utils.MergeUtils;
import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@XStreamAlias(value="record")
public final class Record
implements Serializable,
Cloneable {
    @XStreamAsAttribute
    private String key;
    @XStreamAsAttribute
    private String hotkey;
    @XStreamImplicit
    private List<Value> values;

    public Record() {
        this(null);
    }

    public Record(String key) {
        this(key, new ArrayList<Value>());
    }

    public Record(String key, Value ... values) {
        this.setKey(key);
        this.setValues(CollectionUtils.asList(values));
    }

    public Record(String key, List<Value> values) {
        this.setKey(key);
        this.setValues(CollectionUtils.copy(values));
    }

    public Record(String key, String hotkey, Value ... values) {
        this.setKey(key);
        this.setHotkey(hotkey);
        this.setValues(CollectionUtils.asList(values));
    }

    public Record(String key, String hotkey, List<Value> values) {
        this.setKey(key);
        this.setHotkey(hotkey);
        this.setValues(CollectionUtils.copy(values));
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getHotkey() {
        return this.hotkey;
    }

    public void setHotkey(String hotkey) {
        this.hotkey = hotkey;
    }

    public List<Value> getValues() {
        return this.values;
    }

    public void setValues(List<Value> values) {
        this.values = values;
    }

    public Value addValue(Value value) {
        if (this.values == null) {
            this.values = new ArrayList<Value>(1);
        }
        this.values.add(value);
        return value;
    }

    public void removeValue(Value value) {
        if (this.values != null) {
            this.values.remove(value);
        }
    }

    public void removeValue(String language) {
        if (this.values != null) {
            for (int i = 0; i < this.values.size(); ++i) {
                String valueLang = this.values.get(i).getLang();
                if (!CompareUtils.equals(valueLang, language)) continue;
                this.values.remove(i);
            }
        }
    }

    public void clear() {
        if (this.values != null) {
            this.values.clear();
        }
    }

    public int size() {
        return this.values != null ? this.values.size() : 0;
    }

    public String getText(String lang) {
        return this.getText(lang, null);
    }

    public String getText(String lang, String state) {
        Value value = this.getValue(lang);
        return value != null ? value.getText(state) : null;
    }

    public Value getValue(String lang) {
        if (this.values != null) {
            for (Value value : this.values) {
                String valueLang = value.getLang();
                if (valueLang != null && !CompareUtils.equals(valueLang, lang)) continue;
                return value;
            }
        }
        return null;
    }

    public boolean hasValue(String lang) {
        return this.getValue(lang) != null;
    }

    public List<String> getSupportedLanguages() {
        return this.getSupportedLanguages(new ArrayList<String>(this.size()));
    }

    public List<String> getSupportedLanguages(List<String> languages) {
        if (this.values != null) {
            for (Value value : this.values) {
                if (languages.contains(value.getLang())) continue;
                languages.add(value.getLang());
            }
        }
        return languages;
    }

    public Record clone() {
        return MergeUtils.cloneByFieldsSafely(this, new Object[0]);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean boldKey) {
        return (boldKey ? "{" : "") + this.key + (boldKey ? ":b}" : "") + (this.hotkey != null ? " (" + this.hotkey + ")" : "") + " -> " + (this.values != null ? "[ " + TextUtils.listToString(this.values, "; ") + " ]" : "null");
    }
}

