/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings.processors;

import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.SettingsProcessorData;
import com.alee.utils.CompareUtils;
import com.alee.utils.CoreSwingUtils;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JRootPane;

public class JRootPaneSettingsProcessor
extends SettingsProcessor<JRootPane, Rectangle> {
    private ComponentAdapter componentAdapter;

    public JRootPaneSettingsProcessor(SettingsProcessorData data) {
        super(data);
    }

    @Override
    protected void doInit(JRootPane rootPane) {
        Window window = CoreSwingUtils.getWindowAncestor(rootPane);
        this.componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JRootPaneSettingsProcessor.this.save();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                JRootPaneSettingsProcessor.this.save();
            }
        };
        window.addComponentListener(this.componentAdapter);
    }

    @Override
    protected void doDestroy(JRootPane rootPane) {
        Window window = CoreSwingUtils.getWindowAncestor(rootPane);
        window.removeComponentListener(this.componentAdapter);
        this.componentAdapter = null;
    }

    @Override
    protected void doLoad(JRootPane rootPane) {
        Window window = CoreSwingUtils.getWindowAncestor(rootPane);
        Rectangle bounds = (Rectangle)this.loadValue();
        if (bounds != null && !CompareUtils.equals(bounds, window.getBounds())) {
            Dimension size = bounds.getSize();
            if (size.width > 0 && size.height > 0) {
                window.setSize(size);
            } else {
                window.pack();
            }
            Point location = bounds.getLocation();
            if (location.x > 0 && location.y > 0) {
                window.setLocation(location);
            } else {
                window.setLocationRelativeTo(null);
            }
        }
    }

    @Override
    protected void doSave(JRootPane rootPane) {
        Window window = CoreSwingUtils.getWindowAncestor(rootPane);
        this.saveValue(window.getBounds());
    }
}

