/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.alee.utils.ColorUtils;
import com.alee.utils.collection.ValuesTable;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.awt.Color;

public class ColorConverter
extends AbstractSingleValueConverter {
    public static final String NULL_COLOR = "null";
    public static final Color TRANSPARENT = new Color(255, 255, 255, 0);
    private static final ValuesTable<String, Color> defaultColors = new ValuesTable();

    public boolean canConvert(Class type) {
        return Color.class.isAssignableFrom(type);
    }

    public String toString(Object object) {
        Color color = (Color)object;
        return ColorConverter.colorToString(color);
    }

    public Object fromString(String color) {
        return ColorConverter.colorFromString(color);
    }

    public static String colorToString(Color color) {
        return defaultColors.containsValue(color) ? defaultColors.getKey(color) : color.getRed() + "," + color.getGreen() + "," + color.getBlue() + (color.getAlpha() < 255 ? "," + color.getAlpha() : "");
    }

    public static Color colorFromString(String color) {
        return defaultColors.containsKey(color) ? defaultColors.get(color) : (color.contains("#") ? ColorUtils.parseHexColor(color) : ColorUtils.parseRgbColor(color));
    }

    static {
        defaultColors.put(NULL_COLOR, null);
        defaultColors.put("transparent", TRANSPARENT);
        defaultColors.put("black", Color.BLACK);
        defaultColors.put("white", Color.WHITE);
        defaultColors.put("red", Color.RED);
        defaultColors.put("green", Color.GREEN);
        defaultColors.put("blue", Color.BLUE);
        defaultColors.put("lightGray", Color.LIGHT_GRAY);
        defaultColors.put("gray", Color.GRAY);
        defaultColors.put("darkGray", Color.DARK_GRAY);
        defaultColors.put("pink", Color.PINK);
        defaultColors.put("orange", Color.ORANGE);
        defaultColors.put("yellow", Color.YELLOW);
        defaultColors.put("magenta", Color.MAGENTA);
        defaultColors.put("cyan", Color.CYAN);
    }
}

