/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.alee.managers.log.Log;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.awt.Font;
import java.util.StringTokenizer;

public class FontConverter
extends AbstractSingleValueConverter {
    public static final String separator = ";";
    public static final int defaultStyle = 0;
    public static final int defaultSize = 12;

    public boolean canConvert(Class type) {
        return Font.class.isAssignableFrom(type);
    }

    public Object fromString(String dimension) {
        return FontConverter.fontFromString(dimension);
    }

    public String toString(Object object) {
        return FontConverter.fontToString((Font)object);
    }

    public static Font fontFromString(String font) {
        try {
            StringTokenizer t = new StringTokenizer(font, separator, false);
            String name = t.nextToken().trim();
            int style = t.hasMoreElements() ? Integer.parseInt(t.nextToken().trim()) : 0;
            int size = t.hasMoreElements() ? Integer.parseInt(t.nextToken().trim()) : 12;
            return new Font(name, style, size);
        }
        catch (Throwable e) {
            Log.get().error("Unable to parse Font: " + font, e);
            return null;
        }
    }

    public static String fontToString(Font font) {
        boolean dst = font.getStyle() == 0;
        boolean dsz = font.getStyle() == 12;
        return font.getName() + (!dst || !dsz ? separator + font.getStyle() + (!dsz ? separator + font.getSize() : "") : "");
    }
}

