/* *******************************************************
 * 
 * name:          Stretch.java
 * 
 * description:   SimpleModule which doubles the length 
 *                of the selected area of the wavefile.
 *
 * Author:        John Lyons
 *
 * (c) by         John Lyons     jlyons@yahoo.com
 *
 ********************************************************* */


public class Stretch implements StereoModule {

   /** 
    * Stretch, doubles the length of the selection
    */
   private short doStretch(short[] data,Selection sel)[] {
      // newwf -  new array for modified wave
      short[] newwf=new short[data.length+sel.getLength()];
      // Copy left of selection
      if (sel.start > 0)
         System.arraycopy(data, 0, newwf, 0, sel.start);
      // Double the size of the selection
      int i; int j = sel.start;
      for (i = sel.start; i <= sel.end; i++)
         newwf[j++] = newwf[j++] = data[i];
      // Copy right of selection
      System.arraycopy(data, sel.end+1, newwf, j, data.length-sel.end-1);
      // return new array
      return newwf;
   }
   
   public void apply(WaveFile waveFile,Selection sel) {
      // Stretch it
      waveFile.setWaves(
        doStretch(waveFile.getLeftWave(),sel),
        doStretch(waveFile.getRightWave(),sel));
      // double selection
      sel.end=sel.end+sel.getLength();
   }
}
