/* *******************************************************
 * 
 * name:          Lang.java
 * 
 * description:   Array of multi-language Strings
 *                specific to JaWavedit
 *
 * Author:        Florian Bomers
 *
 * (c) 1997       JaWavedit-Team
 *                JaWavedit@bome.com
 *
 ********************************************************* */

import java.util.Locale;

/**
 * use this class to access language-dependent strings.<BR>
 * use the function <code>getStr</code> to get a string. For example,
 * a call to <code>Lang.getStr(Lang.EMPTY)</code> returns
 * &quot;Empty&quot;, &quot;Leer&quot; or &quot;Vide&quot;. The
 * actual string returned is dependent on the current setting
 * for the language.<BR>
 * <BR>
 * To get the current language, call <code>Lang.getLangIndex()</code>.
 * This function, defined in the base class <code>Lang</code>, 
 * returns an index from 0..2, where 0 means English, 1 Deutsch and
 * 2 means Francais.<BR>
 * To retrieve the name of a language as String, call 
 * <code>Lang.getLangName()</code>.<BR>
 * <BR>
 * If you would like to add a language to JaWavedit, have a look
 * at MCK/sorces. There you will find the source code of LangBase and
 * Lang. Add to all arrays the corresponding values and send the
 * new files to us per email. We will then include them in the
 * next release. <BR>
 * To test your language module, it may be possible to compile them
 * and put them in the JaWavedit directory. However, we have not
 * tested this possibility yet.
 */

 public class Lang extends LangBase {

  public static final int EMPTY=1000;
  public static final int EVERYTH_FINE=1001;
  public static final int HELP_FILE=1002;
  public static final int SEL_LEFT=1003;
  public static final int SEL_RIGHT=1004;
  public static final int SEL_BOTH=1005;
  public static final int FORMAT=1006;
  public static final int MIX_PASTE=1007;
  public static final int MODULES=1008;
  public static final int LEFT_SIDE=1009;
  public static final int RIGHT_SIDE=1010;
  public static final int BOTH_SIDES=1011;
  public static final int EXTEND_BEGIN=1012;
  public static final int EXTEND_END=1013;
  public static final int ZOOM=1014;
  public static final int ZOOM_IN=1015;
  public static final int ZOOM_OUT=1016;
  public static final int ZOOM_ALL=1017;
  public static final int UNDO_ENABLED=1018;
  public static final int RELOAD_MODULES=1019;
  public static final int WAVEFILE=1020;
  public static final int CLOSE_WINDOW=1021;
  public static final int LENGTH=1022;
  public static final int SAMPLES=1023;
  public static final int LOADING_MODULE=1024;
  public static final int IS_INTERFACE=1025;
  public static final int DOES_NOT_IMPLEMENT=1026;
  public static final int LOADING_MODULES=1027;
  public static final int ERR_NO_PREV_INST=1028;
  public static final int MODULE_RUNNING_S=1029;
  public static final int MODULE=1030;
  public static final int SUCC_EXECUTED_S=1031;
  public static final int HAVENT_LOADED=1032;
  public static final int R=1033; //Right
  public static final int L=1034; //Left
  public static final int B=1035; //Both
  public static final int ZOOM_BEGIN=1036;
  public static final int ZOOM_END=1037;
  public static final int SEL_BEGIN=1038;
  public static final int SEL_END=1039;
  public static final int VOLUME=1040;
  public static final int BALANCE=1041;
  public static final int SPEED=1042;
  public static final int REWIND=1043;
  public static final int PLAY=1044;
  public static final int FORWARD=1045;
  public static final int PAUSE=1046;
  public static final int STOP=1047;
  public static final int LOOP=1048;
  public static final int PARAMETERS=1049;
  public static final int SAVE_FORMAT=1050;
  public static final int WOUT_CHANGING=1051;
  public static final int ONLY_PARAS=1052;
  public static final int NEXT_START=1053;
  public static final int NOT_SUPPORTED_S=1054;
  public static final int IS_CORRUPT_S=1055;
  public static final int ERROR_OPENING_S=1056;
  public static final int ERROR_SAVING_S=1057;
  public static final int NEITHER_WAV_AU_S=1058;
  public static final int COMPILE_ALL=1059;
  public static final int COMPILE=1060;
  public static final int NOT_SUPPORTED=1061;
  public static final int COMPILED_SUCCESFULLY_S=1062;
  public static final int COMPILE_ERROR_S=1063;
  public static final int COMPILED_ALL_SUCCESFULLY=1064;
  public static final int COMPILE_ALL_ERROR=1065;
  public static final int COMPILING_S=1066;
  
  //Lang.getStr(Lang.]
  // first index: language, 2nd index: which String (see constants above)
  public static final String ext[][]={
    {"(empty)","Everything fine.","Help",
     "Select left side","Select right side","Select both sides",
     "Format...","Mix Paste",
     "Modules",
     "Left side","Right side","Both Sides",
     "Extend to begin","Extend to end",
     "Zoom","Zoom in","Zoom out","Total view",
     "Undo enabled","Reload Modules",
     "Wavefile","Close this Window",
     "Length","samples",
     "Loading Module ",
     "is Interface !",
     "does not implement SimpleModule or StereoModule",
     "Loading Modules...",
     "Error: No previous instance",
     "Module %s is running...","Module","%s succesfully executed.",
     "You haven't loaded or created a wavefile.",
     "R","L","B",
     "Zoom begin:","Zoom end:",
     "Sel begin:","Sel end:",
     "Volume","Balance","Speed",
     "Rewind","Play","Forward","Pause","Stop","Loop",
     "Parameters","Save format",
     "Without changing of data,","only parameters.",
     "This change will be effective the next start of the program.",
     "The format of %s is not supported","%s is corrupt.",
     "Error opening %s.", "Error saving %s.",
     "%s is neither .wav nor .au",
     "Compile All","Compile","(not supported)",
     "%s compiled successfully.","Error while compiling %s.",
     "Compiled all modules succesfully.","There were errors while compiling.","Compiling %s..."
    },
    // deutsch
    {
    "(leer)","Alles in Ordnung.","Hilfe",
    "Linke Seite auswhlen","Rechte Seite auswhlen","Beide Seiten auswhlen",
    "Format...","Einfgen und mischen",
    "Module",
    "Linke Seite","Rechte Seite","Beide Seiten",
    "Zum Anfang erweitern","Zum Ende erweitern",
    "Zoom","Rein-Zoomen","Raus-Zoomen","Gesamtansicht",
    "Undo verfgbar","Module nachladen",
    "Audio-Datei","Dieses Fenster schlieen",
    "Lnge","samples",
    "Lade Modul ",
    "ist ein Interface !",
    "hat nicht SimpleModule oder Stereomodul in der implements-Anweisung.",
    "Module werden geladen...",
    "Fehler: Keine vorherige Instanz vorhanden.",
    "Modul %s luft...","Modul","%s wurde erfolgreich ausgefhrt.",
    "Sie haben keine Audio-Datei geffnet oder erzeugt.",
    "R","L","B",
    "Zoom Anfang:","Zoom Ende:",
    "Mark. Anfang:","Mark. Ende:",
    "Lautstrke","Balance","Geschwindigkeit",
    "Zurckspulen","Abspielen","Vorspulen","Pause","Stop","Loopen",
    "Parameter","Speicherformat",
    "Ohne die Daten zu ndern,","nur die Parameter.",
    "Diese nderung wird beim nchsten Programmstart zur Verfgung stehen.",
    "Das Format von %s wird nicht untersttzt.","%s ist korrupt.",
    "Fehler beim ffnen von %s.", "Fehler beim Speichern von %s.",
    "%s ist weder im Format au noch Format wav.",
    "Alle Kompilieren","Kompiliere","(nicht untersttzt)",
    "%s wurde erfolgreich kompiliert.","Fehler beim kompilieren von %s.",
     "Alle Module wurden erfolgreich kompiliert.","Es traten Fehler beim Kompilieren auf.","Kompiliere %s..."
    },
    //francais
    {
    "(vide)","Tout est bien.","Aide",
    "Slectionner cot gauche","Slectionner cot droite","Slectionner les deux cots",
    "Format...","Coller mlange",
    "Modules",
    "Gauche","Droite","Gauche et Droite",
    "Extension du Dbut","Extension  la fin",
    "Zoom","Zoom plus","Zoom moins","Vue totale",
    "Annuler active","Recharger les modules",
    "Fichier audio","Fermer cette fentre",
    "Longeur","echant.",
    "Charge Module ",
    "est un Interface !",
    "n'a pas SimpleModule ou StereoModule dans la partie implements",
    "Chargements des modules...",
    "Erreur: Il n'y a pas une instance prcdente.",
    "Dmarr module %s...","Module","Excut %s avec succs.",
    "Vous n'avez pas charger ou cree un fichier audio.",
    "D","G","E",
    "Zoom dbut:","Zoom fin:",
    "Sel dbut:","Sel fin:",
    "Volume","Balance","Vitesse",
    "Rembobiner","Lecture","Avancer","Pause","Stopper","Boucler",
    "Paramtres","Format d'enregistrer",
    "Les donnes ne vont pas tre changes,","seulement les paramtres.",
    "Ce changement va tre disponible la prochaine dmarrage du programme.",
    "Le format de %s n'est pas support.","%s est cass.",
    "Erreur de lecture de %s.", "Erreur d'ecriture de %s.",
    "%s est ni format au, ni format wav.",
    "Compiler tout","Compile","(pas support)",
    "%s compil avec succs.","Erreur pendant la compilation de %s.",
    "Toutes les modules sont compil avec succs.","Erreur pendant la compilation.","Compile %s..."
    }
  };
  
  public static String getStr(int constant) {
    return (constant>=1000 ? ext[lang][constant-1000]:std[lang][constant]);
  }


}
