/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.audio;

import ch.laoe.audio.AFileOptions;
import ch.laoe.audio.AFileOptionsFactory;
import ch.laoe.audio.AudioException;
import ch.laoe.audio.AudioListener;
import ch.laoe.audio.AudioPlotter;
import ch.laoe.audio.capture.ACapture;
import ch.laoe.audio.capture.ACaptureFactory;
import ch.laoe.audio.load.ALoad;
import ch.laoe.audio.load.ALoadFactory;
import ch.laoe.audio.play.APlay;
import ch.laoe.audio.play.APlayFactory;
import ch.laoe.audio.save.ASave;
import ch.laoe.audio.save.ASaveFactory;
import ch.laoe.clip.AChannel;
import ch.laoe.clip.AClip;
import ch.laoe.clip.AClipStorage;
import ch.laoe.clip.ALayer;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.LProgressViewer;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Audio
implements Runnable {
    private AClip clip;
    private AudioFileFormat.Type fileType;
    public static FileTypeLaoe fileTypeLaoe = new FileTypeLaoe();
    private AFileOptions fileOptions;
    private AudioFormat.Encoding encoding;
    private File file;
    private Thread audioThread;
    private boolean running;
    private Object monitor;
    private boolean looping = false;
    private boolean autoGrowing = false;
    public static final int STOP = 1;
    public static final int PLAY = 2;
    public static final int PAUSE = 3;
    public static final int REC = 4;
    private int state;
    private APlay player;
    private int playOffset;
    private static int playPacketSize = 3000;
    private static int playPointerAdjustment = -40000;
    private int winding;
    private static final int FORWIND = 1;
    private static final int REWIND = 2;
    private static final int OFFWIND = 0;
    private ACapture capture;
    private int captureOffset;
    private static int capturePacketSize = 3000;
    private static int capturePointerAdjustment = -40000;
    private int stateBeforePause;
    private AudioListener listener;
    private int playPointer;
    private int loopStartPointer;
    private int loopEndPointer;
    protected AudioPlotter plotter;

    public Audio(AClip aClip) {
        this.clip = aClip;
        this.state = 1;
        this.playPointer = 0;
        this.loopStartPointer = 0;
        this.setLoopEndPointer(aClip.getMaxSampleLength());
        this.audioThread = new Thread(this);
        this.audioThread.setPriority(10);
        this.running = true;
        this.audioThread.start();
        this.plotter = new AudioPlotter(this);
    }

    public AClip getClip() {
        return this.clip;
    }

    public AudioFileFormat.Type getFileType() {
        return this.fileType;
    }

    public void setFileType(AudioFileFormat.Type type) {
        this.fileType = type;
    }

    public void setFileType(String string) {
        if (string.equals(".laoe")) {
            this.setFileType(fileTypeLaoe);
        } else if (string.equals(".wav")) {
            this.setFileType(AudioFileFormat.Type.WAVE);
        } else if (string.equals(".au")) {
            this.setFileType(AudioFileFormat.Type.AU);
        } else if (string.equals(".snd")) {
            this.setFileType(AudioFileFormat.Type.SND);
        } else if (string.equals(".aifc")) {
            this.setFileType(AudioFileFormat.Type.AIFC);
        } else if (string.equals(".aiff")) {
            this.setFileType(AudioFileFormat.Type.AIFF);
        }
    }

    public static AudioFileFormat.Type[] getAllFileTypes() {
        AudioFileFormat.Type[] typeArray = new AudioFileFormat.Type[]{fileTypeLaoe, AudioFileFormat.Type.AIFC, AudioFileFormat.Type.AIFF, AudioFileFormat.Type.AU, AudioFileFormat.Type.SND, AudioFileFormat.Type.WAVE};
        return typeArray;
    }

    public static AFileOptions createFileOptions(String string) {
        return AFileOptionsFactory.create(string);
    }

    public void setFileOptions(AFileOptions aFileOptions) {
        this.fileOptions = aFileOptions;
    }

    public AFileOptions getFileOptions() {
        return this.fileOptions;
    }

    public static String getAudioSystemInfo() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        stringBuffer.append("AudioSystem:\n");
        stringBuffer.append("\naudio file types:\n");
        AudioFileFormat.Type[] typeArray = AudioSystem.getAudioFileTypes();
        for (n = 0; n < typeArray.length; ++n) {
            stringBuffer.append("  " + typeArray[n].toString() + "\n");
        }
        for (n = 0; n < infoArray.length; ++n) {
            try {
                stringBuffer.append("mixer[" + n + "] = " + infoArray[n].toString() + "\n");
                Line.Info[] infoArray2 = AudioSystem.getMixer(infoArray[n]).getTargetLineInfo();
                stringBuffer.append("  number of target lines = " + infoArray2.length + "\n");
                for (int i = 0; i < infoArray2.length; ++i) {
                    stringBuffer.append("    target line[" + i + "] = " + infoArray2[i].toString() + "\n");
                    AudioFormat[] audioFormatArray = ((DataLine.Info)infoArray2[i]).getFormats();
                    for (int j = 0; j < audioFormatArray.length; ++j) {
                        stringBuffer.append("      format[" + j + "] = " + audioFormatArray[j].toString() + "\n");
                    }
                }
                Line.Info[] infoArray3 = AudioSystem.getMixer(infoArray[n]).getSourceLineInfo();
                stringBuffer.append("  number of source lines = " + infoArray3.length + "\n");
                for (int i = 0; i < infoArray3.length; ++i) {
                    stringBuffer.append("    source line[" + i + "] = " + infoArray3[i].toString() + "\n");
                    AudioFormat[] audioFormatArray = ((DataLine.Info)infoArray3[i]).getFormats();
                    for (int j = 0; j < audioFormatArray.length; ++j) {
                        stringBuffer.append("      format[" + j + "] = " + audioFormatArray[j].toString() + "\n");
                    }
                }
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return new String(stringBuffer);
    }

    public AudioFormat.Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(AudioFormat.Encoding encoding) {
        this.encoding = encoding;
    }

    public static AudioFormat.Encoding[] getAllEncodings() {
        AudioFormat.Encoding[] encodingArray = new AudioFormat.Encoding[]{AudioFormat.Encoding.ALAW, AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED, AudioFormat.Encoding.ULAW};
        return encodingArray;
    }

    public void open(File file) throws AudioException {
        boolean bl = false;
        try {
            bl = AClipStorage.supports(file);
        }
        catch (IOException iOException) {
            throw new AudioException("ioError");
        }
        catch (Exception exception) {
            Debug.printStackTrace(5, exception);
            throw new AudioException("unexpectedError");
        }
        if (bl) {
            try {
                AClipStorage.load(this.clip, file);
            }
            catch (IOException iOException) {
                throw new AudioException("ioError");
            }
            catch (Exception exception) {
                Debug.printStackTrace(5, exception);
                throw new AudioException("unexpectedError");
            }
        }
        ALoad aLoad = ALoadFactory.create(file);
        ALayer aLayer = new ALayer(aLoad.getChannels(), aLoad.getSampleLength());
        try {
            this.setFileType(AudioSystem.getAudioFileFormat(file).getType());
            this.setEncoding(AudioSystem.getAudioInputStream(file).getFormat().getEncoding());
            Debug.println(3, "open clip " + file.getName() + ", " + aLayer.getNumberOfChannels() + " channels, " + aLayer.getMaxSampleLength() + " samples, " + AudioSystem.getAudioInputStream(file).getFormat().getEncoding().toString() + " encoding, " + AudioSystem.getAudioInputStream(file).getFormat().getSampleSizeInBits() + " bits, big-endian " + AudioSystem.getAudioInputStream(file).getFormat().isBigEndian());
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            Debug.printStackTrace(5, unsupportedAudioFileException);
            throw new AudioException("unsupportedAudioFormat");
        }
        catch (IOException iOException) {
            Debug.printStackTrace(5, iOException);
            throw new AudioException("ioError");
        }
        catch (Exception exception) {
            Debug.printStackTrace(5, exception);
            throw new AudioException("unexpectedError");
        }
        int n = 0;
        int n2 = 0;
        try {
            int n3;
            LProgressViewer.getInstance().entrySubProgress(0.9, "loadSamples");
            while ((n3 = aLoad.read(aLayer, n, 4000)) >= 0) {
                Debug.println(3, "load sample " + (n += n3));
                if (n2++ % 256 == 0) {
                    LProgressViewer.getInstance().setNote(GLanguage.translate("load") + " " + n / (int)aLoad.getSampleRate() + " " + GLanguage.translate("seconds") + "...");
                    if (aLoad.getSampleLength() > 1 ? LProgressViewer.getInstance().setProgress(n / aLoad.getSampleLength()) : LProgressViewer.getInstance().setUnknownProgress()) {
                        return;
                    }
                }
                Thread.yield();
            }
            LProgressViewer.getInstance().exitSubProgress();
        }
        catch (IOException iOException) {
            Debug.printStackTrace(5, iOException);
            throw new AudioException("ioError");
        }
        catch (Exception exception) {
            Debug.printStackTrace(5, exception);
            throw new AudioException("unexpectedError");
        }
        aLoad.close();
        this.clip.add(aLayer);
        this.clip.setSampleRate(aLoad.getSampleRate());
        this.clip.setSampleWidth(aLoad.getSampleWidth());
        this.clip.getPlotter().autoScale();
        this.setLoopEndPointer(this.clip.getMaxSampleLength());
        this.file = file;
        this.clip.setName(file.getName());
    }

    public boolean save() throws AudioException {
        if (this.file != null && this.file.isFile()) {
            this.saveAs(this.getFile());
            return true;
        }
        return false;
    }

    public void saveAs(File file) throws AudioException {
        if (file.isDirectory()) {
            throw new AudioException("isDirectory");
        }
        this.setFile(file);
        this.clip.setName(file.getName());
        boolean bl = false;
        try {
            bl = AClipStorage.supports(file);
        }
        catch (IOException iOException) {
            Debug.printStackTrace(5, iOException);
            throw new AudioException("ioError");
        }
        catch (Exception exception) {
            Debug.printStackTrace(5, exception);
            throw new AudioException("unexpectedError");
        }
        if (bl) {
            try {
                AClipStorage.save(this.clip, file);
            }
            catch (IOException iOException) {
                Debug.printStackTrace(5, iOException);
                throw new AudioException("ioError");
            }
            catch (Exception exception) {
                Debug.printStackTrace(5, exception);
                throw new AudioException("unexpectedError");
            }
        }
        if (this.clip.getNumberOfLayers() > 1 || this.clip.getMaxNumberOfChannels() > 2) {
            throw new AudioException("layerChannelOutOfRange");
        }
        String string = file.getName();
        if (string.endsWith(".wav")) {
            this.setFileType(AudioFileFormat.Type.WAVE);
            this.setEncoding(AudioFormat.Encoding.PCM_SIGNED);
        } else if (string.endsWith(".aiff")) {
            this.setFileType(AudioFileFormat.Type.AIFF);
            this.setEncoding(AudioFormat.Encoding.PCM_SIGNED);
        } else {
            if (string.endsWith(".snd")) {
                throw new AudioException("unsupportedAudioFormat");
            }
            if (string.endsWith(".au")) {
                throw new AudioException("unsupportedAudioFormat");
            }
            throw new AudioException("unsupportedAudioFormat");
        }
        this.clip.prepareMask();
        ASave aSave = ASaveFactory.create(this.clip, file);
        Debug.println(3, "file=" + file);
        Debug.println(3, "save clip as " + file.getName() + ", " + this.clip.getMaxNumberOfChannels() + " channels, " + this.clip.getMaxSampleLength() + " samples, " + this.getEncoding().toString() + " encoding, " + this.clip.getSampleWidth() + " bits, big-endian " + this.clip.isBigEndian());
        try {
            LProgressViewer.getInstance().entrySubProgress(0.9, "saveSamples");
            aSave.write();
            LProgressViewer.getInstance().exitSubProgress();
        }
        catch (IOException iOException) {
            Debug.printStackTrace(5, iOException);
            throw new AudioException("ioError");
        }
        catch (Exception exception) {
            Debug.printStackTrace(5, exception);
            throw new AudioException("unexpectedError");
        }
    }

    private void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void run() {
        this.monitor = new Object();
        block9: while (this.running) {
            try {
                Thread.currentThread().setPriority(10);
                Thread.yield();
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                switch (this.state) {
                    case 2: {
                        this.onPlay();
                        continue block9;
                    }
                    case 4: {
                        this.onRec();
                        continue block9;
                    }
                    case 3: {
                        continue block9;
                    }
                }
                this.doWait();
            }
            catch (Exception exception) {
                Debug.printStackTrace(5, exception);
            }
        }
    }

    public void destroy() {
        this.running = false;
        this.clip = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWait() {
        try {
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeup() {
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notify();
        }
    }

    public void setLooping(boolean bl) {
        this.looping = bl;
    }

    public boolean isLooping() {
        return this.looping;
    }

    public void setAutoGrowing(boolean bl) {
        this.autoGrowing = bl;
        if (this.autoGrowing) {
            this.looping = false;
        }
    }

    public boolean isAutoGrowing() {
        return this.autoGrowing;
    }

    public static void setPlayBlockSize(int n) {
        playPacketSize = n;
    }

    public static int getPlayBlockSize() {
        return playPacketSize;
    }

    public static void setPlayPointerAdjustment(int n) {
        playPointerAdjustment = n;
    }

    public static int getPlayPointerAdjustment() {
        return playPointerAdjustment;
    }

    public void play() throws AudioException {
        this.noWinding();
        if (this.state == 1) {
            this.clip.prepareMask();
            this.playOffset = this.getLoopStartPointer();
            this.player = APlayFactory.create(this.clip);
            this.player.goTo(this.playOffset);
            this.player.start();
            Debug.println(3, "start playing...");
            this.state = 2;
        }
        this.wakeup();
        this.fireAudioEvent();
    }

    public synchronized void scratch(int n) {
        try {
            switch (this.state) {
                case 2: 
                case 3: {
                    int n2;
                    if (n < 0) {
                        n = 0;
                    }
                    if (n > (n2 = this.getLoopEndPointer() - playPacketSize)) {
                        n = n2 - 1;
                    }
                    this.player.goTo(n);
                    this.player.write(playPacketSize);
                    this.setPlayPointer(n);
                    this.playOffset = n;
                    Debug.println(7, "scratch...");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void onPlay() {
        try {
            int n = this.getLoopEndPointer() - this.playOffset;
            boolean bl = true;
            if (n > playPacketSize) {
                n = playPacketSize;
                bl = false;
            } else if (n < 0) {
                n = 0;
            }
            int n2 = this.player.write(n);
            Debug.println(8, "play sample " + this.playOffset + ", packet size " + n + " written " + n2);
            this.onWinding();
            if (bl || n2 < 0) {
                if (!this.looping) {
                    this.state = 1;
                    this.playOffset = this.getLoopEndPointer();
                    this.setPlayPointer(this.getLoopEndPointer());
                    Debug.println(3, "...autostop playing");
                    this.fireAudioEvent();
                    return;
                }
                this.playOffset = this.getLoopStartPointer();
                this.player.goTo(this.playOffset);
                Debug.println(3, "...loop back");
            } else {
                this.playOffset += n2;
            }
            this.setPlayPointer(this.playOffset + playPointerAdjustment);
            return;
        }
        catch (Exception exception) {
            Debug.println(3, "...play problem!!!");
            exception.printStackTrace();
            this.state = 1;
            this.player.stop();
            this.fireAudioEvent();
        }
    }

    public void changeSampleRate(float f) {
        if (this.player != null) {
            this.player.changeSampleRate(f);
        }
    }

    public void forwind() {
        this.winding = 1;
    }

    public void rewind() {
        this.winding = 2;
    }

    public void noWinding() {
        this.winding = 0;
    }

    private void onWinding() {
        switch (this.winding) {
            case 1: {
                this.playOffset += 2 * playPacketSize;
                this.player.goTo(this.playOffset);
                break;
            }
            case 2: {
                this.playOffset -= 3 * playPacketSize;
                if (this.playOffset < 0) {
                    this.playOffset = 0;
                    this.noWinding();
                }
                this.player.goTo(this.playOffset);
            }
        }
    }

    public void stop() {
        this.noWinding();
        this.state = 1;
        if (this.player != null) {
            this.player.flush();
            this.player.stop();
            this.player = null;
        }
        if (this.capture != null) {
            this.capture.stop();
            this.capture = null;
        }
        Debug.println(3, "...stop");
        this.fireAudioEvent();
    }

    public static void setCaptureBlockSize(int n) {
        capturePacketSize = n;
    }

    public static int getCaptureBlockSize() {
        return capturePacketSize;
    }

    public static void setCapturePointerAdjustment(int n) {
        capturePointerAdjustment = n;
    }

    public static int getCapturePointerAdjustment() {
        return capturePointerAdjustment;
    }

    public void rec() throws AudioException {
        if (this.state == 1) {
            this.captureOffset = this.getLoopStartPointer();
            this.capture = ACaptureFactory.create(this.clip, this.clip.getSelectedLayer());
            Debug.println(3, "start recording...");
            this.state = 4;
            this.wakeup();
            this.fireAudioEvent();
        }
    }

    private synchronized void onRec() {
        try {
            int n;
            if (this.autoGrowing) {
                n = capturePacketSize;
            } else {
                n = this.getLoopEndPointer() - this.captureOffset;
                if (n > capturePacketSize) {
                    n = capturePacketSize;
                }
            }
            int n2 = this.capture.read(this.captureOffset, n);
            this.clip.getSelectedLayer().markChange();
            Debug.println(8, "capture sample " + this.captureOffset + ", packet size " + n + " read " + n2);
            this.captureOffset += n2;
            this.setPlayPointer(this.captureOffset + capturePointerAdjustment);
            if (this.looping) {
                if (n < capturePacketSize || n2 < 0) {
                    this.captureOffset = this.getLoopStartPointer();
                    Debug.println(3, "...loop back");
                }
            } else if (n < capturePacketSize || n2 < 0) {
                this.state = 1;
                this.capture.stop();
                Debug.println(3, "...autostop capture");
                this.fireAudioEvent();
            }
        }
        catch (Exception exception) {
            Debug.println(3, "...recording problem!!!");
            this.state = 1;
            this.capture.stop();
            this.fireAudioEvent();
            Debug.printStackTrace(5, exception);
        }
    }

    public void pause() {
        if (this.state != 3) {
            this.stateBeforePause = this.state;
            if (this.player != null) {
                this.player.flush();
            }
            this.state = 3;
            Debug.println(3, "...pause...");
        } else {
            this.state = this.stateBeforePause;
            this.wakeup();
            Debug.println(3, "...continue...");
        }
        this.fireAudioEvent();
    }

    public boolean isActive() {
        switch (this.state) {
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public int getState() {
        return this.state;
    }

    public void setAudioListener(AudioListener audioListener) {
        this.listener = audioListener;
    }

    private void fireAudioEvent() {
        this.listener.onStateChange(this.getState());
    }

    public float getPeakLevel(int n) {
        float f = 0.0f;
        float f2 = 0.0f;
        switch (this.state) {
            case 2: {
                int n2 = this.clip.getMaxSampleLength();
                for (int i = this.playPointer; i < this.playPointer + playPacketSize; ++i) {
                    if (this.player != null) {
                        f2 = Math.abs(this.player.getSample(n, i % n2));
                    }
                    if (!(f2 > f)) continue;
                    f = f2;
                }
                return f;
            }
            case 4: {
                AChannel aChannel = this.clip.getSelectedLayer().getChannel(n);
                int n3 = this.clip.getSelectedLayer().getMaxSampleLength();
                for (int i = this.playPointer; i < this.playPointer + capturePacketSize; ++i) {
                    f2 = Math.abs(aChannel.getSample(i % n3));
                    if (!(f2 > f)) continue;
                    f = f2;
                }
                return f;
            }
        }
        return 0.0f;
    }

    private int limitLoopPointerRange(int n) {
        int n2 = this.clip.getMaxSampleLength();
        if (n < 0) {
            return 0;
        }
        if (n > n2 - 1) {
            return n2 - 1;
        }
        return n;
    }

    public void setPlayPointer(int n) {
        this.playPointer = this.limitLoopPointerRange(n);
    }

    public int getPlayPointer() {
        return this.playPointer;
    }

    public void setLoopStartPointer(int n) {
        this.loopStartPointer = this.limitLoopPointerRange(n);
        if (this.loopStartPointer > this.loopEndPointer) {
            this.loopEndPointer = this.loopStartPointer;
        }
    }

    public int getLoopStartPointer() {
        return this.loopStartPointer;
    }

    public void setLoopEndPointer(int n) {
        this.loopEndPointer = this.limitLoopPointerRange(n);
        if (this.loopEndPointer < this.loopStartPointer) {
            this.loopStartPointer = this.loopEndPointer;
        }
    }

    public int getLoopEndPointer() {
        return this.loopEndPointer;
    }

    public void limitLoopPointers() {
        this.setLoopStartPointer(this.getLoopStartPointer());
        this.setLoopEndPointer(this.getLoopEndPointer());
    }

    public AudioPlotter getPlotter() {
        return this.plotter;
    }

    public static class FileTypeLaoe
    extends AudioFileFormat.Type {
        public FileTypeLaoe() {
            super("LAoE", ".laoe");
        }
    }
}

