/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.audio.capture;

import ch.laoe.audio.AudioException;
import ch.laoe.audio.capture.ACapture;
import ch.laoe.audio.capture.ACapturePcmSigned16BitBigEndian;
import ch.laoe.audio.capture.ACapturePcmSigned16BitLittleEndian;
import ch.laoe.audio.capture.ACapturePcmSigned8Bit;
import ch.laoe.audio.capture.ACapturePcmUnsigned16BitBigEndian;
import ch.laoe.audio.capture.ACapturePcmUnsigned16BitLittleEndian;
import ch.laoe.audio.capture.ACapturePcmUnsigned8Bit;
import ch.laoe.clip.AClip;
import ch.laoe.clip.ALayer;
import ch.laoe.ui.Debug;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;

public class ACaptureFactory {
    private static ArrayList<ACapture> classList;

    private static void preloadClasses() {
        classList = new ArrayList();
        classList.add(new ACapturePcmUnsigned8Bit());
        classList.add(new ACapturePcmSigned8Bit());
        classList.add(new ACapturePcmUnsigned16BitLittleEndian());
        classList.add(new ACapturePcmUnsigned16BitBigEndian());
        classList.add(new ACapturePcmSigned16BitLittleEndian());
        classList.add(new ACapturePcmSigned16BitBigEndian());
    }

    public static final ACapture create(AClip aClip, ALayer aLayer) throws AudioException {
        AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, aClip.getSampleRate(), aClip.getSampleWidth(), aLayer.getNumberOfChannels(), aClip.getSampleWidth() / 8 * aLayer.getNumberOfChannels(), aClip.getSampleRate(), false);
        ACapture aCapture = ACaptureFactory.create(audioFormat);
        if (aCapture == null) {
            throw new AudioException("unsupportedAudioFormat");
        }
        aCapture.setLayer(aLayer);
        if (!AudioSystem.isLineSupported(new DataLine.Info(TargetDataLine.class, audioFormat))) {
            throw new AudioException("missingAudioResource");
        }
        TargetDataLine targetDataLine = null;
        try {
            targetDataLine = AudioSystem.getTargetDataLine(audioFormat);
            targetDataLine.open();
            targetDataLine.start();
            aCapture.setLine(targetDataLine);
        }
        catch (LineUnavailableException lineUnavailableException) {
            targetDataLine.stop();
            targetDataLine.close();
            Debug.printStackTrace(5, lineUnavailableException);
            throw new AudioException("missingAudioResource");
        }
        return aCapture;
    }

    private static final ACapture create(AudioFormat audioFormat) {
        for (int i = 0; i < classList.size(); ++i) {
            ACapture aCapture = classList.get(i);
            if (!aCapture.supports(audioFormat)) continue;
            return aCapture.duplicate();
        }
        return null;
    }

    static {
        ACaptureFactory.preloadClasses();
    }
}

