/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.clip.AModel;
import ch.laoe.ui.LProgressViewer;
import java.util.ArrayList;

public abstract class AContainerModel
extends AModel {
    private ArrayList<AModel> elements = new ArrayList();
    protected int selectedIndex = 0;

    @Override
    public void destroy() {
        super.destroy();
        this.removeAll();
    }

    public void add(AModel aModel) {
        aModel.setParent(this);
        this.elements.add(aModel);
    }

    public void insert(AModel aModel, int n) {
        aModel.setParent(this);
        this.elements.add(n, aModel);
    }

    public AModel get(int n) {
        return this.elements.get(n);
    }

    public boolean contains(AModel aModel) {
        for (int i = 0; i < this.getNumberOfElements(); ++i) {
            if (this.get(i) != aModel) continue;
            return true;
        }
        return false;
    }

    public void remove(int n) {
        if (this.elements.size() > 1) {
            AModel aModel = this.elements.get(n);
            aModel.destroy();
            this.elements.remove(aModel);
            System.gc();
        }
    }

    public void removeAll() {
        LProgressViewer.getInstance().entrySubProgress(0.3);
        for (int i = 0; i < this.elements.size(); ++i) {
            LProgressViewer.getInstance().setProgress(1.0 * (double)(i + 1) / (double)this.elements.size());
            this.elements.get(i).destroy();
        }
        this.elements.clear();
        System.gc();
        LProgressViewer.getInstance().exitSubProgress();
    }

    public int getNumberOfElements() {
        return this.elements.size();
    }

    public void moveUp(int n) {
        if (n < this.getNumberOfElements() - 1 && n >= 0) {
            AModel aModel = this.elements.get(n + 1);
            this.elements.set(n + 1, this.elements.get(n));
            this.elements.set(n, aModel);
        }
    }

    public void moveDown(int n) {
        this.moveUp(n - 1);
    }

    public AModel getTop() {
        return this.elements.get(this.getNumberOfElements() - 1);
    }

    public AModel getBottom() {
        return this.elements.get(0);
    }

    public AModel getSelected() {
        return this.get(this.getSelectedIndex());
    }

    public int getSelectedIndex() {
        if (this.selectedIndex >= this.elements.size()) {
            this.selectedIndex = this.elements.size() - 1;
        }
        if (this.selectedIndex < 0) {
            this.selectedIndex = 0;
        }
        return this.selectedIndex;
    }

    public void setSelectedIndex(int n) {
        this.selectedIndex = n;
    }

    public int getMaxNumberOfSubElements() {
        int n = 0;
        for (int i = 0; i < this.elements.size(); ++i) {
            int n2 = ((AContainerModel)this.elements.get(i)).getNumberOfElements();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }
}

