/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannel2DSelection;
import ch.laoe.clip.AChannelMask;
import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.AClip;
import ch.laoe.clip.AContainerModel;
import ch.laoe.clip.ALayer2DSelection;
import ch.laoe.clip.ALayerPlotter;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.clip.AModel;
import ch.laoe.operation.AOMix;
import ch.laoe.plugin.GPSpectrogramSelect;
import ch.laoe.ui.GEditableArea;
import ch.laoe.ui.GLanguage;
import java.awt.Point;

public class ALayer
extends AContainerModel {
    private int plotType;
    public static final int SAMPLE_CURVE_TYPE = 1;
    public static final int SPECTROGRAM_TYPE = 2;
    private static int nameCounter;
    private int type;
    public static final int SOLO_AUDIO_LAYER = 0;
    public static final int AUDIO_LAYER = 1;
    public static final int PARAMETER_LAYER = 2;

    public ALayer() {
        this.type = 1;
        this.plotType = 1;
        this.selection = new ALayerSelection(this);
        this.plotter = new ALayerPlotter(this);
    }

    public ALayer(int n) {
        this.type = 1;
        this.plotType = 1;
        this.selection = new ALayerSelection(this);
        this.plotter = new ALayerPlotter(this);
        for (int i = 0; i < n; ++i) {
            this.add(new AChannel());
        }
        this.setStandardChannelNames();
    }

    public ALayer(int n, int n2) {
        this.type = 1;
        this.plotType = 1;
        this.selection = new ALayerSelection(this);
        this.plotter = new ALayerPlotter(this);
        for (int i = 0; i < n; ++i) {
            this.add(new AChannel(n2));
        }
        this.setStandardChannelNames();
    }

    public ALayer(ALayer aLayer) {
        this.type = aLayer.type;
        this.plotType = 1;
        this.selection = new ALayerSelection(this);
        this.plotter = new ALayerPlotter(this);
        this.getPlotter().setColor(aLayer.getPlotter().getColor());
        this.name = GLanguage.translate("copyOf") + " " + aLayer.name;
        for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
            this.add(new AChannel(aLayer.getChannel(i)));
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    private void setStandardChannelNames() {
        int n = this.getNumberOfChannels();
        if (n == 1) {
            this.getChannel(0).setName(GLanguage.translate("mono"));
        } else if (n == 2) {
            this.getChannel(0).setName(GLanguage.translate("left"));
            this.getChannel(1).setName(GLanguage.translate("right"));
        }
    }

    public AClip getParentClip() {
        return (AClip)this.getParent();
    }

    public void markChange() {
        for (int i = 0; i < this.getNumberOfChannels(); ++i) {
            this.getChannel(i).markChange();
        }
    }

    @Override
    public void add(AModel aModel) {
        super.add(aModel);
        this.setType(this.type);
        ((AChannel)aModel).setPlotType(this.plotType);
    }

    @Override
    public void insert(AModel aModel, int n) {
        super.insert(aModel, n);
        this.setType(this.type);
        ((AChannel)aModel).setPlotType(this.plotType);
    }

    @Override
    public ALayerPlotter getPlotter() {
        return (ALayerPlotter)this.plotter;
    }

    public void setPlotType(int n) {
        this.plotType = n;
        for (int i = 0; i < this.getNumberOfChannels(); ++i) {
            this.getChannel(i).setPlotType(n);
        }
    }

    public int getPlotType() {
        return this.plotType;
    }

    @Override
    public void setDefaultName() {
        this.setDefaultName("layer", nameCounter++);
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public AChannel getChannel(int n) {
        return (AChannel)this.get(n);
    }

    public void mergeDownChannel(int n) {
        if (this.getNumberOfElements() > 1 && n > 0) {
            AChannelSelection aChannelSelection = this.getChannel(n - 1).createSelection();
            AChannelSelection aChannelSelection2 = this.getChannel(n).createSelection();
            ALayerSelection aLayerSelection = new ALayerSelection(this);
            aLayerSelection.addChannelSelection(aChannelSelection);
            aLayerSelection.addChannelSelection(aChannelSelection2);
            aLayerSelection.operateChannel0WithChannel1(new AOMix());
            this.remove(n);
        }
    }

    public void mergeAllChannels() {
        while (this.getNumberOfElements() > 1) {
            this.mergeDownChannel(1);
        }
    }

    public AChannel getSelectedChannel() {
        return (AChannel)this.getSelected();
    }

    public int getNumberOfChannels() {
        return this.getNumberOfElements();
    }

    public AChannel getChannel(Point point) {
        try {
            return this.getChannel(this.getPlotter().getInsideChannelIndex(point));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getMaxSampleLength() {
        int n = 0;
        for (int i = 0; i < this.getNumberOfElements(); ++i) {
            int n2 = this.getChannel(i).getSampleLength();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public float getMaxSampleValue() {
        float f = 0.0f;
        for (int i = 0; i < this.getNumberOfElements(); ++i) {
            float f2 = this.getChannel(i).getMaxSampleValue();
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public float getMaxSampleValue(int n, int n2) {
        float f = 0.0f;
        for (int i = 0; i < this.getNumberOfElements(); ++i) {
            float f2 = this.getChannel(i).getMaxSampleValue(n, n2);
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public void prepareMask() {
        for (int i = 0; i < this.getNumberOfChannels(); ++i) {
            this.getChannel(i).prepareMask();
        }
    }

    public boolean isMaskEnabled() {
        for (int i = 0; i < this.getNumberOfChannels(); ++i) {
            if (!this.getChannel(i).isMaskEnabled()) continue;
            return true;
        }
        return false;
    }

    public void setSelection(ALayerSelection aLayerSelection) {
        int n = Math.min(this.getNumberOfChannels(), aLayerSelection.getNumberOfChannelSelections());
        aLayerSelection.setLayer(this);
        for (int i = 0; i < n; ++i) {
            this.getChannel(i).setSelection(aLayerSelection.getChannelSelection(i));
            aLayerSelection.getChannelSelection(i).setChannel(this.getChannel(i));
        }
        this.selection = aLayerSelection;
    }

    @Override
    public ALayerSelection getSelection() {
        ALayerSelection aLayerSelection = new ALayerSelection(this);
        for (int i = 0; i < this.getNumberOfChannels(); ++i) {
            AChannelSelection aChannelSelection = this.getChannel(i).getSelection();
            if (!aChannelSelection.isSelected()) continue;
            aLayerSelection.addChannelSelection(aChannelSelection);
        }
        if (!aLayerSelection.isSelected()) {
            return this.createSelection();
        }
        return aLayerSelection;
    }

    public ALayer2DSelection get2DSelection() {
        ALayer2DSelection aLayer2DSelection = new ALayer2DSelection(this);
        for (int i = 0; i < this.getNumberOfChannels(); ++i) {
            AChannel2DSelection aChannel2DSelection = this.getChannel(i).get2DSelection();
            if (!aChannel2DSelection.isSelected()) continue;
            aLayer2DSelection.addChannelSelection(aChannel2DSelection);
        }
        return aLayer2DSelection;
    }

    public ALayerSelection createSelection() {
        ALayerSelection aLayerSelection = new ALayerSelection(this);
        for (int i = 0; i < this.getNumberOfChannels(); ++i) {
            aLayerSelection.addChannelSelection(this.getChannel(i).createSelection());
        }
        return aLayerSelection;
    }

    public void modifySelection(int n, int n2) {
        for (int i = 0; i < this.getNumberOfChannels(); ++i) {
            this.getChannel(i).modifySelection(n, n2);
        }
    }

    public void setFullSelection() {
        ALayerSelection aLayerSelection = new ALayerSelection(this);
        for (int i = 0; i < this.getNumberOfChannels(); ++i) {
            this.getChannel(i).setFullSelection();
            aLayerSelection.addChannelSelection(this.getChannel(i).getSelection());
        }
        this.selection = aLayerSelection;
    }

    public void setEmptySelection() {
        ALayerSelection aLayerSelection = new ALayerSelection(this);
        for (int i = 0; i < this.getNumberOfChannels(); ++i) {
            this.getChannel(i).setEmptySelection();
            aLayerSelection.addChannelSelection(this.getChannel(i).getSelection());
        }
        this.selection = aLayerSelection;
    }

    public void wideCopySelection(AChannelSelection aChannelSelection) {
        for (int i = 0; i < this.getNumberOfChannels(); ++i) {
            AChannel aChannel = this.getChannel(i);
            aChannel.getSelection().copy(aChannelSelection);
        }
    }

    public void wideCopyMask(AChannelMask aChannelMask) {
        for (int i = 0; i < this.getNumberOfChannels(); ++i) {
            AChannel aChannel = this.getChannel(i);
            aChannel.getMask().copy(aChannelMask);
        }
    }

    public void wideCopySpectrogramSelection(GEditableArea gEditableArea) {
        for (int i = 0; i < this.getNumberOfChannels(); ++i) {
            AChannel aChannel = this.getChannel(i);
            GPSpectrogramSelect.Cookie cookie = (GPSpectrogramSelect.Cookie)aChannel.getCookies().getCookie("spectrogramSelect");
            if (cookie == null) continue;
            cookie.area.copy(gEditableArea);
        }
    }
}

