/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.LProgressViewer;

public class AOHarmonicsGenerator
extends AOperation {
    private float[] amplitude;
    private float offset;
    private int basePeriod;
    private boolean add;

    public AOHarmonicsGenerator(float[] fArray, float f, int n, boolean bl) {
        this.amplitude = fArray;
        this.offset = f;
        this.basePeriod = n;
        this.add = bl;
    }

    @Override
    public void operate(AChannelSelection aChannelSelection) {
        int n;
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n2 = aChannelSelection.getOffset();
        int n3 = aChannelSelection.getLength();
        aChannelSelection.getChannel().markChange();
        MMArray mMArray2 = new MMArray(this.basePeriod, 0.0f);
        for (n = 0; n < mMArray2.getLength(); ++n) {
            mMArray2.set(n, this.offset);
            for (int i = 0; i < this.amplitude.length; ++i) {
                mMArray2.set(n, mMArray2.get(n) + this.amplitude[i] * (float)Math.sin((double)n / (double)this.basePeriod * 2.0 * Math.PI * (double)(i + 1)));
            }
        }
        for (n = 0; n < n3; ++n) {
            if (LProgressViewer.getInstance().setProgress((double)(n + 1) * 1.0 / (double)n3)) {
                return;
            }
            float f = this.add ? mMArray.get(n + n2) + mMArray2.get(n % mMArray2.getLength()) : mMArray2.get(n % mMArray2.getLength());
            mMArray.set(n + n2, aChannelSelection.mixIntensity(n + n2, mMArray.get(n + n2), f));
        }
    }
}

