/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.audio.Audio;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextX;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class GPClipProperties
extends GPluginFrame {
    protected UiControlText samples;
    protected UiControlText sampleRate;
    protected UiControlText sampleWidth;
    protected UiControlText channels;
    protected UiControlText layers;
    protected JTextArea comments;
    protected JComboBox fileType;
    protected JComboBox encoding;
    protected JPanel pFormat;
    protected JButton apply;
    private EventDispatcher eventDispatcher;

    public GPClipProperties(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "clipProperties";
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void reload() {
        super.reload();
        this.loadValues();
    }

    protected void initGui() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel2, 16, 3);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel2.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("samples")), 0, 0, 4, 1);
        this.samples = new GControlTextX(Laoe.getInstance(), 10, true, true);
        this.samples.setDataRange(0.0, 1.0E10);
        uiCartesianLayout.add(this.samples, 4, 0, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("sampleRate")), 0, 1, 4, 1);
        this.sampleRate = new UiControlText(8, true, false);
        this.sampleRate.setNumberFormat(1);
        this.sampleRate.setDataRange(100.0, 100000.0);
        uiCartesianLayout.add(this.sampleRate, 4, 1, 4, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("width")), 11, 1, 2, 1);
        this.sampleWidth = new UiControlText(3, true, false);
        this.sampleWidth.setNumberFormat(2);
        this.sampleWidth.setDataRange(1.0, 32.0);
        uiCartesianLayout.add(this.sampleWidth, 13, 1, 3, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("layers")), 0, 2, 4, 1);
        this.layers = new UiControlText(3, true, false);
        this.layers.setNumberFormat(2);
        this.layers.setDataRange(1.0, 32.0);
        uiCartesianLayout.add(this.layers, 4, 2, 3, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("channels")), 10, 2, 3, 1);
        this.channels = new UiControlText(3, true, false);
        this.channels.setNumberFormat(2);
        this.channels.setDataRange(1.0, 32.0);
        uiCartesianLayout.add(this.channels, 13, 2, 3, 1);
        jTabbedPane.addTab(GLanguage.translate("data"), jPanel2);
        JPanel jPanel3 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel3, 15, 3);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(25, 35));
        jPanel3.setLayout(uiCartesianLayout2);
        this.comments = new JTextArea(7, 35);
        this.comments.setLineWrap(true);
        this.comments.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.comments);
        uiCartesianLayout2.add(jScrollPane, 0, 0, 15, 3);
        jTabbedPane.addTab(GLanguage.translate("comments"), jPanel3);
        this.pFormat = new JPanel();
        UiCartesianLayout uiCartesianLayout3 = new UiCartesianLayout(this.pFormat, 15, 3);
        uiCartesianLayout3.setPreferredCellSize(new Dimension(25, 35));
        this.pFormat.setLayout(uiCartesianLayout3);
        uiCartesianLayout3.add(new JLabel(GLanguage.translate("fileType")), 0, 0, 4, 1);
        this.fileType = new JComboBox<AudioFileFormat.Type>(Audio.getAllFileTypes());
        uiCartesianLayout3.add(this.fileType, 4, 0, 8, 1);
        uiCartesianLayout3.add(new JLabel(GLanguage.translate("encoding")), 0, 1, 4, 1);
        this.encoding = new JComboBox<AudioFormat.Encoding>(Audio.getAllEncodings());
        uiCartesianLayout3.add(this.encoding, 4, 1, 8, 1);
        jTabbedPane.addTab(GLanguage.translate("format"), this.pFormat);
        jPanel.add(jTabbedPane);
        JPanel jPanel4 = new JPanel();
        this.apply = new JButton(GLanguage.translate("apply"));
        jPanel4.add(this.apply);
        jPanel.add(jPanel4);
        this.samples.setEditable(false);
        this.sampleRate.setEditable(true);
        this.sampleWidth.setEditable(true);
        this.channels.setEditable(false);
        this.layers.setEditable(false);
        this.comments.setEditable(true);
        this.samples.setData(441000.0);
        this.sampleRate.setData(44100.0);
        this.sampleWidth.setData(16.0);
        this.channels.setData(2.0);
        this.layers.setData(1.0);
        this.eventDispatcher = new EventDispatcher();
        this.apply.addActionListener(this.eventDispatcher);
        this.frame.getContentPane().add(jPanel);
        this.pack();
    }

    protected void storeValues() {
        this.pluginHandler.getFocussedClip().setSampleRate((float)this.sampleRate.getData());
        this.pluginHandler.getFocussedClip().setSampleWidth((int)this.sampleWidth.getData());
        this.pluginHandler.getFocussedClip().setComments(this.comments.getText());
        this.pluginHandler.getFocussedClip().getAudio().setEncoding((AudioFormat.Encoding)this.encoding.getSelectedItem());
        this.pluginHandler.getFocussedClip().getAudio().setFileType((AudioFileFormat.Type)this.fileType.getSelectedItem());
        this.updateHistory(GLanguage.translate(this.getName()));
        this.reloadFocussedClipEditor();
    }

    protected void loadValues() {
        this.samples.setData(this.pluginHandler.getFocussedClip().getMaxSampleLength());
        this.sampleRate.setData(this.pluginHandler.getFocussedClip().getSampleRate());
        this.sampleWidth.setData(this.pluginHandler.getFocussedClip().getSampleWidth());
        this.channels.setData(this.pluginHandler.getFocussedClip().getMaxNumberOfChannels());
        this.layers.setData(this.pluginHandler.getFocussedClip().getNumberOfLayers());
        this.comments.setText(this.pluginHandler.getFocussedClip().getComments());
        this.encoding.setSelectedItem(this.pluginHandler.getFocussedClip().getAudio().getEncoding());
        this.fileType.setSelectedItem(this.pluginHandler.getFocussedClip().getAudio().getFileType());
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPClipProperties.this.apply) {
                Debug.println(1, "plugin " + GPClipProperties.this.getName() + " [apply] clicked");
                GPClipProperties.this.storeValues();
            }
        }
    }
}

