/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AODisharmony;
import ch.laoe.operation.AOToolkit;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GComboBoxPowerOf2;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.LProgressViewer;
import ch.laoe.ui.LWorker;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GPDisharmony
extends GPluginFrame {
    private UiControlText dry;
    private UiControlText wet;
    private UiControlText shift;
    private UiControlText overlap;
    private JComboBox type;
    private GComboBoxPowerOf2 bufferLength;
    private JComboBox windowType;
    private JButton apply;
    private EventDispatcher eventDispatcher;

    public GPDisharmony(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "disharmony";
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 8);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        String[] stringArray = new String[]{GLanguage.translate("shift"), GLanguage.translate("blur"), GLanguage.translate("unpitch"), GLanguage.translate("bassDephase"), GLanguage.translate("trebleDephase")};
        uiCartesianLayout.add(new JLabel(GLanguage.translate("type")), 0, 0, 5, 1);
        this.type = new JComboBox<String>(stringArray);
        this.type.setSelectedIndex(0);
        uiCartesianLayout.add(this.type, 5, 0, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("dryFactor")), 0, 1, 5, 1);
        this.dry = new GControlTextA(6, true, true);
        this.dry.setDataRange(0.0, 1.0);
        this.dry.setData(0.0);
        uiCartesianLayout.add(this.dry, 5, 1, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("wetFactor")), 0, 2, 5, 1);
        this.wet = new GControlTextA(6, true, true);
        this.wet.setDataRange(0.0, 1.0);
        this.wet.setData(1.0);
        uiCartesianLayout.add(this.wet, 5, 2, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("disharmony")), 0, 3, 5, 1);
        this.shift = new GControlTextA(6, true, true);
        this.shift.setDataRange(-1.0, 1.0);
        this.shift.setData(0.01);
        uiCartesianLayout.add(this.shift, 5, 3, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("bufferLength")), 0, 4, 5, 1);
        this.bufferLength = new GComboBoxPowerOf2(4, 22);
        this.bufferLength.setSelectedExponent(10);
        uiCartesianLayout.add(this.bufferLength, 5, 4, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("window")), 0, 5, 5, 1);
        this.windowType = new JComboBox<String>(AOToolkit.getFFTWindowNames());
        this.windowType.setSelectedIndex(1);
        uiCartesianLayout.add(this.windowType, 5, 5, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("overlap")), 0, 6, 5, 1);
        this.overlap = new GControlTextA(7, true, true);
        this.overlap.setDataRange(0.1, 1.0);
        this.overlap.setData(0.5);
        this.overlap.setUnit("%");
        uiCartesianLayout.add(this.overlap, 5, 6, 5, 1);
        this.apply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.apply, 3, 7, 4, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.apply.addActionListener(new LWorker(this.eventDispatcher));
    }

    @Override
    public void reload() {
        super.reload();
        this.dry.refresh();
        this.wet.refresh();
        this.shift.refresh();
    }

    private void onApply() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        aLayerSelection.operateEachChannel(new AODisharmony(this.type.getSelectedIndex(), (float)this.dry.getData(), (float)this.wet.getData(), (float)this.shift.getData(), this.bufferLength.getSelectedValue(), this.windowType.getSelectedIndex(), (float)this.overlap.getData()));
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPDisharmony.this.apply) {
                LProgressViewer.getInstance().entrySubProgress(GPDisharmony.this.getName());
                LProgressViewer.getInstance().entrySubProgress(0.7);
                Debug.println(1, "plugin " + GPDisharmony.this.getName() + " [apply] clicked");
                GPDisharmony.this.onApply();
                GPDisharmony.this.updateHistory(GLanguage.translate(GPDisharmony.this.getName() + " " + (String)GPDisharmony.this.type.getSelectedItem()));
                LProgressViewer.getInstance().exitSubProgress();
                LProgressViewer.getInstance().exitSubProgress();
                GPDisharmony.this.reloadFocussedClipEditor();
                GPDisharmony.this.autoCloseNow();
            }
        }
    }
}

