/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AClip;
import ch.laoe.clip.AClipPlotter;
import ch.laoe.clip.ALayer;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOFftFilter;
import ch.laoe.operation.AOFlatSpectrum;
import ch.laoe.operation.AOStopSpectrumRange;
import ch.laoe.operation.AOToolkit;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipEditor;
import ch.laoe.ui.GComboBoxPowerOf2;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GControlTextSF;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.LProgressViewer;
import ch.laoe.ui.LWorker;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GPFftFilter
extends GPluginFrame {
    private JButton createFilter;
    private JButton flat;
    private JButton lowPass;
    private JButton highPass;
    private JButton bandPass;
    private JButton bandStop;
    private JButton apply;
    private UiControlText fCut;
    private UiControlText fBegin;
    private UiControlText fEnd;
    private UiControlText overlap;
    private JComboBox windowType;
    private GComboBoxPowerOf2 fftLength;
    private EventDispatcher eventDispatcher;
    private GClipEditor filterClipEditor;

    public GPFftFilter(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "fftFilter";
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel2, 10, 4);
        uiCartesianLayout.setPreferredCellSize(new Dimension(30, 35));
        jPanel2.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("fftLength")), 0, 0, 5, 1);
        this.fftLength = new GComboBoxPowerOf2(4, 16);
        this.fftLength.setSelectedExponent(9);
        uiCartesianLayout.add(this.fftLength, 5, 0, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("window")), 0, 1, 5, 1);
        this.windowType = new JComboBox<String>(AOToolkit.getFFTWindowNames());
        this.windowType.setSelectedIndex(1);
        uiCartesianLayout.add(this.windowType, 5, 1, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("overlap")), 0, 2, 5, 1);
        this.overlap = new GControlTextA(7, true, true);
        this.overlap.setDataRange(0.1, 1.0);
        this.overlap.setData(0.5);
        this.overlap.setUnit("%");
        uiCartesianLayout.add(this.overlap, 5, 2, 5, 1);
        this.flat = new JButton(GLanguage.translate("flat"));
        uiCartesianLayout.add(this.flat, 3, 3, 4, 1);
        jTabbedPane.add(GLanguage.translate("general"), jPanel2);
        JPanel jPanel3 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel3, 10, 3);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(30, 35));
        jPanel3.setLayout(uiCartesianLayout2);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("fCut")), 0, 0, 5, 1);
        this.fCut = new GControlTextSF(Laoe.getInstance(), 9, true, true);
        this.fCut.setEditable(true);
        this.fCut.setDataRange(0.0, 1.0E9);
        this.fCut.setData(0.0);
        this.fCut.setUnit("fdHz");
        uiCartesianLayout2.add(this.fCut, 5, 0, 5, 1);
        this.lowPass = new JButton(GLanguage.translate("lowPass"));
        uiCartesianLayout2.add(this.lowPass, 1, 2, 4, 1);
        this.highPass = new JButton(GLanguage.translate("highPass"));
        uiCartesianLayout2.add(this.highPass, 5, 2, 4, 1);
        jTabbedPane.add(GLanguage.translate("filter"), jPanel3);
        JPanel jPanel4 = new JPanel();
        UiCartesianLayout uiCartesianLayout3 = new UiCartesianLayout(jPanel4, 10, 3);
        uiCartesianLayout3.setPreferredCellSize(new Dimension(30, 35));
        jPanel4.setLayout(uiCartesianLayout3);
        uiCartesianLayout3.add(new JLabel(GLanguage.translate("fBegin")), 0, 0, 5, 1);
        this.fBegin = new GControlTextSF(Laoe.getInstance(), 9, true, true);
        this.fBegin.setEditable(true);
        this.fBegin.setDataRange(0.0, 1.0E9);
        this.fBegin.setData(0.0);
        this.fBegin.setUnit("fdHz");
        uiCartesianLayout3.add(this.fBegin, 5, 0, 5, 1);
        uiCartesianLayout3.add(new JLabel(GLanguage.translate("fEnd")), 0, 1, 5, 1);
        this.fEnd = new GControlTextSF(Laoe.getInstance(), 9, true, true);
        this.fEnd.setEditable(true);
        this.fEnd.setDataRange(0.0, 1.0E9);
        this.fEnd.setData(0.0);
        this.fEnd.setUnit("fdHz");
        uiCartesianLayout3.add(this.fEnd, 5, 1, 5, 1);
        this.bandPass = new JButton(GLanguage.translate("bandPass"));
        uiCartesianLayout3.add(this.bandPass, 1, 2, 4, 1);
        this.bandStop = new JButton(GLanguage.translate("bandStop"));
        uiCartesianLayout3.add(this.bandStop, 5, 2, 4, 1);
        jTabbedPane.add(GLanguage.translate("bandFilter"), jPanel4);
        jPanel.add((Component)jTabbedPane, "Center");
        JPanel jPanel5 = new JPanel();
        this.createFilter = new JButton(GLanguage.translate("new"));
        jPanel5.add(this.createFilter);
        this.apply = new JButton(GLanguage.translate("apply"));
        jPanel5.add(this.apply);
        jPanel.add((Component)jPanel5, "South");
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.createFilter.addActionListener(this.eventDispatcher);
        this.flat.addActionListener(this.eventDispatcher);
        this.lowPass.addActionListener(this.eventDispatcher);
        this.highPass.addActionListener(this.eventDispatcher);
        this.bandPass.addActionListener(this.eventDispatcher);
        this.bandStop.addActionListener(this.eventDispatcher);
        this.apply.addActionListener(new LWorker(this.eventDispatcher));
        this.updateGui();
    }

    @Override
    public void reload() {
        super.reload();
        this.fCut.refresh();
        this.fBegin.refresh();
        this.fEnd.refresh();
    }

    private void updateGui() {
        if (this.filterClipEditor != null) {
            this.flat.setEnabled(true);
            this.apply.setEnabled(true);
            this.lowPass.setEnabled(true);
            this.highPass.setEnabled(true);
            this.bandPass.setEnabled(true);
            this.bandStop.setEnabled(true);
        } else {
            this.flat.setEnabled(false);
            this.apply.setEnabled(false);
            this.lowPass.setEnabled(false);
            this.highPass.setEnabled(false);
            this.bandPass.setEnabled(false);
            this.bandStop.setEnabled(false);
        }
    }

    private void onCreateFilter() {
        AClip aClip = new AClip(1, 1, this.fftLength.getSelectedValue() / 2);
        aClip.setName("<" + GLanguage.translate("fftFilter") + ">");
        aClip.setSampleRate(this.getFocussedClip().getSampleRate());
        aClip.getPlotter().setPlotterXUnit(5);
        aClip.getPlotter().setPlotterYUnit(0);
        AClipPlotter aClipPlotter = aClip.getPlotter();
        aClipPlotter.autoScaleX();
        aClipPlotter.setYRange(-2.0f, 4.0f);
        Laoe.getInstance().addClipFrame(aClip);
        this.filterClipEditor = this.getFocussedClipEditor();
    }

    private void onFlat() {
        AClip aClip = this.filterClipEditor.getClip();
        ALayerSelection aLayerSelection = aClip.getSelectedLayer().createSelection();
        aLayerSelection.operateEachChannel(new AOFlatSpectrum());
        aClip.getSelectedLayer().setEmptySelection();
        this.filterClipEditor.reload();
    }

    private void onLowPass() {
        AClip aClip = this.filterClipEditor.getClip();
        ALayer aLayer = aClip.getSelectedLayer();
        ALayerSelection aLayerSelection = aLayer.createSelection();
        aLayerSelection.operateEachChannel(new AOFlatSpectrum());
        int n = (int)this.fCut.getData();
        aLayer.modifySelection(n, this.filterClipEditor.getClip().getSelectedLayer().getSelectedChannel().getSampleLength() - n);
        aLayerSelection = aLayer.getSelection();
        aLayerSelection.operateEachChannel(new AOStopSpectrumRange());
        aClip.getSelectedLayer().setEmptySelection();
        this.filterClipEditor.reload();
    }

    private void onHighPass() {
        AClip aClip = this.filterClipEditor.getClip();
        ALayer aLayer = aClip.getSelectedLayer();
        ALayerSelection aLayerSelection = aLayer.createSelection();
        aLayerSelection.operateEachChannel(new AOFlatSpectrum());
        int n = (int)this.fCut.getData();
        aLayer.modifySelection(0, n);
        aLayerSelection = aLayer.getSelection();
        aLayerSelection.operateEachChannel(new AOStopSpectrumRange());
        aClip.getSelectedLayer().setEmptySelection();
        this.filterClipEditor.reload();
    }

    private void onBandPass() {
        AClip aClip = this.filterClipEditor.getClip();
        ALayer aLayer = aClip.getSelectedLayer();
        ALayerSelection aLayerSelection = aLayer.createSelection();
        aLayerSelection.operateEachChannel(new AOFlatSpectrum());
        int n = (int)this.fBegin.getData();
        int n2 = (int)this.fEnd.getData();
        aLayer.modifySelection(n2, this.filterClipEditor.getClip().getSelectedLayer().getSelectedChannel().getSampleLength() - n2);
        aLayerSelection = aLayer.getSelection();
        aLayerSelection.operateEachChannel(new AOStopSpectrumRange());
        aLayer.modifySelection(0, n);
        aLayerSelection = aLayer.getSelection();
        aLayerSelection.operateEachChannel(new AOStopSpectrumRange());
        aClip.getSelectedLayer().setEmptySelection();
        this.filterClipEditor.reload();
    }

    private void onBandStop() {
        AClip aClip = this.filterClipEditor.getClip();
        ALayer aLayer = aClip.getSelectedLayer();
        ALayerSelection aLayerSelection = aLayer.createSelection();
        aLayerSelection.operateEachChannel(new AOFlatSpectrum());
        int n = (int)this.fBegin.getData();
        int n2 = (int)this.fEnd.getData();
        aLayer.modifySelection(n, Math.abs(n2 - n));
        aLayerSelection = aLayer.getSelection();
        aLayerSelection.operateEachChannel(new AOStopSpectrumRange());
        aClip.getSelectedLayer().setEmptySelection();
        this.filterClipEditor.reload();
    }

    private void onApply() {
        MMArray mMArray = this.filterClipEditor.getClip().getSelectedLayer().getSelectedChannel().getSamples();
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        aLayerSelection.operateEachChannel(new AOFftFilter(mMArray, mMArray.getLength() * 2, this.windowType.getSelectedIndex(), (float)this.overlap.getData()));
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPFftFilter.this.apply) {
                LProgressViewer.getInstance().entrySubProgress(GPFftFilter.this.getName());
                LProgressViewer.getInstance().entrySubProgress(0.7);
                Debug.println(1, "plugin " + GPFftFilter.this.getName() + " [apply] clicked");
                GPFftFilter.this.onApply();
                GPFftFilter.this.updateHistory(GLanguage.translate(GPFftFilter.this.getName()));
                LProgressViewer.getInstance().exitSubProgress();
                LProgressViewer.getInstance().exitSubProgress();
                GPFftFilter.this.reloadFocussedClipEditor();
                GPFftFilter.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPFftFilter.this.createFilter) {
                Debug.println(1, "plugin " + GPFftFilter.this.getName() + " [create filter] clicked");
                GPFftFilter.this.onCreateFilter();
            } else if (actionEvent.getSource() == GPFftFilter.this.flat) {
                Debug.println(1, "plugin " + GPFftFilter.this.getName() + " [flat] clicked");
                GPFftFilter.this.onFlat();
            } else if (actionEvent.getSource() == GPFftFilter.this.lowPass) {
                Debug.println(1, "plugin " + GPFftFilter.this.getName() + " [lowpass] clicked");
                GPFftFilter.this.onLowPass();
            } else if (actionEvent.getSource() == GPFftFilter.this.highPass) {
                Debug.println(1, "plugin " + GPFftFilter.this.getName() + " [highpass] clicked");
                GPFftFilter.this.onHighPass();
            } else if (actionEvent.getSource() == GPFftFilter.this.bandPass) {
                Debug.println(1, "plugin " + GPFftFilter.this.getName() + " [bandpass] clicked");
                GPFftFilter.this.onBandPass();
            } else if (actionEvent.getSource() == GPFftFilter.this.bandStop) {
                Debug.println(1, "plugin " + GPFftFilter.this.getName() + " [bandstop] clicked");
                GPFftFilter.this.onBandStop();
            }
            GPFftFilter.this.updateGui();
        }
    }
}

