/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOBandPass;
import ch.laoe.operation.AOHighPass;
import ch.laoe.operation.AOLowPass;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GControlTextF;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.LProgressViewer;
import ch.laoe.ui.LWorker;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GPParameterFilter
extends GPluginFrame {
    private JComboBox filterType;
    private UiControlText dry;
    private UiControlText wet;
    private UiControlText freq;
    private UiControlText q;
    private JButton apply;
    private EventDispatcher eventDispatcher;

    public GPParameterFilter(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "parameterFilter";
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 6);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("type")), 0, 0, 4, 1);
        String[] stringArray = new String[]{GLanguage.translate("lowPass"), GLanguage.translate("highPass"), GLanguage.translate("bandPass")};
        this.filterType = new JComboBox<String>(stringArray);
        uiCartesianLayout.add(this.filterType, 4, 0, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("dryFactor")), 0, 1, 4, 1);
        this.dry = new GControlTextA(7, true, true);
        this.dry.setDataRange(0.0, 1.0);
        this.dry.setData(0.0);
        uiCartesianLayout.add(this.dry, 4, 1, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("wetFactor")), 0, 2, 4, 1);
        this.wet = new GControlTextA(7, true, true);
        this.wet.setDataRange(0.0, 1.0);
        this.wet.setData(1.0);
        uiCartesianLayout.add(this.wet, 4, 2, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("frequency")), 0, 3, 4, 1);
        this.freq = new GControlTextF(Laoe.getInstance(), 7, true, true);
        this.freq.setDataRange(0.0, 1000000.0);
        this.freq.setData(0.0);
        this.freq.setUnit("Hz");
        uiCartesianLayout.add(this.freq, 4, 3, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("quality")), 0, 4, 4, 1);
        this.q = new GControlTextA(7, true, true);
        this.q.setDataRange(0.5, 10000.0);
        this.q.setData(1.4);
        uiCartesianLayout.add(this.q, 4, 4, 6, 1);
        this.apply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.apply, 3, 5, 4, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.apply.addActionListener(new LWorker(this.eventDispatcher));
        this.filterType.addActionListener(this.eventDispatcher);
        this.onFilterTypeChange();
    }

    @Override
    public void reload() {
        super.reload();
        this.dry.refresh();
        this.wet.refresh();
        this.freq.refresh();
        this.q.refresh();
    }

    private void onFilterTypeChange() {
        switch (this.filterType.getSelectedIndex()) {
            case 0: {
                this.q.setEnabled(false);
                break;
            }
            case 1: {
                this.q.setEnabled(false);
                break;
            }
            case 2: {
                this.q.setEnabled(true);
            }
        }
    }

    private void onApply() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        float f = 1.0f / (float)this.freq.getData();
        switch (this.filterType.getSelectedIndex()) {
            case 0: {
                aLayerSelection.operateEachChannel(new AOLowPass((float)this.dry.getData(), (float)this.wet.getData(), f));
                break;
            }
            case 1: {
                aLayerSelection.operateEachChannel(new AOHighPass((float)this.dry.getData(), (float)this.wet.getData(), f));
                break;
            }
            case 2: {
                aLayerSelection.operateEachChannel(new AOBandPass((float)this.dry.getData(), (float)this.wet.getData(), f, (float)this.q.getData()));
            }
        }
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPParameterFilter.this.apply) {
                LProgressViewer.getInstance().entrySubProgress(GPParameterFilter.this.getName());
                LProgressViewer.getInstance().entrySubProgress(0.7);
                Debug.println(1, "plugin " + GPParameterFilter.this.getName() + " [apply] clicked");
                GPParameterFilter.this.onApply();
                GPParameterFilter.this.updateHistory(GLanguage.translate(GPParameterFilter.this.getName()));
                LProgressViewer.getInstance().exitSubProgress();
                LProgressViewer.getInstance().exitSubProgress();
                GPParameterFilter.this.reloadFocussedClipEditor();
                GPParameterFilter.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPParameterFilter.this.filterType) {
                Debug.println(1, "plugin " + GPParameterFilter.this.getName() + " [filter type] clicked");
                GPParameterFilter.this.onFilterTypeChange();
            }
        }
    }
}

