/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.AClip;
import ch.laoe.clip.ALayer;
import ch.laoe.operation.AOToolkit;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextSF;
import ch.laoe.ui.GControlTextY;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GPSelectExpander
extends GPluginFrame {
    private JComboBox mode;
    private UiControlText silenceThreshold;
    private UiControlText minimumWidth;
    private JButton apply1;
    private EventDispatcher eventDispatcher;

    public GPSelectExpander(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "selectExpander";
    }

    private void initGui() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 4);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("mode")), 0, 0, 5, 1);
        String[] stringArray = new String[]{GLanguage.translate("expandSilence"), GLanguage.translate("expandNoise"), GLanguage.translate("reduceSilence"), GLanguage.translate("reduceNoise")};
        this.mode = new JComboBox<String>(stringArray);
        uiCartesianLayout.add(this.mode, 5, 0, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("silenceThreshold")), 0, 1, 5, 1);
        this.silenceThreshold = new GControlTextY(Laoe.getInstance(), 10, true, true);
        this.silenceThreshold.setDataRange(0.0, 1.0E9);
        this.silenceThreshold.setData(33.0);
        uiCartesianLayout.add(this.silenceThreshold, 5, 1, 5, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("minimumWidth")), 0, 2, 5, 1);
        this.minimumWidth = new GControlTextSF(Laoe.getInstance(), 10, true, true);
        this.minimumWidth.setDataRange(0.0, 1.0E9);
        this.minimumWidth.setData(2.0);
        uiCartesianLayout.add(this.minimumWidth, 5, 2, 5, 1);
        this.apply1 = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.apply1, 3, 3, 4, 1);
        jTabbedPane.add((Component)jPanel, GLanguage.translate("xAxis"));
        this.frame.getContentPane().add(jTabbedPane);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.apply1.addActionListener(this.eventDispatcher);
        this.mode.addActionListener(this.eventDispatcher);
    }

    @Override
    public void reload() {
        super.reload();
        this.silenceThreshold.refresh();
        this.minimumWidth.refresh();
    }

    private void onModeChange() {
    }

    private void onApply1() {
        AClip aClip = this.getFocussedClip();
        ALayer aLayer = aClip.getSelectedLayer();
        AChannel aChannel = aLayer.getSelectedChannel();
        AChannelSelection aChannelSelection = aChannel.getSelection();
        switch (this.mode.getSelectedIndex()) {
            case 0: {
                aChannel.setSelection(AOToolkit.expandSilence(aChannelSelection, (float)this.silenceThreshold.getData(), (int)this.minimumWidth.getData()));
                break;
            }
            case 1: {
                aChannel.setSelection(AOToolkit.expandNoise(aChannelSelection, (float)this.silenceThreshold.getData(), (int)this.minimumWidth.getData()));
                break;
            }
            case 2: {
                aChannel.setSelection(AOToolkit.reduceSilence(aChannelSelection, (float)this.silenceThreshold.getData(), (int)this.minimumWidth.getData()));
                break;
            }
            case 3: {
                aChannel.setSelection(AOToolkit.reduceNoise(aChannelSelection, (float)this.silenceThreshold.getData(), (int)this.minimumWidth.getData()));
            }
        }
        this.autoCloseNow();
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPSelectExpander.this.apply1) {
                Debug.println(1, "plugin " + GPSelectExpander.this.getName() + " [apply1] clicked");
                GPSelectExpander.this.onApply1();
                GPSelectExpander.this.updateHistory(GLanguage.translate(GPSelectExpander.this.getName()));
                GPSelectExpander.this.repaintFocussedClipEditor();
            } else if (actionEvent.getSource() == GPSelectExpander.this.mode) {
                Debug.println(1, "plugin " + GPSelectExpander.this.getName() + " [mode] clicked");
                GPSelectExpander.this.onModeChange();
            }
        }
    }
}

