/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOConstGenerator;
import ch.laoe.operation.AOGaussianGenerator;
import ch.laoe.operation.AONoiseGenerator;
import ch.laoe.operation.AOQuantizationGenerator;
import ch.laoe.operation.AORampGenerator;
import ch.laoe.operation.AORectangleGenerator;
import ch.laoe.operation.AOSinusGenerator;
import ch.laoe.operation.AOSinusSweepGenerator;
import ch.laoe.operation.AOTriangleGenerator;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GControlTextF;
import ch.laoe.ui.GControlTextSF;
import ch.laoe.ui.GControlTextY;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.LProgressViewer;
import ch.laoe.ui.LWorker;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GPSignalGenerator
extends GPluginFrame {
    private JComboBox periodicShape;
    private UiControlText periodicAmplitude;
    private UiControlText periodicOffset;
    private UiControlText periodicStartPeriod;
    private UiControlText periodicEndPeriod;
    private UiControlText periodicDutyCycle;
    private JCheckBox periodicNormalize;
    private JCheckBox periodicAdd;
    private JCheckBox periodicSweep;
    private JButton periodicApply;
    private JComboBox noiseShape;
    private UiControlText noiseAmplitude;
    private UiControlText noiseOffset;
    private JCheckBox noiseNormalize;
    private JCheckBox noiseAdd;
    private JButton noiseApply;
    private JComboBox transientShape;
    private UiControlText transientAmplitude;
    private UiControlText transientTime;
    private UiControlText transientDuration;
    private JCheckBox transientNormalize;
    private JCheckBox transientAdd;
    private JButton transientApply;
    private JComboBox constantShape;
    private UiControlText constantStartAmplitude;
    private UiControlText constantEndAmplitude;
    private JCheckBox constantNormalize;
    private JCheckBox constantAdd;
    private JButton constantApply;
    private EventDispatcher eventDispatcher;

    public GPSignalGenerator(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "signalGenerator";
    }

    private void initGui() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 9);
        uiCartesianLayout.setPreferredCellSize(new Dimension(30, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("shape")), 0, 0, 4, 1);
        String[] stringArray = new String[]{GLanguage.translate("constant"), GLanguage.translate("ramp")};
        this.constantShape = new JComboBox<String>(stringArray);
        uiCartesianLayout.add(this.constantShape, 4, 0, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("startAmplitude")), 0, 1, 4, 1);
        this.constantStartAmplitude = new GControlTextY(Laoe.getInstance(), 10, true, true);
        this.constantStartAmplitude.setDataRange(-1.0E9, 1.0E9);
        this.constantStartAmplitude.setData(1.0);
        uiCartesianLayout.add(this.constantStartAmplitude, 4, 1, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("endAmplitude")), 0, 2, 4, 1);
        this.constantEndAmplitude = new GControlTextY(Laoe.getInstance(), 10, true, true);
        this.constantEndAmplitude.setDataRange(-1.0E9, 1.0E9);
        this.constantEndAmplitude.setData(1.0);
        uiCartesianLayout.add(this.constantEndAmplitude, 4, 2, 6, 1);
        this.constantNormalize = new JCheckBox(GLanguage.translate("normalize"));
        uiCartesianLayout.add(this.constantNormalize, 0, 3, 5, 1);
        this.constantAdd = new JCheckBox(GLanguage.translate("add"));
        uiCartesianLayout.add(this.constantAdd, 5, 3, 5, 1);
        this.constantApply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout.add(this.constantApply, 3, 8, 4, 1);
        jTabbedPane.add(GLanguage.translate("constant"), jPanel);
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel2, 10, 9);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(25, 35));
        jPanel2.setLayout(uiCartesianLayout2);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("shape")), 0, 0, 4, 1);
        String[] stringArray2 = new String[]{GLanguage.translate("rectangle"), GLanguage.translate("triangle"), GLanguage.translate("sinus"), GLanguage.translate("quantization")};
        this.periodicShape = new JComboBox<String>(stringArray2);
        uiCartesianLayout2.add(this.periodicShape, 4, 0, 6, 1);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("amplitude")), 0, 1, 4, 1);
        this.periodicAmplitude = new GControlTextY(Laoe.getInstance(), 10, true, true);
        this.periodicAmplitude.setDataRange(-1.0E9, 1.0E9);
        this.periodicAmplitude.setData(1.0);
        uiCartesianLayout2.add(this.periodicAmplitude, 4, 1, 6, 1);
        this.periodicNormalize = new JCheckBox(GLanguage.translate("normalize"));
        uiCartesianLayout2.add(this.periodicNormalize, 0, 2, 5, 1);
        this.periodicAdd = new JCheckBox(GLanguage.translate("add"));
        uiCartesianLayout2.add(this.periodicAdd, 5, 2, 5, 1);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("offset")), 0, 3, 4, 1);
        this.periodicOffset = new GControlTextY(Laoe.getInstance(), 10, true, true);
        this.periodicOffset.setDataRange(-1000000.0, 1000000.0);
        this.periodicOffset.setData(0.0);
        uiCartesianLayout2.add(this.periodicOffset, 4, 3, 6, 1);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("startPeriod")), 0, 4, 4, 1);
        this.periodicStartPeriod = new GControlTextF(Laoe.getInstance(), 10, true, true);
        this.periodicStartPeriod.setDataRange(1.0, 1000000.0);
        this.periodicStartPeriod.setData(1.0);
        uiCartesianLayout2.add(this.periodicStartPeriod, 4, 4, 6, 1);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("endPeriod")), 0, 5, 4, 1);
        this.periodicEndPeriod = new GControlTextF(Laoe.getInstance(), 10, true, true);
        this.periodicEndPeriod.setDataRange(1.0, 1000000.0);
        this.periodicEndPeriod.setData(1.0);
        uiCartesianLayout2.add(this.periodicEndPeriod, 4, 5, 6, 1);
        this.periodicSweep = new JCheckBox(GLanguage.translate("sweep"));
        uiCartesianLayout2.add(this.periodicSweep, 0, 6, 5, 1);
        uiCartesianLayout2.add(new JLabel(GLanguage.translate("dutyCycle")), 0, 7, 4, 1);
        this.periodicDutyCycle = new GControlTextA(10, true, true);
        this.periodicDutyCycle.setDataRange(-1000000.0, 1000000.0);
        this.periodicDutyCycle.setData(0.5);
        uiCartesianLayout2.add(this.periodicDutyCycle, 4, 7, 6, 1);
        this.periodicApply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout2.add(this.periodicApply, 3, 8, 4, 1);
        jTabbedPane.add(GLanguage.translate("periodic"), jPanel2);
        JPanel jPanel3 = new JPanel();
        UiCartesianLayout uiCartesianLayout3 = new UiCartesianLayout(jPanel3, 10, 9);
        uiCartesianLayout3.setPreferredCellSize(new Dimension(25, 35));
        jPanel3.setLayout(uiCartesianLayout3);
        uiCartesianLayout3.add(new JLabel(GLanguage.translate("shape")), 0, 0, 4, 1);
        String[] stringArray3 = new String[]{GLanguage.translate("whiteNoise"), GLanguage.translate("triangleNoise"), GLanguage.translate("gaussianNoise")};
        this.noiseShape = new JComboBox<String>(stringArray3);
        uiCartesianLayout3.add(this.noiseShape, 4, 0, 6, 1);
        uiCartesianLayout3.add(new JLabel(GLanguage.translate("amplitude")), 0, 1, 4, 1);
        this.noiseAmplitude = new GControlTextY(Laoe.getInstance(), 10, true, true);
        this.noiseAmplitude.setDataRange(-1.0E9, 1.0E9);
        this.noiseAmplitude.setData(1.0);
        uiCartesianLayout3.add(this.noiseAmplitude, 4, 1, 6, 1);
        this.noiseNormalize = new JCheckBox(GLanguage.translate("normalize"));
        uiCartesianLayout3.add(this.noiseNormalize, 0, 2, 5, 1);
        this.noiseAdd = new JCheckBox(GLanguage.translate("add"));
        uiCartesianLayout3.add(this.noiseAdd, 5, 2, 5, 1);
        uiCartesianLayout3.add(new JLabel(GLanguage.translate("offset")), 0, 3, 4, 1);
        this.noiseOffset = new GControlTextY(Laoe.getInstance(), 10, true, true);
        this.noiseOffset.setDataRange(-1000000.0, 1000000.0);
        this.noiseOffset.setData(0.0);
        uiCartesianLayout3.add(this.noiseOffset, 4, 3, 6, 1);
        this.noiseApply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout3.add(this.noiseApply, 3, 8, 4, 1);
        jTabbedPane.add(GLanguage.translate("noise"), jPanel3);
        JPanel jPanel4 = new JPanel();
        UiCartesianLayout uiCartesianLayout4 = new UiCartesianLayout(jPanel4, 10, 9);
        uiCartesianLayout4.setPreferredCellSize(new Dimension(25, 35));
        jPanel4.setLayout(uiCartesianLayout4);
        uiCartesianLayout4.add(new JLabel(GLanguage.translate("shape")), 0, 0, 4, 1);
        String[] stringArray4 = new String[]{GLanguage.translate("gaussianDistribution")};
        this.transientShape = new JComboBox<String>(stringArray4);
        uiCartesianLayout4.add(this.transientShape, 4, 0, 6, 1);
        uiCartesianLayout4.add(new JLabel(GLanguage.translate("amplitude")), 0, 1, 4, 1);
        this.transientAmplitude = new GControlTextY(Laoe.getInstance(), 10, true, true);
        this.transientAmplitude.setDataRange(-1.0E9, 1.0E9);
        this.transientAmplitude.setData(1.0);
        uiCartesianLayout4.add(this.transientAmplitude, 4, 1, 6, 1);
        this.transientNormalize = new JCheckBox(GLanguage.translate("normalize"));
        uiCartesianLayout4.add(this.transientNormalize, 0, 2, 5, 1);
        this.transientAdd = new JCheckBox(GLanguage.translate("add"));
        uiCartesianLayout4.add(this.transientAdd, 5, 2, 5, 1);
        uiCartesianLayout4.add(new JLabel(GLanguage.translate("time")), 0, 3, 4, 1);
        this.transientTime = new GControlTextSF(Laoe.getInstance(), 10, true, true);
        this.transientTime.setDataRange(-1000000.0, 1000000.0);
        this.transientTime.setData(0.0);
        uiCartesianLayout4.add(this.transientTime, 4, 3, 6, 1);
        uiCartesianLayout4.add(new JLabel(GLanguage.translate("duration")), 0, 4, 4, 1);
        this.transientDuration = new GControlTextSF(Laoe.getInstance(), 10, true, true);
        this.transientDuration.setDataRange(1.0, 1000000.0);
        this.transientDuration.setData(1.0);
        uiCartesianLayout4.add(this.transientDuration, 4, 4, 6, 1);
        this.transientApply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout4.add(this.transientApply, 3, 8, 4, 1);
        jTabbedPane.add(GLanguage.translate("transient"), jPanel4);
        this.frame.getContentPane().add(jTabbedPane);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.constantApply.addActionListener(new LWorker(this.eventDispatcher));
        this.periodicApply.addActionListener(new LWorker(this.eventDispatcher));
        this.noiseApply.addActionListener(new LWorker(this.eventDispatcher));
        this.transientApply.addActionListener(new LWorker(this.eventDispatcher));
        this.constantShape.addActionListener(this.eventDispatcher);
        this.periodicShape.addActionListener(this.eventDispatcher);
        this.noiseShape.addActionListener(this.eventDispatcher);
        this.transientShape.addActionListener(this.eventDispatcher);
        this.constantNormalize.addActionListener(this.eventDispatcher);
        this.periodicNormalize.addActionListener(this.eventDispatcher);
        this.noiseNormalize.addActionListener(this.eventDispatcher);
        this.transientNormalize.addActionListener(this.eventDispatcher);
        this.periodicSweep.addActionListener(this.eventDispatcher);
        this.updateActiveComponents();
    }

    @Override
    public void reload() {
        super.reload();
        this.periodicAmplitude.refresh();
        this.periodicOffset.refresh();
        this.periodicStartPeriod.refresh();
        this.periodicEndPeriod.refresh();
        this.periodicDutyCycle.refresh();
        this.noiseAmplitude.refresh();
        this.noiseOffset.refresh();
        this.transientAmplitude.refresh();
        this.transientTime.refresh();
        this.transientDuration.refresh();
        this.constantStartAmplitude.refresh();
        this.constantEndAmplitude.refresh();
    }

    private void updateActiveComponents() {
        this.updateConstantComponents();
        this.updatePeriodicComponents();
        this.updateNoiseComponents();
        this.updateTransientComponents();
    }

    private void updatePeriodicComponents() {
        this.periodicAmplitude.setEnabled(!this.periodicNormalize.isSelected());
        this.periodicOffset.setEnabled(true);
        this.periodicNormalize.setEnabled(true);
        switch (this.periodicShape.getSelectedIndex()) {
            case 0: 
            case 1: {
                this.periodicEndPeriod.setEnabled(false);
                this.periodicSweep.setEnabled(false);
                this.periodicDutyCycle.setEnabled(true);
                break;
            }
            case 2: {
                this.periodicSweep.setEnabled(true);
                this.periodicEndPeriod.setEnabled(this.periodicSweep.isSelected());
                this.periodicDutyCycle.setEnabled(true);
                break;
            }
            case 3: {
                this.periodicNormalize.setEnabled(false);
                this.periodicAmplitude.setEnabled(false);
                this.periodicOffset.setEnabled(false);
                this.periodicSweep.setEnabled(false);
                this.periodicEndPeriod.setEnabled(this.periodicSweep.isSelected());
                this.periodicDutyCycle.setEnabled(false);
            }
        }
    }

    private void updateConstantComponents() {
        this.constantStartAmplitude.setEnabled(!this.constantNormalize.isSelected());
        switch (this.constantShape.getSelectedIndex()) {
            case 0: {
                this.constantEndAmplitude.setEnabled(false);
                break;
            }
            case 1: {
                this.constantEndAmplitude.setEnabled(true);
            }
        }
    }

    private void updateNoiseComponents() {
        this.noiseAmplitude.setEnabled(!this.noiseNormalize.isSelected());
    }

    private void updateTransientComponents() {
        this.transientAmplitude.setEnabled(!this.transientNormalize.isSelected());
    }

    private void onConstantApply() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        float f = this.constantNormalize.isSelected() ? (float)Math.pow(2.0, this.getFocussedClip().getSampleWidth() - 1) : (float)this.constantStartAmplitude.getData();
        switch (this.constantShape.getSelectedIndex()) {
            case 0: {
                aLayerSelection.operateEachChannel(new AOConstGenerator(f, this.constantAdd.isSelected()));
                break;
            }
            case 1: {
                aLayerSelection.operateEachChannel(new AORampGenerator((float)this.constantStartAmplitude.getData(), (float)this.constantEndAmplitude.getData(), this.constantAdd.isSelected(), this.constantNormalize.isSelected()));
            }
        }
    }

    private void onPeriodicApply() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        float f = this.periodicNormalize.isSelected() ? (float)Math.pow(2.0, this.getFocussedClip().getSampleWidth() - 1) : (float)this.periodicAmplitude.getData();
        switch (this.periodicShape.getSelectedIndex()) {
            case 0: {
                aLayerSelection.operateEachChannel(new AORectangleGenerator(f, (float)this.periodicOffset.getData(), (int)this.periodicStartPeriod.getData(), (float)this.periodicDutyCycle.getData(), this.periodicAdd.isSelected()));
                break;
            }
            case 1: {
                aLayerSelection.operateEachChannel(new AOTriangleGenerator(f, (float)this.periodicOffset.getData(), (int)this.periodicStartPeriod.getData(), (float)this.periodicDutyCycle.getData(), this.periodicAdd.isSelected()));
                break;
            }
            case 2: {
                if (this.periodicSweep.isSelected()) {
                    aLayerSelection.operateEachChannel(new AOSinusSweepGenerator(f, (float)this.periodicOffset.getData(), (int)this.periodicStartPeriod.getData(), (int)this.periodicEndPeriod.getData(), this.periodicAdd.isSelected()));
                    break;
                }
                aLayerSelection.operateEachChannel(new AOSinusGenerator(f, (float)this.periodicOffset.getData(), (int)this.periodicStartPeriod.getData(), this.periodicAdd.isSelected()));
                break;
            }
            case 3: {
                aLayerSelection.operateEachChannel(new AOQuantizationGenerator(0, (int)this.periodicStartPeriod.getData(), this.periodicAdd.isSelected()));
            }
        }
    }

    private void onNoiseApply() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        float f = this.noiseNormalize.isSelected() ? (float)Math.pow(2.0, this.getFocussedClip().getSampleWidth() - 1) : (float)this.noiseAmplitude.getData();
        switch (this.noiseShape.getSelectedIndex()) {
            case 0: {
                aLayerSelection.operateEachChannel(new AONoiseGenerator(f, (float)this.noiseOffset.getData(), 1, this.noiseAdd.isSelected()));
                break;
            }
            case 1: {
                aLayerSelection.operateEachChannel(new AONoiseGenerator(f, (float)this.noiseOffset.getData(), 2, this.noiseAdd.isSelected()));
                break;
            }
            case 2: {
                aLayerSelection.operateEachChannel(new AONoiseGenerator(f, (float)this.noiseOffset.getData(), 3, this.noiseAdd.isSelected()));
            }
        }
    }

    private void onTransientApply() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        float f = this.transientNormalize.isSelected() ? (float)Math.pow(2.0, this.getFocussedClip().getSampleWidth() - 1) : (float)this.transientAmplitude.getData();
        switch (this.transientShape.getSelectedIndex()) {
            case 0: {
                aLayerSelection.operateEachChannel(new AOGaussianGenerator(f, (float)this.transientTime.getData(), (float)this.transientDuration.getData(), this.transientAdd.isSelected()));
            }
        }
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPSignalGenerator.this.constantApply) {
                LProgressViewer.getInstance().entrySubProgress(GPSignalGenerator.this.getName());
                LProgressViewer.getInstance().entrySubProgress(0.7);
                Debug.println(1, "plugin " + GPSignalGenerator.this.getName() + " [apply constant] clicked");
                GPSignalGenerator.this.onConstantApply();
                GPSignalGenerator.this.updateHistory(GLanguage.translate(GPSignalGenerator.this.getName()));
                LProgressViewer.getInstance().exitSubProgress();
                LProgressViewer.getInstance().exitSubProgress();
                GPSignalGenerator.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPSignalGenerator.this.periodicApply) {
                LProgressViewer.getInstance().entrySubProgress(GPSignalGenerator.this.getName());
                LProgressViewer.getInstance().entrySubProgress(0.7);
                Debug.println(1, "plugin " + GPSignalGenerator.this.getName() + " [apply periodic] clicked");
                GPSignalGenerator.this.onPeriodicApply();
                GPSignalGenerator.this.updateHistory(GLanguage.translate(GPSignalGenerator.this.getName()));
                LProgressViewer.getInstance().exitSubProgress();
                LProgressViewer.getInstance().exitSubProgress();
                GPSignalGenerator.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPSignalGenerator.this.noiseApply) {
                LProgressViewer.getInstance().entrySubProgress(GPSignalGenerator.this.getName());
                LProgressViewer.getInstance().entrySubProgress(0.7);
                Debug.println(1, "plugin " + GPSignalGenerator.this.getName() + " [apply noise] clicked");
                GPSignalGenerator.this.onNoiseApply();
                GPSignalGenerator.this.updateHistory(GLanguage.translate(GPSignalGenerator.this.getName()));
                LProgressViewer.getInstance().exitSubProgress();
                LProgressViewer.getInstance().exitSubProgress();
                GPSignalGenerator.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPSignalGenerator.this.transientApply) {
                LProgressViewer.getInstance().entrySubProgress(GPSignalGenerator.this.getName());
                LProgressViewer.getInstance().entrySubProgress(0.7);
                Debug.println(1, "plugin " + GPSignalGenerator.this.getName() + " [apply transient] clicked");
                GPSignalGenerator.this.onTransientApply();
                GPSignalGenerator.this.updateHistory(GLanguage.translate(GPSignalGenerator.this.getName()));
                LProgressViewer.getInstance().exitSubProgress();
                LProgressViewer.getInstance().exitSubProgress();
                GPSignalGenerator.this.autoCloseNow();
            }
            GPSignalGenerator.this.reloadFocussedClipEditor();
            GPSignalGenerator.this.updateActiveComponents();
        }
    }
}

