/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.ui;

import ch.laoe.clip.AChannel;
import ch.laoe.ui.GToolkit;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class GEditableArea {
    private Color color;
    private Color inversedColor;
    private boolean editable = true;
    private int brushSize;
    private boolean inversed = false;
    public static final int DRAW_MODE_RECTANGLE = 1;
    public static final int DRAW_MODE_LINE = 2;
    public static final int DRAW_MODE_POLYGON = 3;
    private int drawMode = 3;
    private ArrayList<SdShape> shapes = new ArrayList(100);
    private int actualOperation = 0;
    private static final int IDLE = 0;
    private static final int DRAW = 1;
    private static final int REMOVE = 2;
    private AChannel actualChannel;
    private Cursor penCursor;
    private Cursor eraseCursor;
    private Cursor actualCursor;
    private int x1;
    private int x2;
    private int y1;
    private int y2;
    private SdPolygon tmpPolygon;
    private Stroke stroke = new BasicStroke();

    public GEditableArea() {
        this.color = Color.yellow;
        this.inversedColor = Color.blue;
        this.penCursor = GToolkit.createCustomCursor(this, "brushCursor");
        this.eraseCursor = GToolkit.createCustomCursor(this, "eraseCursor");
        this.actualCursor = this.penCursor;
    }

    public GEditableArea(GEditableArea gEditableArea) {
        this();
        this.copy(gEditableArea);
    }

    public void copy(GEditableArea gEditableArea) {
        if (gEditableArea != this) {
            System.out.println("copy other GEditableArea");
            this.color = gEditableArea.color;
            this.inversedColor = gEditableArea.inversedColor;
            this.editable = gEditableArea.editable;
            this.inversed = gEditableArea.inversed;
            this.brushSize = gEditableArea.brushSize;
            this.drawMode = gEditableArea.drawMode;
            this.shapes.clear();
            for (int i = 0; i < gEditableArea.shapes.size(); ++i) {
                SdShape sdShape = gEditableArea.shapes.get(i);
                if (sdShape instanceof SdRectangle) {
                    this.shapes.add(new SdRectangle((SdRectangle)sdShape));
                    continue;
                }
                if (!(sdShape instanceof SdPolygon)) continue;
                this.shapes.add(new SdPolygon((SdPolygon)sdShape));
            }
        } else {
            System.out.println("no need to copy GEditableArea");
        }
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setInversedColor(Color color) {
        this.inversedColor = color;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setBrushSize(int n) {
        this.brushSize = n;
    }

    public int getBrushSize() {
        return this.brushSize;
    }

    public boolean isInversed() {
        return this.inversed;
    }

    public void setInversed(boolean bl) {
        this.inversed = bl;
    }

    public void setDrawMode(int n) {
        this.drawMode = n;
    }

    public int getDrawMode() {
        return this.drawMode;
    }

    public void setChannel(AChannel aChannel) {
        this.actualChannel = aChannel;
    }

    public void clear() {
        this.shapes.clear();
    }

    private void remove(SdShape sdShape) {
        for (SdShape sdShape2 : this.shapes) {
            if (!sdShape2.isInclosedIn(sdShape)) continue;
            this.shapes.remove(sdShape2);
        }
    }

    public void selectAll() {
        try {
            Rectangle rectangle = this.actualChannel.getPlotter().getRectangle();
            SdRectangle sdRectangle = new SdRectangle(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            this.shapes.clear();
            this.shapes.add(sdRectangle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isSomethingSelected() {
        return true;
    }

    public boolean isSelected(double d, double d2) {
        if (this.inversed) {
            for (int i = 0; i < this.shapes.size(); ++i) {
                if (!this.shapes.get(i).isInside(d, d2)) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < this.shapes.size(); ++i) {
            if (!this.shapes.get(i).isInside(d, d2)) continue;
            return true;
        }
        return false;
    }

    public double isSelected(double d, double d2, double d3, double d4) {
        double d5 = 0.0;
        d5 += this.isSelected(d, d2) ? 1.0 : 0.0;
        if (d3 == 0.0 && d4 == 0.0) {
            return d5;
        }
        d5 += this.isSelected(d + d3, d2) ? 1.0 : 0.0;
        d5 += this.isSelected(d - d3, d2) ? 1.0 : 0.0;
        d5 += this.isSelected(d, d2 + d4) ? 1.0 : 0.0;
        d5 += this.isSelected(d, d2 - d4) ? 1.0 : 0.0;
        return d5 /= 5.0;
    }

    public double getXMin() {
        if (this.inversed) {
            return 0.0;
        }
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.shapes.size(); ++i) {
            double d2 = this.shapes.get(i).getXMin();
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public double getXMax() {
        if (this.inversed) {
            return this.actualChannel.getSampleLength();
        }
        double d = Double.MIN_VALUE;
        for (int i = 0; i < this.shapes.size(); ++i) {
            double d2 = this.shapes.get(i).getXMax();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.actualChannel != null && this.editable) {
            this.actualOperation = GToolkit.isShiftKey(mouseEvent) ? 2 : 1;
            switch (this.drawMode) {
                case 1: {
                    this.x1 = mouseEvent.getPoint().x;
                    this.y1 = mouseEvent.getPoint().y;
                    this.x2 = this.x1;
                    this.y2 = this.y1;
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.tmpPolygon = new SdPolygon();
                }
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Cursor cursor = GToolkit.isShiftKey(mouseEvent) ? this.eraseCursor : this.penCursor;
        if (cursor != this.actualCursor) {
            this.actualCursor = cursor;
            ((Component)mouseEvent.getSource()).setCursor(this.actualCursor);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.actualChannel != null && this.editable) {
            switch (this.drawMode) {
                case 1: {
                    this.x2 = mouseEvent.getPoint().x;
                    this.y2 = mouseEvent.getPoint().y;
                    break;
                }
                case 2: {
                    if (this.actualOperation == 1) {
                        this.x1 = mouseEvent.getPoint().x - this.brushSize / 2;
                        this.y1 = mouseEvent.getPoint().y - this.brushSize / 2;
                        this.x2 = this.x1 + this.brushSize;
                        this.y2 = this.y1 + this.brushSize;
                        SdRectangle sdRectangle = new SdRectangle(this.x1, this.y1, this.x2, this.y2);
                        this.shapes.add(sdRectangle);
                        break;
                    }
                    if (this.actualOperation != 2) break;
                    this.x1 = mouseEvent.getPoint().x - this.brushSize / 2;
                    this.y1 = mouseEvent.getPoint().y - this.brushSize / 2;
                    this.x2 = this.x1 + this.brushSize;
                    this.y2 = this.y1 + this.brushSize;
                    SdRectangle sdRectangle = new SdRectangle(this.x1, this.y1, this.x2, this.y2);
                    this.remove(sdRectangle);
                    break;
                }
                case 3: {
                    this.tmpPolygon.addPoint(new SdPoint(mouseEvent.getPoint().x, mouseEvent.getPoint().y));
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.actualChannel != null && this.editable) {
            switch (this.drawMode) {
                case 1: {
                    if (this.actualOperation == 1) {
                        this.x2 = mouseEvent.getPoint().x;
                        this.y2 = mouseEvent.getPoint().y;
                        SdRectangle sdRectangle = new SdRectangle(this.x1, this.y1, this.x2, this.y2);
                        this.shapes.add(sdRectangle);
                        break;
                    }
                    if (this.actualOperation != 2) break;
                    this.x2 = mouseEvent.getPoint().x;
                    this.y2 = mouseEvent.getPoint().y;
                    SdRectangle sdRectangle = new SdRectangle(this.x1, this.y1, this.x2, this.y2);
                    this.remove(sdRectangle);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (this.actualOperation == 1) {
                        this.shapes.add(this.tmpPolygon);
                        this.tmpPolygon = null;
                        break;
                    }
                    if (this.actualOperation != 2) break;
                    this.remove(this.tmpPolygon);
                    this.tmpPolygon = null;
                }
            }
            this.actualOperation = 0;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        ((Component)mouseEvent.getSource()).setCursor(this.actualCursor);
    }

    public void paintOntoClip(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.actualChannel != null) {
            try {
                graphics2D.setClip(this.actualChannel.getPlotter().getRectangle());
                graphics2D.setStroke(this.stroke);
                if (this.inversed) {
                    graphics2D.setColor(this.inversedColor);
                } else {
                    graphics2D.setColor(this.color);
                }
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.18f));
                for (int i = 0; i < this.shapes.size(); ++i) {
                    Shape shape;
                    SdShape sdShape;
                    if (this.shapes.get(i) instanceof SdRectangle) {
                        sdShape = (SdRectangle)this.shapes.get(i);
                        shape = (Rectangle)((SdRectangle)sdShape).toGraphicDomain();
                        graphics2D.fillRect(shape.x, shape.y, shape.width, shape.height);
                        continue;
                    }
                    if (!(this.shapes.get(i) instanceof SdPolygon)) continue;
                    sdShape = (SdPolygon)this.shapes.get(i);
                    shape = (Polygon)((SdPolygon)sdShape).toGraphicDomain();
                    graphics2D.fillPolygon((Polygon)shape);
                }
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
                switch (this.drawMode) {
                    case 1: {
                        if (this.actualOperation == 0) break;
                        graphics2D.setStroke(this.stroke);
                        graphics2D.setColor(Color.white);
                        graphics2D.drawRect(Math.min(this.x1, this.x2), Math.min(this.y1, this.y2), Math.abs(this.x2 - this.x1), Math.abs(this.y2 - this.y1));
                        break;
                    }
                    case 2: {
                        if (this.actualOperation == 0) break;
                        graphics2D.setStroke(this.stroke);
                        graphics2D.setColor(Color.white);
                        graphics2D.drawRect(Math.min(this.x1, this.x2), Math.min(this.y1, this.y2), Math.abs(this.x2 - this.x1), Math.abs(this.y2 - this.y1));
                        break;
                    }
                    case 3: {
                        if (this.actualOperation == 0 || this.tmpPolygon == null) break;
                        graphics2D.setStroke(this.stroke);
                        graphics2D.setColor(Color.white);
                        Polygon polygon = (Polygon)this.tmpPolygon.toGraphicDomain();
                        graphics2D.drawPolygon(polygon);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class SdPolygon
    implements SdShape {
        private ArrayList<SdPoint> points = new ArrayList();

        public SdPolygon() {
        }

        public SdPolygon(SdPolygon sdPolygon) {
            this();
            for (SdPoint sdPoint : sdPolygon.points) {
                this.points.add(gEditableArea.new SdPoint(sdPoint));
            }
        }

        public void addPoint(SdPoint sdPoint) {
            this.points.add(sdPoint);
        }

        @Override
        public Shape toGraphicDomain() {
            Polygon polygon = new Polygon();
            for (SdPoint sdPoint : this.points) {
                Point point = sdPoint.toGraphicDomain();
                polygon.addPoint(point.x, point.y);
            }
            return polygon;
        }

        @Override
        public boolean isInside(double d, double d2) {
            return this.toGraphicDomain().contains(new Point(GEditableArea.this.actualChannel.getPlotter().sampleToGraphX(d), GEditableArea.this.actualChannel.getPlotter().sampleToGraphY((float)d2)));
        }

        @Override
        public boolean isInclosedIn(SdShape sdShape) {
            for (int i = 0; i < this.points.size(); ++i) {
                SdPoint sdPoint = this.points.get(i);
                if (sdShape.isInside(sdPoint.x, sdPoint.y)) continue;
                return false;
            }
            return true;
        }

        @Override
        public double getXMin() {
            double d = Double.MAX_VALUE;
            for (SdPoint sdPoint : this.points) {
                if (!(sdPoint.x < d)) continue;
                d = sdPoint.x;
            }
            return d;
        }

        @Override
        public double getXMax() {
            double d = Double.MIN_VALUE;
            for (SdPoint sdPoint : this.points) {
                if (!(sdPoint.x > d)) continue;
                d = sdPoint.x;
            }
            return d;
        }
    }

    private class SdRectangle
    implements SdShape {
        SdPoint topLeft;
        SdPoint bottomRight;

        public SdRectangle(int n, int n2, int n3, int n4) {
            this.topLeft = new SdPoint(Math.min(n, n3), Math.min(n2, n4));
            this.bottomRight = new SdPoint(Math.max(n, n3), Math.max(n2, n4));
        }

        public SdRectangle(SdRectangle sdRectangle) {
            this.topLeft = new SdPoint(sdRectangle.topLeft);
            this.bottomRight = new SdPoint(sdRectangle.bottomRight);
        }

        @Override
        public Shape toGraphicDomain() {
            Point point = this.topLeft.toGraphicDomain();
            Point point2 = this.bottomRight.toGraphicDomain();
            return new Rectangle(point.x, point.y, point2.x - point.x, point2.y - point.y);
        }

        @Override
        public boolean isInside(double d, double d2) {
            return d > this.topLeft.x && d2 < this.topLeft.y && d < this.bottomRight.x && d2 > this.bottomRight.y;
        }

        @Override
        public boolean isInclosedIn(SdShape sdShape) {
            return sdShape.isInside(this.topLeft.x, this.topLeft.y) || sdShape.isInside(this.bottomRight.x, this.bottomRight.y);
        }

        @Override
        public double getXMin() {
            return this.topLeft.x;
        }

        @Override
        public double getXMax() {
            return this.bottomRight.x;
        }
    }

    private static interface SdShape {
        public Shape toGraphicDomain();

        public boolean isInside(double var1, double var3);

        public boolean isInclosedIn(SdShape var1);

        public double getXMin();

        public double getXMax();
    }

    private class SdPoint {
        public double x;
        public double y;

        public SdPoint(double d, double d2) {
            this.x = GEditableArea.this.actualChannel.getPlotter().graphToSampleX((int)d);
            this.y = GEditableArea.this.actualChannel.getPlotter().graphToSampleY((int)d2);
        }

        public SdPoint(SdPoint sdPoint) {
            this.x = sdPoint.x;
            this.y = sdPoint.y;
        }

        public Point toGraphicDomain() {
            return new Point(GEditableArea.this.actualChannel.getPlotter().sampleToGraphX(this.x), GEditableArea.this.actualChannel.getPlotter().sampleToGraphY((float)this.y));
        }
    }
}

