/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.io;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class CommandLineParser {
    private static String argDelimiter = " ";
    private static String multiDelimiter = ",";
    private List args;
    private String text;

    private void parse(String line) {
        this.args = new ArrayList();
        StringTokenizer st = new StringTokenizer(this.text, argDelimiter);
        while (st.hasMoreTokens()) {
            String a = st.nextToken().trim();
            if (a.indexOf(multiDelimiter) >= 0) {
                this.args.add(new MultiArgument(a));
                continue;
            }
            this.args.add(new SingleArgument(a));
        }
        int n = this.args.size() - 1;
        int i = 0;
        while (i < n) {
            Argument a = (Argument)this.args.get(i);
            Argument na = (Argument)this.args.get(i + 1);
            if (a.isFlag() && !na.isFlag()) {
                a.setFlagArguments(na);
            }
            ++i;
        }
    }

    public CommandLineParser(String[] arg, String argDelimiter, String multiDelimiter) {
        CommandLineParser.argDelimiter = argDelimiter;
        CommandLineParser.multiDelimiter = multiDelimiter;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < arg.length) {
            sb.append(arg[i]);
            sb.append(" ");
            ++i;
        }
        this.text = sb.toString().trim();
        this.parse(this.text);
    }

    public CommandLineParser(String[] arg) {
        this(arg, argDelimiter, multiDelimiter);
    }

    public CommandLineParser(String line, String argDelimiter, String multiDelimiter) {
        CommandLineParser.argDelimiter = argDelimiter;
        CommandLineParser.multiDelimiter = multiDelimiter;
        this.text = line.trim();
        this.parse(line);
    }

    public CommandLineParser(String line) {
        this(line, argDelimiter, multiDelimiter);
    }

    private CommandLineParser() {
    }

    public String toString() {
        return this.text;
    }

    public String toDetailedString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.getNumberOfArguments()) {
            Argument a = (Argument)this.args.get(i);
            sb.append("argument ");
            sb.append(i);
            sb.append(":\n");
            int j = 0;
            while (j < a.getNumberOfArguments()) {
                Argument sa = a.getArgument(j);
                sb.append("   ");
                sb.append(sa.toString());
                sb.append(" is-flag=");
                sb.append(sa.isFlag());
                sb.append(" has-flag-args=");
                boolean hasFlagArgs = sa.hasFlagArguments();
                sb.append(hasFlagArgs);
                if (hasFlagArgs) {
                    sb.append(" flag-args=");
                    sb.append(sa.getFlagArguments().toString());
                }
                sb.append("\n");
                ++j;
            }
            ++i;
        }
        return sb.toString();
    }

    public String getArgument(int index) {
        if (index < this.args.size()) {
            return ((Argument)this.args.get(index)).toString();
        }
        return "";
    }

    public String getLastArgument() {
        return this.getArgument(this.getNumberOfArguments() - 1);
    }

    public int getNumberOfArguments() {
        return this.args.size();
    }

    private Argument findFlag(String flag) {
        for (Argument a : this.args) {
            if (!a.isFlagOf(flag)) continue;
            return a;
        }
        return null;
    }

    public boolean containsFlag(String flag) {
        return this.findFlag(flag) != null;
    }

    public boolean isFlag(int index) {
        return ((Argument)this.args.get(index)).isFlag();
    }

    public String[] getArguments(String flag) {
        Argument fa;
        Argument a = this.findFlag(flag);
        if (a != null && (fa = a.getFlagArguments()) != null) {
            String[] s = new String[fa.getNumberOfArguments()];
            int i = 0;
            while (i < fa.getNumberOfArguments()) {
                s[i] = fa.getArgument(i).toString();
                ++i;
            }
            return s;
        }
        return new String[0];
    }

    public String getFirstArgument(String flag) {
        String[] s = this.getArguments(flag);
        if (s.length > 0) {
            return s[0];
        }
        return "";
    }

    private abstract class Argument {
        protected String text;
        private Argument flagArgs = null;

        private Argument() {
        }

        public abstract boolean isFlag();

        public abstract boolean isFlagOf(String var1);

        public abstract int getNumberOfArguments();

        public abstract Argument getArgument(int var1);

        void setFlagArguments(Argument arg) {
            this.flagArgs = arg;
        }

        public boolean hasFlagArguments() {
            return this.flagArgs != null;
        }

        public Argument getFlagArguments() {
            return this.flagArgs;
        }

        public String toString() {
            return this.text;
        }
    }

    private class MultiArgument
    extends Argument {
        private List subArgs;

        public MultiArgument(String text) {
            this.text = text;
            this.subArgs = new ArrayList();
            StringTokenizer st = new StringTokenizer(text, multiDelimiter);
            while (st.hasMoreTokens()) {
                SingleArgument arg = new SingleArgument(st.nextToken().trim());
                this.subArgs.add(arg);
            }
        }

        public boolean isFlag() {
            return false;
        }

        public boolean isFlagOf(String flag) {
            return this.isFlag();
        }

        public int getNumberOfArguments() {
            return this.subArgs.size();
        }

        public Argument getArgument(int index) {
            return (Argument)this.subArgs.get(index);
        }
    }

    private class SingleArgument
    extends Argument {
        public SingleArgument(String text) {
            this.text = text;
        }

        public boolean isFlag() {
            try {
                double d = Double.parseDouble(this.text);
                return false;
            }
            catch (Exception exception) {
                return this.text.startsWith("-");
            }
        }

        public boolean isFlagOf(String flag) {
            return this.isFlag() && this.text.indexOf(flag) >= 0;
        }

        public int getNumberOfArguments() {
            return 1;
        }

        public Argument getArgument(int index) {
            return this;
        }
    }
}

