/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.io;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LinuxSerialPort {
    private String portName;
    private int baudrate;
    private FileInputStream fis;
    private FileOutputStream fos;

    public LinuxSerialPort(String portName) {
        this.setPortName(portName);
        this.setBaudrate(38400);
    }

    public LinuxSerialPort() {
        this("/dev/null");
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName.startsWith("/dev/") ? portName : "/dev/" + portName;
    }

    public void setBaudrate(int baudrate) {
        this.baudrate = baudrate;
    }

    public int getBaudrate() {
        return this.baudrate;
    }

    public void open() throws IOException {
        this.fis = new FileInputStream(this.portName);
        this.fos = new FileOutputStream(this.portName);
        try {
            Runtime.getRuntime().exec("stty -F " + this.portName + " " + this.baudrate + " min 0" + " time 0" + " clocal" + " cread" + " -crtscts" + " cs8" + " -cstopb" + " -hup" + " -parenb" + " -parodd" + " -brkint" + " -icrnl" + " -ignbrk" + " -igncr" + " -ignpar" + " -inlcr" + " -inpck" + " -istrip" + " -iutf8" + " -iuclc" + " -ixany" + " -ixoff" + " -ixon" + " -parmrk" + " bs0" + " cr0" + " ff0" + " nl0" + " -ocrnl" + " -ofdel" + " -ofill" + " -olcuc" + " -onlcr" + " -onlret" + " -onocr" + " -opost" + " tab0" + " vt0" + " -crterase" + " -crtkill" + " -ctlecho" + " -echo" + " -echok" + " -echonl" + " -echoprt" + " -icanon" + " -iexten" + " -isig" + " -noflsh" + " -xcase" + " tostop").waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() throws IOException {
        if (this.fis != null) {
            this.fis.close();
        }
        if (this.fos != null) {
            this.fos.close();
        }
    }

    public InputStream getInputStream() {
        return this.fis;
    }

    public OutputStream getOutputStream() {
        return this.fos;
    }

    public void scanTerminal() throws IOException {
        char c;
        while (this.fis.available() > 0) {
            c = (char)this.fis.read();
            System.out.println("<-- " + this.toHumanReadable(c));
        }
        while (System.in.available() > 0) {
            c = (char)System.in.read();
            System.out.println("--> " + this.toHumanReadable(c));
            this.fos.write(c);
        }
    }

    private String toHumanReadable(char c) {
        String s;
        switch (c) {
            case '\n': {
                s = "\\n";
                break;
            }
            case '\r': {
                s = "\\r";
                break;
            }
            case '\t': {
                s = "\\t";
                break;
            }
            default: {
                s = "" + c;
            }
        }
        return s;
    }

    public static void main(String[] arg) {
        try {
            LinuxSerialPort sp = new LinuxSerialPort(arg[0]);
            sp.open();
            while (true) {
                sp.scanTerminal();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

