/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

public class XmlOutputStream {
    private OutputStream os;

    public XmlOutputStream(OutputStream os) {
        this.os = os;
    }

    private byte[] encodeSpecialCharacters(byte[] d) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < d.length) {
            switch (d[i]) {
                case 60: {
                    sb.append("&lt;");
                    break;
                }
                case 62: {
                    sb.append("&gt;");
                    break;
                }
                case 34: {
                    sb.append("&quot;");
                    break;
                }
                case 38: {
                    sb.append("&amp;");
                    break;
                }
                case 37: {
                    sb.append("&cent;");
                    break;
                }
                default: {
                    sb.append((char)d[i]);
                }
            }
            ++i;
        }
        return sb.toString().getBytes();
    }

    private void appendAttributes(HashMap attributes) throws IOException {
        Object[] k = attributes.keySet().toArray();
        Object[] v = attributes.values().toArray();
        int i = 0;
        while (i < k.length) {
            this.os.write(32);
            this.os.write(this.encodeSpecialCharacters(((String)k[i]).getBytes()));
            this.os.write(61);
            this.os.write(34);
            this.os.write(this.encodeSpecialCharacters(((String)v[i]).getBytes()));
            this.os.write(34);
            ++i;
        }
    }

    public void appendBeginTag(String name, HashMap attributes) throws IOException {
        this.os.write(60);
        this.os.write(this.encodeSpecialCharacters(name.getBytes()));
        this.appendAttributes(attributes);
        this.os.write(62);
    }

    public void appendBeginEndTag(String name, HashMap attributes) throws IOException {
        this.os.write(60);
        this.os.write(this.encodeSpecialCharacters(name.getBytes()));
        this.appendAttributes(attributes);
        this.os.write("/>".getBytes());
    }

    public void appendSystemTag() throws IOException {
        this.os.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes());
    }

    public void appendCommentTag(String comment) throws IOException {
        this.os.write("<!--".getBytes());
        this.os.write(this.encodeSpecialCharacters(comment.getBytes()));
        this.os.write("-->".getBytes());
    }

    public void appendCR() throws IOException {
        this.os.write(13);
        this.os.write(10);
    }

    public void appendTab(int n) throws IOException {
        int i = 0;
        while (i < n) {
            this.os.write(9);
            ++i;
        }
    }

    public void appendEndTag(String name) throws IOException {
        this.os.write("</".getBytes());
        this.os.write(this.encodeSpecialCharacters(name.getBytes()));
        this.os.write(62);
    }

    public void appendDataChunk(String data) throws IOException {
        this.os.write(data.getBytes());
    }

    public void close() throws IOException {
        this.os.flush();
        this.os.close();
    }

    public static void main(String[] arg) {
        try {
            XmlOutputStream os = new XmlOutputStream(new BufferedOutputStream(new FileOutputStream(new File("writeTest.laoe"))));
            os.appendSystemTag();
            HashMap<String, String> attr = new HashMap<String, String>();
            attr.put("type", "complete");
            attr.put("samplerate", "44100");
            attr.put("samplewith", "16");
            attr.put("comment", "durch LAoE erstellt!");
            os.appendBeginTag("clip", attr);
            os.appendDataChunk("1 2 3 4 5 ");
            os.appendDataChunk("9.77 12.345");
            os.appendEndTag("clip");
            os.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

