/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.io;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XmlPathAccess {
    private Element rootElement;

    public XmlPathAccess(String data) throws Exception {
        StringReader sr = new StringReader(data);
        InputSource is = new InputSource(sr);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document d = db.parse(is);
        this.rootElement = d.getDocumentElement();
    }

    public XmlPathAccess(File file) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document d = db.parse(file);
        this.rootElement = d.getDocumentElement();
    }

    private Element getRootElement() {
        return this.rootElement;
    }

    private String[] parsePath(String path) {
        StringTokenizer st = new StringTokenizer(path, "/");
        String[] s = new String[st.countTokens()];
        int i = 0;
        while (i < s.length) {
            s[i] = st.nextToken();
            ++i;
        }
        return s;
    }

    public Element getElement(String path) {
        String[] s = this.parsePath(path);
        Element e = this.getRootElement();
        int i = 1;
        while (i < s.length) {
            e = (Element)e.getElementsByTagName(s[i]).item(0);
            ++i;
        }
        return e;
    }

    public String getElementTagName(String path) {
        return this.getElement(path).getTagName();
    }

    public String getElementAttributeString(String path, String attribute) {
        return this.getElement(path).getAttribute(attribute);
    }

    public int getElementAttributeInt(String path, String attribute) {
        return Integer.parseInt(this.getElementAttributeString(path, attribute));
    }

    public float getElementAttributeFloat(String path, String attribute) {
        return Float.parseFloat(this.getElementAttributeString(path, attribute));
    }

    public boolean getElementAttributeBoolean(String path, String attribute) {
        return new Boolean(this.getElementAttributeString(path, attribute));
    }

    public String getElementDataString(String path) {
        return ((Text)this.getElement(path).getFirstChild()).getData();
    }

    public int[] getElementDataIntArray(String path) {
        StringTokenizer st = new StringTokenizer(this.getElementDataString(path));
        int[] d = new int[st.countTokens()];
        int i = 0;
        while (i < d.length) {
            d[i] = Integer.parseInt(st.nextToken());
            ++i;
        }
        return d;
    }

    public byte[] getElementDataByteArray(String path) {
        StringTokenizer st = new StringTokenizer(this.getElementDataString(path));
        byte[] d = new byte[st.countTokens()];
        int i = 0;
        while (i < d.length) {
            d[i] = Byte.parseByte(st.nextToken());
            ++i;
        }
        return d;
    }

    public float[] getElementDataFloatArray(String path) {
        StringTokenizer st = new StringTokenizer(this.getElementDataString(path));
        float[] d = new float[st.countTokens()];
        int i = 0;
        while (i < d.length) {
            d[i] = Float.parseFloat(st.nextToken());
            ++i;
        }
        return d;
    }

    public boolean isElementExisting(String path) {
        try {
            this.getElement(path).getTagName();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String createString() throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = tf.newTransformer();
        DOMSource ds = new DOMSource(this.getRootElement());
        StringWriter sw = new StringWriter();
        StreamResult sr = new StreamResult(sw);
        t.transform(ds, sr);
        return sw.toString();
    }
}

