/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.mmedia.game;

import ch.oli4.mmedia.MAnimation;
import ch.oli4.mmedia.game.CObject;
import ch.oli4.mmedia.game.CPerspective;
import ch.oli4.mmedia.game.EventProducer;
import ch.oli4.mmedia.game.Perspective;

public class CObjectAnimation
extends CObject {
    public static final int PLAY_FORWARD = 0;
    public static final int PLAY_BACKWARD = 1;
    public static final int PLAY_ZIGZAG = 2;
    public static final int PLAY_SEQUENCE = 3;
    public MAnimation animation = null;
    private int play;
    private int cycles;
    public String animationName;
    private int frames;
    private int period;
    private int x;
    private int y;
    private int[] sequence;
    private boolean blocking;

    public CObjectAnimation(String animationName, int frames, int period, int x, int y, int play, int[] sequence, int cycles, boolean blocking) {
        this.animationName = animationName;
        this.frames = frames;
        this.period = period;
        this.x = x;
        this.y = y;
        this.play = play;
        this.sequence = sequence;
        this.cycles = cycles;
        this.blocking = blocking;
    }

    public CObjectAnimation(String animationName, int frames, int period, int x, int y, int play, int cycles, boolean blocking) {
        this(animationName, frames, period, x, y, play, null, cycles, blocking);
    }

    public CObjectAnimation(String animationName, int frames, int period, int x, int y, int play, int cycles) {
        this(animationName, frames, period, x, y, play, cycles, false);
    }

    void init(Perspective p) {
        this.animation = new MAnimation(this.animationName, this.frames, Perspective.getPanel(), this.x, this.y);
        p.add(this.animation);
    }

    void setup() {
        if (this.blocking) {
            switch (this.play) {
                case 0: {
                    this.animation.synchForward(this.period, this.cycles);
                    break;
                }
                case 1: {
                    this.animation.synchBackward(this.period, this.cycles);
                    break;
                }
                case 2: {
                    this.animation.synchZigzag(this.period, this.cycles);
                    break;
                }
                case 3: {
                    this.animation.synchSequence(this.sequence, this.period, this.cycles);
                }
            }
        } else {
            switch (this.play) {
                case 0: {
                    this.animation.asynchForward(this.period, this.cycles);
                    break;
                }
                case 1: {
                    this.animation.asynchBackward(this.period, this.cycles);
                    break;
                }
                case 2: {
                    this.animation.asynchZigzag(this.period, this.cycles);
                    break;
                }
                case 3: {
                    this.animation.asynchSequence(this.sequence, this.period, this.cycles);
                }
            }
        }
    }

    void perform(CPerspective p, EventProducer a) {
    }

    void cleanup() {
        this.animation.asynchStop();
    }
}

