/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.mmedia.game;

import ch.oli4.mmedia.MTimer;
import ch.oli4.mmedia.game.CObject;
import ch.oli4.mmedia.game.CObjectDoor;
import ch.oli4.mmedia.game.CPerspective;
import ch.oli4.mmedia.game.EventProducer;
import ch.oli4.mmedia.game.Game;
import ch.oli4.mmedia.game.Path;
import ch.oli4.mmedia.game.Perspective;

public class CObjectDoubleDoor
extends CObject {
    CObjectDoor primary;
    CObjectDoor secondary;

    public CObjectDoubleDoor(CObjectDoor primary, CObjectDoor secondary) {
        this.primary = primary;
        this.secondary = secondary;
    }

    void print() {
        this.primary.print();
        this.secondary.print();
    }

    void init(Perspective p) {
        this.primary.init(p);
        this.secondary.init(p);
        this.primary.openArea.setEnabled(true);
        this.primary.closeArea.setEnabled(false);
        this.primary.navigateArea.setEnabled(false);
        this.secondary.openArea.setEnabled(false);
        this.secondary.closeArea.setEnabled(false);
        this.secondary.navigateArea.setEnabled(false);
    }

    void setup() {
        this.primary.setup();
        this.secondary.setup();
    }

    void perform(CPerspective p, EventProducer a) {
        if (a == this.primary.openArea) {
            this.primary.performOpen(p, true);
            this.primary.updateOpenClose();
            this.secondary.openArea.setEnabled(true);
        } else if (a == this.primary.closeArea) {
            this.secondary.performClose();
            this.secondary.updateOpenClose();
            p.reprint();
            MTimer.sleep(500);
            this.primary.performClose();
            this.primary.updateOpenClose();
            this.secondary.openArea.setEnabled(false);
        } else if (a == this.primary.navigateArea && this.primary.path != null) {
            this.primary.walkedThrough = true;
            this.secondary.walkedThrough = true;
            Game.getInstance().setNextPath(new Path(this.primary.path));
        }
        if (a == this.secondary.openArea) {
            this.secondary.performOpen(p, false);
            this.secondary.updateOpenClose();
        } else if (a == this.secondary.closeArea) {
            this.secondary.performClose();
            this.secondary.updateOpenClose();
        } else if (a == this.secondary.navigateArea && this.secondary.path != null) {
            this.primary.walkedThrough = true;
            this.secondary.walkedThrough = true;
            Game.getInstance().setNextPath(new Path(this.secondary.path));
        }
    }

    void cleanup() {
        if (!this.secondary.walkedThrough) {
            this.secondary.performClose();
            this.secondary.updateOpenClose();
        }
        if (!this.primary.walkedThrough) {
            this.primary.performClose();
            this.primary.updateOpenClose();
            this.secondary.openArea.setEnabled(false);
        }
    }
}

