/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.mmedia.game;

import ch.oli4.mmedia.MTimer;
import ch.oli4.mmedia.game.ActiveArea;
import ch.oli4.mmedia.game.CObject;
import ch.oli4.mmedia.game.CPerspective;
import ch.oli4.mmedia.game.EventProducer;
import ch.oli4.mmedia.game.Game;
import ch.oli4.mmedia.game.GameState;
import ch.oli4.mmedia.game.Path;
import ch.oli4.mmedia.game.Perspective;
import ch.oli4.mmedia.game.Timer;

public class CObjectEngine
extends CObject {
    ActiveArea onArea;
    ActiveArea offArea;
    private CObject switchOnObject;
    private CObject switchOffObject;
    private CObject nearWhileOnObject;
    private CObject farWhileOnObject;
    private CObject whileOffObject;
    String onCondition;
    String onState;
    String onPath;
    String offPath;
    boolean initialState;
    boolean activelyLocked;
    boolean running;
    Timer timer;
    CPerspective perspective;

    public CObjectEngine(ActiveArea onArea, ActiveArea offArea, CObject switchOnObject, CObject switchOffObject, CObject nearWhileOnObject, CObject farWhileOnObject, CObject whileOffObject, String onCondition, String onState, String onPath, String offPath, boolean initialState, boolean activelyLocked) {
        this.onArea = onArea;
        this.offArea = offArea;
        this.switchOnObject = switchOnObject;
        this.switchOffObject = switchOffObject;
        this.nearWhileOnObject = nearWhileOnObject;
        this.whileOffObject = whileOffObject;
        this.farWhileOnObject = farWhileOnObject;
        this.onCondition = onCondition;
        this.onState = onState;
        this.onPath = onPath;
        this.offPath = offPath;
        this.initialState = initialState;
        this.activelyLocked = activelyLocked;
    }

    void print() {
        if (this.running) {
            this.optionalPrint(this.nearWhileOnObject);
        } else {
            this.optionalPrint(this.whileOffObject);
        }
    }

    private void updateAreas() {
        boolean c = this.onCondition == null || GameState.getInstance().getBoolean(this.onCondition, false);
        this.onArea.setEnabled(!this.running && (c || this.activelyLocked));
        this.offArea.setEnabled(this.running && c);
    }

    private void optionalPlayAndWait(CObject n) {
        if (n != null) {
            n.setup();
            MTimer.sleep(333);
        }
    }

    private void optionalSetup(CObject o) {
        if (o != null) {
            o.setup();
        }
    }

    private void optionalCleanup(CObject o) {
        if (o != null) {
            o.cleanup();
        }
    }

    private void optionalPrint(CObject o) {
        if (o != null) {
            o.print();
        }
    }

    private void optionalInit(Perspective p, CObject o) {
        if (o != null) {
            o.init(p);
        }
    }

    private void updateRunningObjects() {
        if (this.running) {
            this.optionalCleanup(this.whileOffObject);
            this.optionalSetup(this.nearWhileOnObject);
        } else {
            this.optionalCleanup(this.nearWhileOnObject);
            this.optionalSetup(this.whileOffObject);
        }
    }

    private void stopRunningObjects() {
        this.optionalCleanup(this.whileOffObject);
        this.optionalCleanup(this.nearWhileOnObject);
    }

    private void udateFarRunningObjects(boolean isFar) {
        if (isFar && this.running) {
            this.optionalSetup(this.farWhileOnObject);
        } else {
            this.optionalCleanup(this.farWhileOnObject);
        }
    }

    void init(Perspective p) {
        this.running = false;
        p.add(this.onArea);
        p.add(this.offArea);
        this.optionalInit(p, this.switchOffObject);
        this.optionalInit(p, this.switchOnObject);
        this.optionalInit(p, this.nearWhileOnObject);
        this.optionalInit(p, this.whileOffObject);
        this.timer = new Timer("path-timer");
        p.add(this.timer);
        this.updateAreas();
    }

    private void performOn() {
        if (!this.running) {
            if (GameState.getInstance().getBoolean(this.onCondition, false) || this.onCondition == null) {
                this.optionalPlayAndWait(this.switchOnObject);
                this.running = true;
                GameState.getInstance().setBoolean(this.onState, true);
                this.updateRunningObjects();
                this.timer.start(500);
            } else {
                this.optionalPlayAndWait(this.switchOnObject);
                this.optionalPlayAndWait(this.switchOffObject);
            }
        }
    }

    private void performOff() {
        if (this.running) {
            this.optionalPlayAndWait(this.switchOffObject);
            this.running = false;
            GameState.getInstance().setBoolean(this.onState, false);
            this.updateRunningObjects();
            this.timer.start(500);
        }
    }

    private void navigate() {
        if (this.running) {
            if (this.onPath != null) {
                Game.getInstance().setNextPath(new Path(this.onPath));
            }
        } else if (this.offPath != null) {
            Game.getInstance().setNextPath(new Path(this.offPath));
        }
    }

    void setup() {
        this.running = GameState.getInstance().getBoolean(this.onState, false);
        this.updateRunningObjects();
        this.updateAreas();
        this.udateFarRunningObjects(false);
    }

    void perform(CPerspective p, EventProducer a) {
        if (a == this.onArea) {
            this.performOn();
        } else if (a == this.offArea) {
            this.performOff();
        } else if (a == this.timer) {
            this.navigate();
        }
        this.updateAreas();
    }

    void cleanup() {
        this.udateFarRunningObjects(true);
        this.stopRunningObjects();
        this.timer.stop();
    }
}

