/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.mmedia.game;

import ch.oli4.trace.Trace;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Cache<T> {
    private CacheFactory<T> factory;
    private List<String> history;
    private Map<String, T> objects;
    private int maxLength;

    public Cache(CacheFactory<T> f, int maxLength) {
        Trace.getInstance().addEntry(4, "create cache");
        this.factory = f;
        this.maxLength = maxLength;
        this.history = new LinkedList<String>();
        this.objects = new HashMap<String, T>();
    }

    public final synchronized T get(String name) {
        if (!this.objects.containsKey(name)) {
            Trace.getInstance().addEntry(4, "cache create new object (cache size now " + this.objects.size() + "): " + name);
            T o = this.factory.createInstance(name);
            this.objects.put(name, o);
            this.history.add(name);
            int i = 0;
            while (i < 3) {
                if (this.maxLength == 0 || this.history.size() <= this.maxLength) break;
                String n = this.history.get(0);
                if (!n.equals(name)) {
                    T oo = this.objects.get(n);
                    if (this.factory.dispose(oo)) {
                        this.objects.remove(n);
                        this.history.remove(0);
                        Trace.getInstance().addEntry(4, "cache dispose oldest object " + n);
                    } else {
                        this.markRecentlyUsed(n);
                        Trace.getInstance().addEntry(4, "could not dispose oldest " + n + ", since it is still in use, so this has been marked 'recently used'");
                    }
                }
                ++i;
            }
            return o;
        }
        this.markRecentlyUsed(name);
        Trace.getInstance().addEntry(8, "cache reuse object " + name + ", and marked 'recently used'");
        return this.objects.get(name);
    }

    private void markRecentlyUsed(String name) {
        this.history.remove(name);
        this.history.add(name);
    }

    public synchronized void clear() {
        Trace.getInstance().addEntry(4, "cache dispose");
        for (T o : this.objects.values()) {
            this.factory.dispose(o);
        }
        this.objects.clear();
        this.history.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface CacheFactory<T> {
        public T createInstance(String var1);

        public boolean dispose(T var1);
    }
}

