/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.mmedia.game;

import ch.oli4.trace.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class GameState {
    private static GameState instance = null;
    private static final String persistenceFile = String.valueOf(System.getProperty("user.home")) + "/.secret-de-la-montagne.persistence";
    private Map<String, Boolean> booleanStates;
    private Map<String, Integer> intStates;
    private Map<String, String> stringStates;

    private GameState() {
        this.restore();
    }

    public static GameState getInstance() {
        if (instance == null) {
            instance = new GameState();
        }
        return instance;
    }

    public void backup() {
        Trace.getInstance().addEntry(4, "game state backup");
        try {
            FileOutputStream fos = new FileOutputStream(persistenceFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.booleanStates);
            oos.writeObject(this.intStates);
            oos.writeObject(this.stringStates);
            oos.flush();
            oos.close();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void restore() {
        Trace.getInstance().addEntry(4, "game state restore");
        this.booleanStates = new ConcurrentHashMap<String, Boolean>();
        this.intStates = new ConcurrentHashMap<String, Integer>();
        this.stringStates = new ConcurrentHashMap<String, String>();
        try {
            FileInputStream fis = new FileInputStream(persistenceFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.booleanStates = (Map)ois.readObject();
            this.intStates = (Map)ois.readObject();
            this.stringStates = (Map)ois.readObject();
            ois.close();
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void factoryReset() {
        File f = new File(persistenceFile);
        f.delete();
    }

    private String createKey(String key) {
        return key;
    }

    public void setBoolean(String key, boolean value) {
        if (key != null) {
            Trace.getInstance().addEntry(4, "game state set boolean " + key + " to " + value);
            this.booleanStates.put(this.createKey(key), value);
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        boolean inversed = false;
        if (key != null && key.startsWith("!")) {
            key = key.substring(1);
            inversed = true;
        }
        if (key != null && this.booleanStates.containsKey(this.createKey(key))) {
            return this.booleanStates.get(this.createKey(key)) ^ inversed;
        }
        this.setBoolean(key, defaultValue);
        return defaultValue;
    }

    public void setInteger(String key, int value) {
        if (key != null) {
            Trace.getInstance().addEntry(4, "game state set integer " + key + " to " + value);
            this.intStates.put(this.createKey(key), value);
        }
    }

    public int getInteger(String key, int defaultValue) {
        if (key != null && this.intStates.containsKey(this.createKey(key))) {
            return this.intStates.get(this.createKey(key));
        }
        this.setInteger(key, defaultValue);
        return defaultValue;
    }

    public void setString(String key, String value) {
        if (key != null) {
            Trace.getInstance().addEntry(4, "game state set string " + key + " to " + value);
            this.stringStates.put(this.createKey(key), value);
        }
    }

    public String getString(String key, String defaultValue) {
        if (key != null && this.stringStates.containsKey(this.createKey(key))) {
            return this.stringStates.get(this.createKey(key));
        }
        this.setString(key, defaultValue);
        return defaultValue;
    }

    public String getAllStates() {
        TreeMap<String, String> sm = new TreeMap<String, String>();
        for (String i : this.booleanStates.keySet()) {
            sm.put(i, this.booleanStates.get(i) + " (boolean)");
        }
        for (String i : this.intStates.keySet()) {
            sm.put(i, this.intStates.get(i) + " (int)");
        }
        for (String i : this.stringStates.keySet()) {
            sm.put(i, this.stringStates.get(i) + " (string)");
        }
        StringBuffer sb = new StringBuffer();
        for (String i : sm.keySet()) {
            sb.append(String.valueOf(i) + " = " + (String)sm.get(i) + "\n");
        }
        return sb.toString();
    }
}

