/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.persistence;

import ch.oli4.persistence.Persistence;
import ch.oli4.persistence.PersistenceException;
import ch.oli4.text.TextToolkit;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class PersistenceDefaultImpl
extends Persistence {
    private Properties database;
    private String path;

    public void restore(String path) throws PersistenceException {
        try {
            this.path = path;
            FileInputStream is = new FileInputStream(this.path);
            this.database = new Properties();
            this.database.load(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PersistenceException("could not restore persistence");
        }
    }

    public void backup() throws PersistenceException {
        this.fireOnBackup();
        try {
            FileOutputStream os = new FileOutputStream(this.path);
            this.database.store(os, this.path);
        }
        catch (IOException ioe) {
            throw new PersistenceException("could not restore persistence");
        }
    }

    public boolean contains(String name) {
        return this.database.containsKey(name);
    }

    public void setString(String name, String value) {
        try {
            this.database.setProperty(name, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setInt(String name, int value) {
        try {
            this.database.setProperty(name, Integer.toString(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFloat(String name, float value) {
        try {
            this.database.setProperty(name, Float.toString(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDouble(String name, double value) {
        try {
            this.database.setProperty(name, Double.toString(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setBoolean(String name, boolean value) {
        try {
            this.database.setProperty(name, Boolean.toString(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getString(String name, String defaultValue) {
        if (this.database == null) {
            return defaultValue;
        }
        String v = this.database.getProperty(name);
        if (v == null) {
            return defaultValue;
        }
        return v;
    }

    public String getString(String name) {
        return this.getString(name, "");
    }

    public int getInt(String name, int defaultValue) {
        if (this.database == null) {
            return defaultValue;
        }
        String v = this.database.getProperty(name);
        if (v == null) {
            return defaultValue;
        }
        return TextToolkit.toDecInt(v);
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public float getFloat(String name, float defaultValue) {
        if (this.database == null) {
            return defaultValue;
        }
        String v = this.database.getProperty(name);
        if (v == null) {
            return defaultValue;
        }
        return TextToolkit.toFloat(v);
    }

    public float getFloat(String name) {
        return this.getFloat(name, 0.0f);
    }

    public double getDouble(String name, double defaultValue) {
        if (this.database == null) {
            return defaultValue;
        }
        String v = this.database.getProperty(name);
        if (v == null) {
            return defaultValue;
        }
        return TextToolkit.toDouble(v);
    }

    public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        if (this.database == null) {
            return defaultValue;
        }
        String v = this.database.getProperty(name);
        if (v == null) {
            return defaultValue;
        }
        return TextToolkit.toBoolean(v);
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }
}

