/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.text;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public class Debug {
    private static int verboseLevel = 0;
    private static int lineCounter = 0;
    private static boolean timeStampEnable = false;
    private static DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.GERMAN);
    private static File outputFile = null;
    private static FileOutputStream fOutputStream;
    private static PrintStream pOutputStream;

    public static void setVerboseLevel(int l) {
        verboseLevel = l;
    }

    public static void setOutputFile(String fileName) {
        if (fileName != null) {
            try {
                outputFile = new File(fileName);
                if ((double)outputFile.length() > 1.0E7) {
                    outputFile.delete();
                }
                outputFile.createNewFile();
                fOutputStream = new FileOutputStream(outputFile, true);
                pOutputStream = new PrintStream(fOutputStream);
                System.setOut(pOutputStream);
                System.setErr(pOutputStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setTimeStampEnabled(boolean b) {
        timeStampEnable = b;
        lineCounter = 0;
    }

    public static void println(int level, String s) {
        if (verboseLevel != 0) {
            if (lineCounter++ == 0) {
                System.out.println("debug logging:");
                if (timeStampEnable) {
                    System.out.println("date");
                    System.out.println("|          time");
                    System.out.println("|          |         level");
                    System.out.println("|          |         |  text");
                    System.out.println("|          |         |  |");
                } else {
                    System.out.println("level");
                    System.out.println("| text");
                    System.out.println("|  |");
                }
            }
            if (level <= verboseLevel) {
                if (timeStampEnable) {
                    System.out.print(String.valueOf(dateFormat.format(new Date())) + "  ");
                }
                System.out.print(level + "  ");
                System.out.println(s);
            }
        }
    }

    public static void printStackTrace(int level, Exception e) {
        if (verboseLevel != 0 && level <= verboseLevel) {
            if (timeStampEnable) {
                System.out.print(String.valueOf(dateFormat.format(new Date())) + "  ");
            }
            System.out.println(level + " exception thrown below:");
            e.printStackTrace();
        }
    }
}

