/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui;

public class UiFifo {
    private Object[] body;
    private int head;
    private int tail;
    private int maxSize;

    public UiFifo(int maxSize) {
        this.maxSize = maxSize + 1;
        this.body = new Object[this.maxSize];
        this.head = 0;
        this.tail = 0;
    }

    public void clear() {
        this.head = 0;
        this.tail = 0;
    }

    public void put(Object o) {
        if (!this.isNotFull()) {
            this.tail = (this.tail + 1) % this.maxSize;
        }
        this.body[this.head] = o;
        this.head = (this.head + 1) % this.maxSize;
    }

    public Object get() {
        Object o = this.body[this.tail];
        this.tail = (this.tail + 1) % this.maxSize;
        return o;
    }

    public void replace(Object o, int index) {
        this.body[(this.tail + index) % this.maxSize] = o;
    }

    public Object pick(int index) {
        if (index < this.getActualSize()) {
            return this.body[(this.tail + index) % this.maxSize];
        }
        return null;
    }

    public boolean isNotEmpty() {
        return this.head != this.tail;
    }

    public boolean isNotFull() {
        return (this.head + 1) % this.maxSize != this.tail;
    }

    public int getActualSize() {
        return (this.head + this.maxSize - this.tail) % this.maxSize;
    }
}

