/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui;

import ch.oli4.ui.UiAppl;
import ch.oli4.ui.UiFrame;
import ch.oli4.ui.UiLanguage;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;

public class UiMenuBar
extends JMenuBar
implements ActionListener,
ItemListener {
    protected UiAppl appl;
    protected UiFrame frame;
    protected UiLanguage language;
    protected JMenu fileMenu;
    protected JMenuItem newItem;
    protected JMenuItem openItem;
    protected JMenuItem saveItem;
    protected JMenuItem saveAsItem;
    protected JMenuItem closeItem;
    protected JMenuItem exitItem;
    protected JMenu windowMenu;
    protected JMenu viewMenu;
    protected JCheckBoxMenuItem[] toolBarItem;
    protected JCheckBoxMenuItem statusBarItem;
    protected JMenu languageMenu;
    protected ButtonGroup languageGroup;
    protected JRadioButtonMenuItem[] languageRadioButton;
    protected JMenu helpMenu;
    protected JMenuItem contentItem;
    protected JMenuItem aboutItem;
    protected JMenuItem autorItem;

    public UiMenuBar(UiFrame frame) {
        this.appl = frame.getAppl();
        this.frame = frame;
        this.language = this.appl.getUiLanguage();
    }

    public void addFileMenu() {
        this.fileMenu = new JMenu(this.language.getText("uiFile"));
        this.newItem = new JMenuItem(this.language.getText("uiNew"));
        this.newItem.addActionListener(this);
        this.newItem.setEnabled(false);
        this.fileMenu.add(this.newItem);
        this.openItem = new JMenuItem(this.language.getText("uiOpen"));
        this.openItem.addActionListener(this);
        this.openItem.setEnabled(false);
        this.fileMenu.add(this.openItem);
        this.fileMenu.add(new JSeparator());
        this.saveItem = new JMenuItem(this.language.getText("uiSave"));
        this.saveItem.addActionListener(this);
        this.saveItem.setEnabled(false);
        this.fileMenu.add(this.saveItem);
        this.saveAsItem = new JMenuItem(this.language.getText("uiSaveAs"));
        this.saveAsItem.addActionListener(this);
        this.saveAsItem.setEnabled(false);
        this.fileMenu.add(this.saveAsItem);
        this.fileMenu.add(new JSeparator());
        this.closeItem = new JMenuItem(this.language.getText("uiClose"));
        this.closeItem.addActionListener(this);
        this.fileMenu.add(this.closeItem);
        this.exitItem = new JMenuItem(this.language.getText("uiExit"));
        this.exitItem.addActionListener(this);
        this.fileMenu.add(this.exitItem);
        this.add(this.fileMenu);
        this.frame.validate();
    }

    public void addWindowMenu() {
        this.windowMenu = new JMenu(this.language.getText("uiWindow"));
        this.viewMenu = new JMenu(this.language.getText("uiView"));
        this.windowMenu.add(this.viewMenu);
        this.toolBarItem = new JCheckBoxMenuItem[5];
        int i = 0;
        while (i < 5) {
            if (this.frame.getUiToolBar(i) != null) {
                this.toolBarItem[i] = new JCheckBoxMenuItem(this.frame.getUiToolBar(i).getName());
                this.toolBarItem[i].setState(this.frame.getUiToolBar(i).isVisible());
                this.toolBarItem[i].addItemListener(this);
                this.viewMenu.add(this.toolBarItem[i]);
            }
            ++i;
        }
        if (this.frame.getUiStatusBar() != null) {
            this.viewMenu.add(new JSeparator());
            this.statusBarItem = new JCheckBoxMenuItem(this.frame.getUiStatusBar().getName());
            this.statusBarItem.setState(this.frame.getUiStatusBar().isVisible());
            this.statusBarItem.addItemListener(this);
            this.viewMenu.add(this.statusBarItem);
        }
        this.languageMenu = new JMenu(this.language.getText("uiLanguage"));
        this.languageMenu.setEnabled(false);
        this.languageGroup = new ButtonGroup();
        String[] languageNames = this.language.getAllLanguages();
        this.languageRadioButton = new JRadioButtonMenuItem[languageNames.length];
        int i2 = 0;
        while (i2 < languageNames.length) {
            this.languageRadioButton[i2] = new JRadioButtonMenuItem(this.language.getText(languageNames[i2]));
            this.languageGroup.add(this.languageRadioButton[i2]);
            this.languageMenu.add(this.languageRadioButton[i2]);
            if (languageNames[i2].equals(this.language.getActualLanguage())) {
                this.languageRadioButton[i2].setSelected(true);
            }
            this.languageRadioButton[i2].addActionListener(this);
            ++i2;
        }
        this.windowMenu.add(this.languageMenu);
        this.add(this.windowMenu);
        this.frame.validate();
    }

    public void addHelpMenu() {
        this.helpMenu = new JMenu(this.language.getText("uiHelp"));
        this.contentItem = new JMenuItem(this.language.getText("uiContent"));
        this.contentItem.addActionListener(this);
        this.helpMenu.add(this.contentItem);
        this.helpMenu.add(new JSeparator());
        this.aboutItem = new JMenuItem(this.language.getText("uiAbout"));
        this.aboutItem.addActionListener(this);
        this.helpMenu.add(this.aboutItem);
        this.autorItem = new JMenuItem(this.language.getText("uiAutor"));
        this.autorItem.addActionListener(this);
        this.helpMenu.add(this.autorItem);
        this.add(this.helpMenu);
        this.frame.validate();
    }

    public void actionPerformed(ActionEvent e) {
        int i = 0;
        while (i < this.languageRadioButton.length) {
            if (e.getSource() == this.languageRadioButton[i]) {
                this.language.setLanguage(this.language.getAllLanguages()[i]);
                this.frame.rebuild();
                return;
            }
            ++i;
        }
        if (this.frame.getUiHelp() != null) {
            if (e.getSource() == this.contentItem) {
                this.frame.getUiHelp().setVisible(true);
                return;
            }
            if (e.getSource() == this.aboutItem) {
                this.frame.getUiDialog().showAboutDialog();
                return;
            }
            if (e.getSource() == this.autorItem) {
                this.frame.getUiDialog().showAutorDialog();
                return;
            }
        }
        if (e.getSource() == this.closeItem) {
            this.frame.tryToClose();
            return;
        }
        if (e.getSource() == this.exitItem) {
            this.frame.tryToExit();
            return;
        }
    }

    public void itemStateChanged(ItemEvent e) {
        int i = 0;
        while (i < 5) {
            if (e.getSource() == this.toolBarItem[i]) {
                this.frame.setUiToolBarVisible(((JCheckBoxMenuItem)e.getSource()).getState(), i);
                return;
            }
            ++i;
        }
        if (e.getSource() == this.statusBarItem) {
            this.frame.setUiStatusBarVisible(((JCheckBoxMenuItem)e.getSource()).getState());
            return;
        }
    }
}

