/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.clock;

import ch.oli4.ui.clock.UiClockEvent;
import ch.oli4.ui.clock.UiClockListener;
import ch.oli4.ui.clock.UiClockModel;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Vector;

public class UiClockPassiveModel
implements UiClockModel,
Runnable {
    protected Object viewControl;
    protected Thread thread;
    protected static final int resolution = 200;
    protected boolean running;
    protected Calendar currentCalendar;
    protected Vector listenerList;
    private int oldHour;
    private int oldMinute;
    private int oldSecond;

    public UiClockPassiveModel(Object viewControl) {
        this.viewControl = viewControl;
        this.listenerList = new Vector();
        this.thread = new Thread(this);
        this.thread.start();
        this.running = false;
        this.setTime(GregorianCalendar.getInstance());
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.running) continue;
            this.onInternalTimePolling();
            this.onEventPolling();
        }
    }

    public void start() {
        this.running = true;
    }

    public void stop() {
        this.running = false;
    }

    public Calendar getTime() {
        return this.currentCalendar;
    }

    public void setTime(Calendar c) {
        this.currentCalendar = c;
        this.onExternalTimeSetting();
        this.onEventPolling();
    }

    protected void onExternalTimeSetting() {
    }

    protected void onInternalTimePolling() {
    }

    public void addSecond(int s) {
        this.currentCalendar.add(13, s);
        this.onExternalTimeSetting();
        this.onEventPolling();
    }

    public void addMinute(int m) {
        this.currentCalendar.add(12, m);
        this.onExternalTimeSetting();
        this.onEventPolling();
    }

    public void addHour(int h) {
        this.currentCalendar.add(11, h);
        this.onExternalTimeSetting();
        this.onEventPolling();
    }

    public void addDayOfMonth(int d) {
        this.currentCalendar.add(5, d);
        this.onExternalTimeSetting();
        this.onEventPolling();
    }

    public void addMonth(int m) {
        this.currentCalendar.add(2, m);
        this.onExternalTimeSetting();
        this.onEventPolling();
    }

    public void addClockListener(UiClockListener l) {
        this.listenerList.add(l);
    }

    public void removeClockListener(UiClockListener l) {
        this.listenerList.remove(l);
    }

    protected void onEventPolling() {
        if (this.hasSecondChanged()) {
            this.processOnSecondEvent();
        }
        if (this.hasMinuteChanged()) {
            this.processOnMinuteEvent();
        }
        if (this.hasHourChanged()) {
            this.processOnHourEvent();
        }
    }

    protected void processOnSecondEvent() {
        Object[] cl = this.listenerList.toArray();
        UiClockEvent ce = new UiClockEvent(this.viewControl);
        int i = 0;
        while (i < cl.length) {
            ((UiClockListener)cl[i]).onSecond(ce);
            ++i;
        }
    }

    protected void processOnMinuteEvent() {
        Object[] cl = this.listenerList.toArray();
        UiClockEvent ce = new UiClockEvent(this.viewControl);
        int i = 0;
        while (i < cl.length) {
            ((UiClockListener)cl[i]).onMinute(ce);
            ++i;
        }
    }

    protected void processOnHourEvent() {
        Object[] cl = this.listenerList.toArray();
        UiClockEvent ce = new UiClockEvent(this.viewControl);
        int i = 0;
        while (i < cl.length) {
            ((UiClockListener)cl[i]).onHour(ce);
            ++i;
        }
    }

    protected void processOnTriggerEvent() {
        Object[] cl = this.listenerList.toArray();
        UiClockEvent ce = new UiClockEvent(this.viewControl);
        int i = 0;
        while (i < cl.length) {
            ((UiClockListener)cl[i]).onTrigger(ce);
            ++i;
        }
    }

    private boolean hasHourChanged() {
        int h = this.currentCalendar.get(11);
        if (h != this.oldHour) {
            this.oldHour = h;
            return true;
        }
        return false;
    }

    private boolean hasMinuteChanged() {
        int m = this.currentCalendar.get(12);
        if (m != this.oldMinute) {
            this.oldMinute = m;
            return true;
        }
        return false;
    }

    private boolean hasSecondChanged() {
        int s = this.currentCalendar.get(13);
        if (s != this.oldSecond) {
            this.oldSecond = s;
            return true;
        }
        return false;
    }
}

