/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.control;

import ch.oli4.ui.UiMouseTrackEvent;
import ch.oli4.ui.UiMouseTrackListener;
import ch.oli4.ui.UiMouseTracker;
import ch.oli4.ui.control.UiControlDouble;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class UiControlText
extends UiControlDouble
implements ActionListener,
UiMouseTrackListener,
KeyListener {
    private JButton increment;
    private JButton decrement;
    private UiMouseTracker mouseTracker;
    private JButton unit;
    private ArrayList unitName;
    private ArrayList unitFactor;
    protected int unitIndex;
    private JTextField text;
    private NumberFormat format;
    public static final int FLOATING_POINT_FORMAT = 1;
    public static final int INTEGER_FORMAT = 2;
    protected boolean editable;

    public UiControlText(int digits) {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.text = new JTextField(digits);
        this.text.setHorizontalAlignment(4);
        this.text.addActionListener(this);
        this.add((Component)this.text, "Center");
        this.format = NumberFormat.getInstance();
        this.format.setMaximumFractionDigits(2);
        this.format.setGroupingUsed(false);
    }

    protected ImageIcon loadIcon(String iconName) {
        URL u = this.getClass().getResource(iconName);
        if (u != null) {
            return new ImageIcon(u);
        }
        return null;
    }

    public UiControlText(int digits, boolean incrementVisible, boolean unitVisible) {
        this(digits);
        if (incrementVisible) {
            JPanel editPanel = new JPanel();
            editPanel.setLayout(new GridLayout(1, 2));
            JPanel incrDecrPanel = new JPanel();
            incrDecrPanel.setLayout(new GridLayout(2, 1));
            this.increment = new JButton(this.loadIcon("incr.gif"));
            this.decrement = new JButton(this.loadIcon("decr.gif"));
            this.increment.setPreferredSize(new Dimension(12, 11));
            this.decrement.setPreferredSize(new Dimension(12, 11));
            this.increment.setFocusable(false);
            this.decrement.setFocusable(false);
            incrDecrPanel.add(this.increment);
            incrDecrPanel.add(this.decrement);
            this.mouseTracker = new UiMouseTracker();
            editPanel.add(incrDecrPanel);
            editPanel.add(this.mouseTracker);
            this.add((Component)editPanel, "East");
            this.mouseTracker.addMouseTrackListener(this);
            this.increment.addActionListener(this);
            this.decrement.addActionListener(this);
            this.text.addKeyListener(this);
        }
        if (unitVisible) {
            this.unit = new JButton();
            this.unit.setMargin(new Insets(2, 2, 2, 2));
            this.unit.setFocusable(false);
            this.add((Component)this.unit, "West");
            this.unit.addActionListener(this);
            this.unitName = new ArrayList();
            this.unitIndex = 0;
            this.fillUnits();
        }
    }

    public void addUnit(String name) {
        if (this.unitName != null) {
            this.unitName.add(name);
            this.unit.setText((String)this.unitName.get(0));
        }
    }

    private void rotateUnit() {
        if (this.unitName.size() > 0) {
            if (++this.unitIndex >= this.unitName.size()) {
                this.unitIndex = 0;
            }
            this.unit.setText((String)this.unitName.get(this.unitIndex));
        }
    }

    public void setUnit(String name) {
        int i;
        if (this.unitName != null && (i = this.unitName.indexOf(name)) >= 0) {
            this.unitIndex = i;
            this.unit.setText((String)this.unitName.get(this.unitIndex));
            this.refresh();
        }
    }

    public int getUnitIndex() {
        return this.unitIndex;
    }

    protected void fillUnits() {
    }

    private double safeDataToUnit(double d) {
        try {
            return this.dataToUnit(d);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    protected double dataToUnit(double d) {
        return d;
    }

    private double safeUnitToData(double u) {
        try {
            return this.unitToData(u);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    protected double unitToData(double u) {
        return u;
    }

    public void refresh() {
        this.text.setText(this.format.format(this.safeDataToUnit(this.dataIst)));
    }

    public void setData(double d) {
        super.setData(d);
        this.refresh();
    }

    public NumberFormat getFormat() {
        return this.format;
    }

    public void setNumberFormat(int f) {
        switch (f) {
            case 1: {
                this.format.setMaximumFractionDigits(3);
                break;
            }
            case 2: {
                this.format.setMaximumFractionDigits(0);
            }
        }
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.text.setEnabled(b);
        if (this.increment != null) {
            this.increment.setEnabled(b);
        }
        if (this.decrement != null) {
            this.decrement.setEnabled(b);
        }
        if (this.mouseTracker != null) {
            this.mouseTracker.setEnabled(b);
        }
        if (this.unit != null) {
            this.unit.setEnabled(b);
        }
    }

    public void setEditable(boolean b) {
        this.editable = b;
        this.text.setEditable(b);
        if (this.increment != null) {
            this.increment.setEnabled(b);
        }
        if (this.decrement != null) {
            this.decrement.setEnabled(b);
        }
        if (this.mouseTracker != null) {
            this.mouseTracker.setEnabled(b);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.text != null) {
            this.text.setBackground(c);
        }
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        if (this.text != null) {
            this.text.setForeground(c);
        }
    }

    public void actionPerformed(ActionEvent e) {
        double d = 0.0;
        try {
            d = Double.parseDouble(this.text.getText());
            if (e.getSource() == this.text) {
                this.doDataChanged(this.safeUnitToData(d));
            } else if (e.getSource() == this.increment) {
                this.doDataChanged(this.safeUnitToData(d + 1.0));
            } else if (e.getSource() == this.decrement) {
                this.doDataChanged(this.safeUnitToData(d - 1.0));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (e.getSource() == this.unit) {
            this.rotateUnit();
        }
        this.refresh();
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        try {
            double d = Double.parseDouble(this.text.getText());
            switch (e.getKeyCode()) {
                case 38: {
                    this.doDataChanged(this.safeUnitToData(d + 1.0));
                    this.refresh();
                    break;
                }
                case 40: {
                    this.doDataChanged(this.safeUnitToData(d - 1.0));
                    this.refresh();
                    break;
                }
                case 33: {
                    this.doDataChanged(this.safeUnitToData(d + 100.0));
                    this.refresh();
                    break;
                }
                case 34: {
                    this.doDataChanged(this.safeUnitToData(d - 100.0));
                    this.refresh();
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void onMoving(UiMouseTrackEvent e) {
        double d = 0.0;
        try {
            d = Double.parseDouble(this.text.getText());
            if (e.getSource() == this.mouseTracker) {
                float s = (float)Math.pow(1.0005, this.mouseTracker.getSpeed());
                if (this.mouseTracker.isClockWise()) {
                    this.doDataChanged(this.safeUnitToData(d * (double)s));
                }
                if (this.mouseTracker.isCounterClockWise()) {
                    this.doDataChanged(this.safeUnitToData(d / (double)s));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.refresh();
    }

    public void onRelease(UiMouseTrackEvent e) {
    }

    public static void main(String[] arg) {
        JFrame f = new JFrame();
        JPanel p = new JPanel();
        UiControlText c = new UiControlText(7, true, true);
        c.setEnabled(true);
        c.setDataRange(-1500.0, 5000.0);
        p.add(c);
        f.getContentPane().add(p);
        f.setSize(new Dimension(100, 100));
        f.setVisible(true);
    }
}

