/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.graph;

import ch.oli4.ui.UiPoint;
import ch.oli4.ui.graph.UiPlot1D;
import ch.oli4.ui.graph.UiPlotDefaultModel;
import ch.oli4.ui.graph.UiPlotModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class UiPlot1DCake
extends UiPlot1D {
    protected boolean prozentVisible = true;
    private UiPoint cakeCenter = new UiPoint();
    private int cakeRadius;

    public void setProzentVisible(boolean b) {
        this.prozentVisible = b;
        this.repaintPlot();
    }

    public boolean getProzentVisible() {
        return this.prozentVisible;
    }

    private int polarToX(int radius, double angle) {
        return (int)(Math.cos(angle * Math.PI / 180.0) * (double)radius);
    }

    private int polarToY(int radius, double angle) {
        return (int)(-Math.sin(angle * Math.PI / 180.0) * (double)radius);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        UiPlotModel m = this.getModel(0);
        double[] angle = new double[this.pScaleMax - this.pScaleMin + 1];
        int i = 0;
        while (i < angle.length) {
            angle[i] = 360.0 * Math.abs(m.getData(i + this.pScaleMin)[0]) / this.xScaleMax;
            if (i > 0) {
                int n = i;
                angle[n] = angle[n] + angle[i - 1];
            }
            ++i;
        }
        this.cakeCenter.x = this.getWidth() / 2;
        this.cakeCenter.y = this.getHeight() / 2;
        this.cakeRadius = this.getWidth() < this.getHeight() ? this.getWidth() * 4 / 10 : this.getHeight() * 4 / 10;
        i = this.pScaleMax - this.pScaleMin;
        while (i >= 0) {
            g.setColor(m.getDataColor(i + this.pScaleMin));
            g.fillArc(this.cakeCenter.x - this.cakeRadius, this.cakeCenter.y - this.cakeRadius, this.cakeRadius * 2, this.cakeRadius * 2, 0, (int)angle[i]);
            g.setColor(this.pLabelColor);
            g.drawLine(this.cakeCenter.x, this.cakeCenter.y, this.cakeCenter.x + this.polarToX(this.cakeRadius, angle[i]), this.cakeCenter.y + this.polarToY(this.cakeRadius, angle[i]));
            --i;
        }
        g.setColor(this.pLabelColor);
        g.drawLine(this.cakeCenter.x, this.cakeCenter.y, this.cakeCenter.x + this.polarToX(this.cakeRadius, 0.0), this.cakeCenter.y + this.polarToY(this.cakeRadius, 0.0));
        g.setColor(this.pLabelColor);
        g.drawOval(this.cakeCenter.x - this.cakeRadius, this.cakeCenter.y - this.cakeRadius, this.cakeRadius * 2, this.cakeRadius * 2);
        i = 0;
        while (i <= this.pScaleMax - this.pScaleMin) {
            double labelAngle = i > 0 ? (angle[i] + angle[i - 1]) / 2.0 : angle[i] / 2.0;
            if (this.dataVisible) {
                g.setColor(this.pAxisColor);
                g.drawString(new Double(m.getData(i + this.pScaleMin)[0]).toString(), this.cakeCenter.x + this.polarToX(this.cakeRadius * 10 / 9, labelAngle) - 13, this.cakeCenter.y + this.polarToY(this.cakeRadius * 10 / 9, labelAngle) + 3);
            }
            if (this.prozentVisible) {
                g.setColor(this.pAxisColor);
                g.drawString(String.valueOf(new Double((double)((int)(m.getData(i + this.pScaleMin)[0] * 1000.0 / this.xScaleMax)) / 10.0).toString()) + "%", this.cakeCenter.x + this.polarToX(this.cakeRadius * 2 / 3, labelAngle) - 13, this.cakeCenter.y + this.polarToY(this.cakeRadius * 2 / 3, labelAngle) + 3);
            }
            if (this.dataLabelVisible && m.getDataLabel(i + this.pScaleMin) != null) {
                g.setColor(this.dataLabelColor);
                g.drawString(m.getDataLabel(i + this.pScaleMin), this.cakeCenter.x + this.polarToX(this.cakeRadius * 9 / 8, labelAngle) - 12, this.cakeCenter.y + this.polarToY(this.cakeRadius * 9 / 8, labelAngle) + 3);
            }
            ++i;
        }
        if (this.xLabelVisible) {
            g.drawString(m.getLabel(0), this.cakeCenter.x / 10 + 3, this.cakeCenter.y / 10 + 13);
        }
    }

    public static void main(String[] arg) {
        JFrame f = new JFrame();
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        UiPlot1DCake c = new UiPlot1DCake();
        UiPlotDefaultModel m1 = new UiPlotDefaultModel(c);
        c.addModel(m1);
        m1.appendData(3.0);
        m1.appendData(2.0);
        m1.appendData(1.0);
        m1.appendData(0.2);
        m1.appendData(0.2);
        m1.appendData(1.0);
        m1.appendData(2.0);
        m1.setDataLabel("hi!", 2);
        m1.setDataColor(Color.orange, 2);
        c.setPScale(0, 6);
        c.setXScale(0.0, m1.getDataSumm(0, 0, 6));
        c.setDataLabelVisible(true);
        c.setDataVisible(false);
        c.setPLabelVisible(true);
        c.setXLabelVisible(true);
        c.setProzentVisible(true);
        c.setPLabelColor(Color.black);
        m1.setLabel("time", 3);
        m1.setLabel("load", 0);
        m1.setDefaultDataColor(Color.blue);
        p.add((Component)c, "Center");
        f.getContentPane().add(p);
        f.setSize(new Dimension(300, 200));
        f.setVisible(true);
    }
}

