/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.graph;

import ch.oli4.ui.UiFifo;
import ch.oli4.ui.graph.UiPlot;
import ch.oli4.ui.graph.UiPlotEvent;
import ch.oli4.ui.graph.UiPlotListener;
import ch.oli4.ui.graph.UiPlotModel;
import java.awt.Color;
import java.util.Vector;

public class UiPlotDefaultModel
implements UiPlotModel {
    protected UiFifo fifo;
    protected static final int dimensionMax = 3;
    protected String[] label;
    protected Color defaultDataColor;
    protected Color[] dataColor;
    protected Vector listenerList;
    protected UiPlot source;

    public UiPlotDefaultModel(UiPlot source, int pLength) {
        this.initData(pLength);
        this.initLabels();
        this.initDataLabels(pLength);
        this.initDataColors(pLength);
        this.initEvents(source);
    }

    public UiPlotDefaultModel(UiPlot source) {
        this(source, 50);
    }

    protected void initData(int maxSize) {
        this.fifo = new UiFifo(maxSize);
    }

    public void setData(double[] data, int p) {
        DataPoint d = new DataPoint();
        d.data = data;
        this.fifo.replace(d, p);
        this.processPlotDataChangeEvent(p, p);
    }

    public double[] getData(int p) {
        DataPoint d = (DataPoint)this.fifo.pick(p);
        if (d != null) {
            return d.data;
        }
        return (UiPlotDefaultModel)this.new DataPoint().data;
    }

    public void appendData(double[] data) {
        DataPoint d = new DataPoint();
        d.data = data;
        this.fifo.put(d);
        this.processPlotDataChangeEvent((int)this.getPMin(), (int)this.getPMax());
    }

    public void appendData(double x) {
        DataPoint d = new DataPoint();
        d.data[0] = x;
        this.fifo.put(d);
        this.processPlotDataChangeEvent((int)this.getPMin(), (int)this.getPMax());
    }

    public void appendData(double x, double y) {
        DataPoint d = new DataPoint();
        d.data[0] = x;
        d.data[1] = y;
        this.fifo.put(d);
        this.processPlotDataChangeEvent((int)this.getPMin(), (int)this.getPMax());
    }

    public void appendData(double x, double y, double z) {
        DataPoint d = new DataPoint();
        d.data[0] = x;
        d.data[1] = y;
        d.data[2] = z;
        this.fifo.put(d);
        this.processPlotDataChangeEvent((int)this.getPMin(), (int)this.getPMax());
    }

    public void clearData() {
        this.fifo.clear();
        this.processPlotDataChangeEvent((int)this.getPMin(), (int)this.getPMax());
    }

    public double getPMin() {
        return 0.0;
    }

    public double getPMax() {
        return this.fifo.getActualSize();
    }

    public double getDataMin(int dimension, int pLow, int pHigh) {
        double min = Double.MAX_VALUE;
        int i = pLow;
        while (i < pHigh + 1) {
            DataPoint d = (DataPoint)this.fifo.pick(i);
            if (d != null && d.data[dimension] < min) {
                min = d.data[dimension];
            }
            ++i;
        }
        return min;
    }

    public double getDataMax(int dimension, int pLow, int pHigh) {
        double max = Double.MIN_VALUE;
        int i = pLow;
        while (i < pHigh + 1) {
            DataPoint d = (DataPoint)this.fifo.pick(i);
            if (d != null && d.data[dimension] > max) {
                max = d.data[dimension];
            }
            ++i;
        }
        return max;
    }

    public double getDataSumm(int dimension, int pLow, int pHigh) {
        double summ = 0.0;
        int i = pLow;
        while (i <= pHigh) {
            DataPoint d = (DataPoint)this.fifo.pick(i);
            if (d != null) {
                summ += d.data[dimension];
            }
            ++i;
        }
        return summ;
    }

    public double getDataMean(int dimension, int pLow, int pHigh) {
        double mean = 0.0;
        int divisor = 0;
        int i = pLow;
        while (i <= pHigh) {
            DataPoint d = (DataPoint)this.fifo.pick(i);
            if (d != null) {
                mean += d.data[dimension];
                ++divisor;
            }
            ++i;
        }
        return mean / (double)divisor;
    }

    protected void initLabels() {
        this.label = new String[4];
        int i = 0;
        while (i < 4) {
            this.label[i] = new String();
            ++i;
        }
    }

    public void setLabel(String label, int dimension) {
        this.label[dimension] = label;
        this.processPlotDataChangeEvent((int)this.getPMin(), (int)this.getPMax());
    }

    public String getLabel(int dimension) {
        return this.label[dimension];
    }

    protected void initDataLabels(int pLength) {
    }

    public void setDataLabel(String label, int p) {
        ((DataPoint)this.fifo.pick((int)p)).label = label;
        this.processPlotDataChangeEvent(p, p);
    }

    public String getDataLabel(int p) {
        DataPoint d = (DataPoint)this.fifo.pick(p);
        if (d != null) {
            return d.label;
        }
        return "";
    }

    protected void initDataColors(int pLength) {
        this.defaultDataColor = Color.red;
    }

    public void setDataColor(Color c, int p) {
        ((DataPoint)this.fifo.pick((int)p)).color = c;
        this.processPlotDataChangeEvent(p, p);
    }

    public Color getDataColor(int p) {
        DataPoint d = (DataPoint)this.fifo.pick(p);
        if (d != null) {
            if (d.color != null) {
                return d.color;
            }
            return this.defaultDataColor;
        }
        return this.defaultDataColor;
    }

    public void setDefaultDataColor(Color c) {
        this.defaultDataColor = c;
        this.processPlotDataChangeEvent((int)this.getPMin(), (int)this.getPMax());
    }

    public Color getDefaultDataColor() {
        return this.defaultDataColor;
    }

    protected void initEvents(UiPlot source) {
        this.source = source;
        this.listenerList = new Vector();
    }

    public void addPlotListener(UiPlotListener l) {
        this.listenerList.add(l);
    }

    public void removePlotListener(UiPlotListener l) {
        this.listenerList.remove(l);
    }

    protected void processPlotDataChangeEvent(int pLow, int pHigh) {
        Object[] pl = this.listenerList.toArray();
        UiPlotEvent pe = new UiPlotEvent(this.source, pLow, pHigh);
        int i = 0;
        while (i < pl.length) {
            ((UiPlotListener)pl[i]).onPlotDataChange(pe);
            ++i;
        }
    }

    protected class DataPoint {
        public double[] data = new double[3];
        public String label = "";
        public Color color;
    }
}

