/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.signal;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.Timer;

public abstract class UiSignal
extends JPanel {
    private Timer transitionTimer;
    private int transitionSampleTime;
    private static final int transitionSampleSteps = 4;
    protected double dataMin;
    protected double dataMax;
    protected double dataIst;
    protected double dataSoll;
    private double dataVariation;
    protected String dataName;

    public UiSignal() {
        this.setMinimumSize(new Dimension(10, 10));
        this.setTransitionTime(100);
        this.dataMin = 0.0;
        this.dataMax = 100.0;
        this.dataIst = 0.0;
        this.updateDataVariation();
        this.dataName = "";
    }

    public void setTransitionTime(int t) {
        this.transitionSampleTime = t / 4;
        this.transitionTimer = new Timer(this.transitionSampleTime, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (UiSignal.this.sampleData()) {
                    UiSignal.this.transitionTimer.stop();
                }
                UiSignal.this.repaint();
            }
        });
        this.transitionTimer.setRepeats(true);
        this.transitionTimer.setCoalesce(true);
    }

    public void setData(double d) {
        this.dataSoll = d;
        if (this.transitionSampleTime != 0) {
            this.transitionTimer.start();
        } else {
            this.dataIst = this.dataSoll;
            this.repaint();
        }
    }

    public double getData() {
        return this.dataSoll;
    }

    public void setDataRange(double dMin, double dMax) {
        this.dataMin = dMin;
        this.dataMax = dMax;
        this.updateDataVariation();
    }

    private void updateDataVariation() {
        this.dataVariation = (this.dataMax - this.dataMin) / 4.0;
    }

    private boolean sampleData() {
        if (this.dataIst < this.dataSoll) {
            if (this.dataIst + this.dataVariation < this.dataSoll) {
                this.dataIst += this.dataVariation;
                return false;
            }
            this.dataIst = this.dataSoll;
            return true;
        }
        if (this.dataIst - this.dataVariation > this.dataSoll) {
            this.dataIst -= this.dataVariation;
            return false;
        }
        this.dataIst = this.dataSoll;
        return true;
    }

    public void setDataName(String n) {
        this.dataName = n;
    }

    public String getDataName() {
        return this.dataName;
    }
}

