/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.signal;

import ch.oli4.ui.UiPoint;
import ch.oli4.ui.signal.UiSignalZeiger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class UiSignalZeigerClassic
extends UiSignalZeiger {
    private UiPoint zeigerCenter;
    private int outerRadius;
    private int minorTickRadius;
    private int majorTickRadius;
    private int zeigerRadius;
    private int centerRadius;

    public UiSignalZeigerClassic() {
        this.zeigerColor = Color.red;
        this.skalaColor = Color.black;
        this.majorTickSpacing = 10.0;
        this.minorTickSpacing = 5.0;
        this.paintTicks = true;
        this.zeigerCenter = new UiPoint();
        this.setSkalaAngle(90);
        this.setPreferredSize(new Dimension(100, 50));
    }

    private void calculateRadius() {
        float radius2;
        float radius1 = (float)this.getWidth() / this.getRelativeSkalaWidth();
        this.outerRadius = radius1 < (radius2 = (float)this.getHeight() / this.getRelativeSkalaHeight()) ? (int)radius1 : (int)radius2;
        this.majorTickRadius = this.outerRadius - 10;
        this.minorTickRadius = this.majorTickRadius - 3;
        this.zeigerRadius = this.minorTickRadius - 5;
        this.centerRadius = this.zeigerRadius / 15;
        if (this.centerRadius < 5) {
            this.centerRadius = 5;
        }
    }

    private void calculateZeigerCenter() {
        this.zeigerCenter.x = this.getWidth() / 2;
        this.zeigerCenter.y = this.outerRadius - 2;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.calculateRadius();
        this.calculateZeigerCenter();
        if (this.paintTicks) {
            float w;
            Color rangeColor;
            double i = this.dataMin;
            while (i <= this.dataMax) {
                rangeColor = this.getColorAt(i);
                if (rangeColor != null) {
                    g.setColor(rangeColor);
                } else {
                    g.setColor(this.skalaColor);
                }
                w = this.dataToWinkel(i);
                g.drawLine(this.zeigerCenter.x, this.zeigerCenter.y, this.zeigerCenter.x + this.toX(w, this.minorTickRadius), this.zeigerCenter.y + this.toY(w, this.minorTickRadius));
                i += this.minorTickSpacing;
            }
            i = this.dataMin;
            while (i <= this.dataMax) {
                rangeColor = this.getColorAt(i);
                if (rangeColor != null) {
                    g.setColor(rangeColor);
                } else {
                    g.setColor(this.skalaColor);
                }
                w = this.dataToWinkel(i);
                g.drawLine(this.zeigerCenter.x, this.zeigerCenter.y, this.zeigerCenter.x + this.toX(w, this.majorTickRadius), this.zeigerCenter.y + this.toY(w, this.majorTickRadius));
                i += this.majorTickSpacing;
            }
            g.setColor(this.getBackground());
            g.fillOval(this.zeigerCenter.x - this.zeigerRadius, this.zeigerCenter.y - this.zeigerRadius, 2 * this.zeigerRadius, 2 * this.zeigerRadius);
        }
        g.setColor(this.skalaColor);
        g.drawArc(this.zeigerCenter.x - this.centerRadius, this.zeigerCenter.y - this.centerRadius, 2 * this.centerRadius, 2 * this.centerRadius, 270 - this.minAngle, -this.skalaAngle);
        g.setColor(this.zeigerColor);
        g.fillOval(this.zeigerCenter.x - (this.centerRadius - 2), this.zeigerCenter.y - (this.centerRadius - 2), 2 * (this.centerRadius - 2), 2 * (this.centerRadius - 2));
        if (this.nameVisible) {
            g.setColor(this.getForeground());
            g.drawString(this.dataName, this.zeigerCenter.x - this.getFontMetrics(this.getFont()).stringWidth(this.dataName) / 2, this.zeigerCenter.y * 2 / 3);
        }
        if (this.zeigerVisible) {
            g.setColor(this.zeigerColor);
            g.drawLine(this.zeigerCenter.x, this.zeigerCenter.y, this.zeigerCenter.x + this.toX(this.dataToWinkel(this.dataIst), this.zeigerRadius), this.zeigerCenter.y + this.toY(this.dataToWinkel(this.dataIst), this.zeigerRadius));
        }
    }

    public static void main(String[] arg) {
        JFrame f = new JFrame();
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        UiSignalZeigerClassic z = new UiSignalZeigerClassic();
        z.setDataRange(0.0, 1.5);
        z.setData(0.77);
        z.setMajorTickSpacing(0.5);
        z.setMinorTickSpacing(0.1);
        z.setPaintTicks(true);
        p.add((Component)z, "Center");
        f.getContentPane().add(p);
        f.setSize(new Dimension(100, 100));
        f.setVisible(true);
    }
}

