/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.mixer.dsp;

import de.quippy.javamod.system.FastMath;

public class FFT2 {
    public static final int FORWARD = -1;
    public static final int REVERSE = 1;
    private int frameSize = 0;
    private int bits = 0;
    private int[] flip = null;

    public FFT2(int n) {
        this.frameSize = n;
        this.bits = (int)(Math.log(n) / Math.log(2.0));
        this.createBitFlipArray();
    }

    private void createBitFlipArray() {
        this.flip = new int[this.frameSize];
        int n = 1;
        while (n < this.frameSize - 1) {
            int n2 = 0;
            int n3 = 1;
            while (n3 < this.frameSize) {
                if ((n & n3) != 0) {
                    ++n2;
                }
                n2 <<= 1;
                n3 <<= 1;
            }
            this.flip[n] = n2 / 2;
            ++n;
        }
    }

    public void smsFft(float[] fArray, int n) {
        float f;
        int n2;
        int n3;
        if (n != -1 && n != 1) {
            throw new IllegalArgumentException("invalid sign: " + n);
        }
        int n4 = 1;
        while (n4 < this.frameSize - 1) {
            n3 = this.flip[n4];
            if (n4 < n3) {
                n2 = n4 << 1;
                int n5 = n3 << 1;
                f = fArray[n2];
                fArray[n2] = fArray[n5];
                fArray[n5] = f;
                f = fArray[++n2];
                fArray[n2] = fArray[++n5];
                fArray[n5] = f;
            }
            ++n4;
        }
        n4 = 0;
        n3 = 2;
        while (n4 < this.bits) {
            n2 = (n3 <<= 1) >> 1;
            float f2 = 1.0f;
            f = 0.0f;
            float f3 = (float)Math.PI / (float)(n2 >> 1);
            float f4 = (float)FastMath.fastCos(f3);
            float f5 = (float)n * (float)FastMath.fastSin(f3);
            int n6 = 0;
            int n7 = 0;
            while (n7 < n2) {
                int n8 = n7;
                int n9 = n8 + 1;
                int n10 = n8 + n2;
                int n11 = n10 + 1;
                int n12 = n7;
                while (n12 < this.frameSize << 1) {
                    float f6 = fArray[n10] * f2 - fArray[n11] * f;
                    float f7 = fArray[n10] * f + fArray[n11] * f2;
                    ++n6;
                    fArray[n10] = fArray[n8] - f6;
                    fArray[n11] = fArray[n9] - f7;
                    int n13 = n8;
                    fArray[n13] = fArray[n13] + f6;
                    int n14 = n9;
                    fArray[n14] = fArray[n14] + f7;
                    n8 += n3;
                    n9 += n3;
                    n10 += n3;
                    n11 += n3;
                    n12 += n3;
                }
                float f8 = f2 * f4 - f * f5;
                f = f2 * f5 + f * f4;
                f2 = f8;
                n7 += 2;
            }
            ++n4;
        }
    }
}

