/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mp3.id3;

import de.quippy.javamod.io.RandomAccessInputStream;
import de.quippy.javamod.multimedia.mp3.id3.exceptions.ID3v2FormatException;
import de.quippy.javamod.system.Helpers;
import java.io.IOException;

public class ID3v2ExtendedHeader {
    private static final int EXT_HEAD_LOCATION = 10;
    private static final int MIN_SIZE = 6;
    private static final int CRC_SIZE = 5;
    private static final int[] MAX_TAG_FRAMES_TABLE = new int[]{128, 64, 32, 32};
    private static final int[] MAX_TAG_SIZE_TABLE = new int[]{8000000, 1024000, 320000, 32000};
    private static final int[] MAX_TEXT_SIZE_TABLE = new int[]{-1, 1024, 128, 30};
    private int size = 0;
    private int numFlagBytes = 0;
    private boolean update = false;
    private boolean crced = false;
    private byte[] crc = new byte[5];
    private int maxTagSize = -1;
    private boolean textEncode = false;
    private int maxTextSize = -1;
    private boolean imageEncode = false;
    private int imageRestrict = -1;

    public ID3v2ExtendedHeader(RandomAccessInputStream randomAccessInputStream) throws IOException, ID3v2FormatException {
        this.readExtendedHeader(randomAccessInputStream);
    }

    private void readExtendedHeader(RandomAccessInputStream randomAccessInputStream) throws IOException, ID3v2FormatException {
        randomAccessInputStream.seek(10L);
        byte[] byArray = new byte[4];
        if (randomAccessInputStream.read(byArray) != byArray.length) {
            throw new IOException("Error reading extended header:size");
        }
        this.size = Helpers.convertDWordToInt(byArray, 0);
        if (this.size < 6) {
            throw new ID3v2FormatException("The extended header size data is less than the minimum required size (" + this.size + '<' + 6 + ").");
        }
        this.numFlagBytes = randomAccessInputStream.read();
        byArray = new byte[this.numFlagBytes + 1];
        if (randomAccessInputStream.read(byArray) != byArray.length) {
            throw new IOException("Error reading extended header:flags");
        }
        this.parseFlags(byArray);
    }

    private void parseFlags(byte[] byArray) throws ID3v2FormatException {
        int n;
        int n2 = 1;
        boolean bl = this.update = (byArray[0] & 0x80) != 0;
        if (this.update) {
            ++n2;
        }
        boolean bl2 = this.crced = (byArray[0] & 0x40) != 0;
        if (this.crced) {
            ++n2;
            n = 0;
            while (n < this.crc.length) {
                this.crc[n] = byArray[n2++];
                ++n;
            }
        }
        if ((byArray[0] & 0x80) != 0) {
            n = byArray[++n2];
            this.maxTagSize = (n & 0xC0) >> 6;
            this.textEncode = (n & 0x20) != 0;
            this.maxTextSize = (n & 0x18) >> 3;
            this.imageEncode = (n & 4) != 0;
            this.imageRestrict = n & 3;
            ++n2;
        }
        if (n2 != this.numFlagBytes) {
            throw new ID3v2FormatException("The number of found flag bytes in the extended header is not equal to the number specified in the extended header.");
        }
    }

    private byte[] getFlagBytes() {
        byte[] byArray = new byte[this.numFlagBytes];
        int n = 1;
        byArray[0] = 0;
        if (this.update) {
            byArray[0] = (byte)(byArray[0] | 0x80);
            byArray[n++] = 0;
        }
        if (this.crced) {
            byArray[0] = (byte)(byArray[0] | 0x40);
            byArray[n++] = (byte)this.crc.length;
            System.arraycopy(this.crc, 0, byArray, n, this.crc.length);
            n += this.crc.length;
        }
        if (this.maxTagSize != -1 || this.textEncode || this.maxTextSize != -1 || this.imageEncode || this.imageRestrict != -1) {
            byArray[0] = (byte)(byArray[0] | 0x20);
            byArray[n++] = 1;
            int n2 = 0;
            if (this.maxTagSize != -1) {
                n2 = (byte)(n2 | (byte)((this.maxTagSize & 3) << 6));
            }
            if (this.textEncode) {
                n2 = (byte)(n2 | 0x20);
            }
            if (this.maxTextSize != -1) {
                n2 = (byte)(n2 | (byte)((this.maxTextSize & 3) << 3));
            }
            if (this.imageEncode) {
                n2 = (byte)(n2 | 4);
            }
            if (this.imageRestrict != -1) {
                n2 = (byte)(n2 | (byte)(this.imageRestrict & 3));
            }
            byArray[n++] = n2;
        }
        return byArray;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.size];
        int n = 0;
        System.arraycopy(Helpers.convertIntToDWord(this.size), 0, byArray, n, 4);
        n += 4;
        byArray[n++] = (byte)this.numFlagBytes;
        System.arraycopy(this.getFlagBytes(), 0, byArray, n, this.numFlagBytes);
        n += this.numFlagBytes;
        return byArray;
    }

    public int getSize() {
        return this.size;
    }

    public int getNumFlagBytes() {
        return this.numFlagBytes;
    }

    public int getMaxFrames() {
        int n = -1;
        if (this.maxTagSize >= 0 && this.maxTagSize < MAX_TAG_FRAMES_TABLE.length) {
            n = MAX_TAG_FRAMES_TABLE[this.maxTagSize];
        }
        return n;
    }

    public int getMaxTagSize() {
        int n = -1;
        if (this.maxTagSize >= 0 && this.maxTagSize < MAX_TAG_SIZE_TABLE.length) {
            n = MAX_TAG_SIZE_TABLE[this.maxTagSize];
        }
        return n;
    }

    public boolean getTextEncode() {
        return this.textEncode;
    }

    public int getMaxTextSize() {
        int n = -1;
        if (this.maxTextSize >= 0 && this.maxTextSize < MAX_TEXT_SIZE_TABLE.length) {
            n = MAX_TEXT_SIZE_TABLE[this.maxTextSize];
        }
        return n;
    }

    public boolean getImageEncode() {
        return this.imageEncode;
    }

    public int getImageRestriction() {
        return this.imageRestrict;
    }

    public boolean getUpdate() {
        return this.update;
    }

    public boolean getCRCed() {
        return this.crced;
    }

    public byte[] getCRC() {
        return this.crc;
    }

    public String toString() {
        return "ExtendedSize:\t\t\t" + this.getSize() + " bytes" + "\nNumFlagBytes:\t\t\t" + this.getNumFlagBytes() + "\nUpdated:\t\t\t" + this.getUpdate() + "\nCRC:\t\t\t\t" + this.getCRCed() + "\nMaxFrames:\t\t\t" + this.getMaxFrames() + "\nMaxTagSize:\t\t\t" + this.getMaxTagSize() + "\nTextEncoded:\t\t\t" + this.getTextEncode() + "\nMaxTextSize:\t\t\t" + this.getMaxTextSize() + "\nImageEncoded:\t\t\t" + this.getImageEncode() + "\nImageRestriction:\t\t" + this.getImageRestriction();
    }
}

