/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.decoder;

import de.quippy.jmac.decoder.IAPEDecompress;
import de.quippy.jmac.decoder.UnBitArray;
import de.quippy.jmac.decoder.UnBitArrayOld;
import de.quippy.jmac.decoder.UnBitArrayState;
import de.quippy.jmac.tools.ByteArrayReader;
import de.quippy.jmac.tools.File;
import de.quippy.jmac.tools.JMACException;
import java.io.IOException;

public class UnBitArrayBase {
    private static final long[] POWERS_OF_TWO_MINUS_ONE;
    protected long m_nElements;
    protected long m_nBytes;
    protected long m_nBits;
    protected int m_nVersion;
    protected File m_pIO;
    protected long m_nCurrentBitIndex;
    protected long[] m_pBitArray;
    protected ByteArrayReader m_pReader;

    static {
        long[] lArray = new long[33];
        lArray[1] = 1L;
        lArray[2] = 3L;
        lArray[3] = 7L;
        lArray[4] = 15L;
        lArray[5] = 31L;
        lArray[6] = 63L;
        lArray[7] = 127L;
        lArray[8] = 255L;
        lArray[9] = 511L;
        lArray[10] = 1023L;
        lArray[11] = 2047L;
        lArray[12] = 4095L;
        lArray[13] = 8191L;
        lArray[14] = 16383L;
        lArray[15] = 32767L;
        lArray[16] = 65535L;
        lArray[17] = 131071L;
        lArray[18] = 262143L;
        lArray[19] = 524287L;
        lArray[20] = 1048575L;
        lArray[21] = 0x1FFFFFL;
        lArray[22] = 0x3FFFFFL;
        lArray[23] = 0x7FFFFFL;
        lArray[24] = 0xFFFFFFL;
        lArray[25] = 0x1FFFFFFL;
        lArray[26] = 0x3FFFFFFL;
        lArray[27] = 0x7FFFFFFL;
        lArray[28] = 0xFFFFFFFL;
        lArray[29] = 0x1FFFFFFFL;
        lArray[30] = 0x3FFFFFFFL;
        lArray[31] = Integer.MAX_VALUE;
        lArray[32] = 0xFFFFFFFFL;
        POWERS_OF_TWO_MINUS_ONE = lArray;
    }

    public void FillBitArray() throws IOException {
        long l = this.m_nCurrentBitIndex >> 5;
        long[] lArray = this.m_pBitArray;
        int n = (int)l;
        System.arraycopy(this.m_pBitArray, n, lArray, 0, (int)((long)lArray.length - l));
        ByteArrayReader byteArrayReader = this.m_pReader;
        byteArrayReader.reset(this.m_pIO, n << 2);
        long l2 = this.m_nElements;
        int n2 = (int)(l2 - l);
        if ((long)n2 < l2) {
            do {
                lArray[n2] = byteArrayReader.readUnsignedInt();
            } while ((long)(++n2) < l2);
        }
        this.m_nCurrentBitIndex &= 0x1FL;
    }

    public void FillAndResetBitArray() throws IOException {
        this.FillAndResetBitArray(-1, 0);
    }

    public void FillAndResetBitArray(int n) throws IOException {
        this.FillAndResetBitArray(n, 0);
    }

    public void FillAndResetBitArray(int n, int n2) throws IOException {
        this.m_nCurrentBitIndex = n2;
        if (n != -1) {
            this.m_pIO.seek(n);
        }
        ByteArrayReader byteArrayReader = this.m_pReader;
        byteArrayReader.reset(this.m_pIO, (int)this.m_nBytes);
        long[] lArray = this.m_pBitArray;
        long l = this.m_nElements;
        int n3 = 0;
        while ((long)n3 < l) {
            lArray[n3] = byteArrayReader.readUnsignedInt();
            ++n3;
        }
    }

    public void GenerateArray(int[] nArray, int n) throws IOException {
        this.GenerateArray(nArray, n, -1);
    }

    public void GenerateArray(int[] nArray, int n, int n2) throws IOException {
    }

    public long DecodeValue(int n) throws IOException {
        return this.DecodeValue(n, 0, 0);
    }

    public long DecodeValue(int n, int n2) throws IOException {
        return this.DecodeValue(n, n2, 0);
    }

    public long DecodeValue(int n, int n2, int n3) throws IOException {
        return 0L;
    }

    public void AdvanceToByteBoundary() {
        long l = this.m_nCurrentBitIndex % 8L;
        if (l != 0L) {
            this.m_nCurrentBitIndex += 8L - l;
        }
    }

    public int DecodeValueRange(UnBitArrayState unBitArrayState) throws IOException {
        return 0;
    }

    public void FlushState(UnBitArrayState unBitArrayState) {
    }

    public void FlushBitArray() {
    }

    public void finalize_internally() {
    }

    protected void CreateHelper(File file, int n, int n2) {
        if (file == null || n <= 0) {
            throw new JMACException("Bad Parameter");
        }
        this.m_nElements = n / 4;
        this.m_nBytes = this.m_nElements * 4L;
        this.m_nBits = this.m_nBytes * 8L;
        this.m_pIO = file;
        this.m_nVersion = n2;
        this.m_nCurrentBitIndex = 0L;
        this.m_pBitArray = new long[(int)this.m_nElements];
        this.m_pReader = new ByteArrayReader((int)this.m_nBytes);
    }

    protected long DecodeValueXBits(long l) throws IOException {
        long l2 = this.m_nCurrentBitIndex;
        if (l2 + l >= this.m_nBits) {
            this.FillBitArray();
        }
        long l3 = 32L - (l2 & 0x1FL);
        l2 >>= 5;
        this.m_nCurrentBitIndex += l;
        if (l3 >= l) {
            return (this.m_pBitArray[(int)l2] & POWERS_OF_TWO_MINUS_ONE[(int)l3]) >> (int)(l3 - l);
        }
        long l4 = l - l3;
        long l5 = (this.m_pBitArray[(int)l2] & POWERS_OF_TWO_MINUS_ONE[(int)l3]) << (int)l4;
        long l6 = this.m_pBitArray[(int)l2 + 1] >> (int)(32L - l4);
        return l5 | l6;
    }

    public static UnBitArrayBase CreateUnBitArray(IAPEDecompress iAPEDecompress, int n) {
        if (n >= 3900) {
            return new UnBitArray(iAPEDecompress.getApeInfoIoSource(), n);
        }
        return new UnBitArrayOld(iAPEDecompress, n);
    }
}

