/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.info;

import de.quippy.jmac.tools.ByteArrayReader;
import de.quippy.jmac.tools.ByteArrayWriter;
import de.quippy.jmac.tools.File;
import de.quippy.jmac.tools.JMACException;
import java.io.EOFException;
import java.io.IOException;

public class APEHeaderNew {
    public int nCompressionLevel;
    public int nFormatFlags;
    public long nBlocksPerFrame;
    public long nFinalFrameBlocks;
    public long nTotalFrames;
    public int nBitsPerSample;
    public int nChannels;
    public long nSampleRate;
    public static final int APE_HEADER_BYTES = 24;

    public static APEHeaderNew read(File file) throws IOException {
        try {
            APEHeaderNew aPEHeaderNew = new APEHeaderNew();
            ByteArrayReader byteArrayReader = new ByteArrayReader(file, 24);
            aPEHeaderNew.nCompressionLevel = byteArrayReader.readUnsignedShort();
            aPEHeaderNew.nFormatFlags = byteArrayReader.readUnsignedShort();
            aPEHeaderNew.nBlocksPerFrame = byteArrayReader.readUnsignedInt();
            aPEHeaderNew.nFinalFrameBlocks = byteArrayReader.readUnsignedInt();
            aPEHeaderNew.nTotalFrames = byteArrayReader.readUnsignedInt();
            aPEHeaderNew.nBitsPerSample = byteArrayReader.readUnsignedShort();
            aPEHeaderNew.nChannels = byteArrayReader.readUnsignedShort();
            aPEHeaderNew.nSampleRate = byteArrayReader.readUnsignedInt();
            return aPEHeaderNew;
        }
        catch (EOFException eOFException) {
            throw new JMACException("Unsupported Format");
        }
    }

    public void write(ByteArrayWriter byteArrayWriter) {
        byteArrayWriter.writeUnsignedShort(this.nCompressionLevel);
        byteArrayWriter.writeUnsignedShort(this.nFormatFlags);
        byteArrayWriter.writeUnsignedInt(this.nBlocksPerFrame);
        byteArrayWriter.writeUnsignedInt(this.nFinalFrameBlocks);
        byteArrayWriter.writeUnsignedInt(this.nTotalFrames);
        byteArrayWriter.writeUnsignedShort(this.nBitsPerSample);
        byteArrayWriter.writeUnsignedShort(this.nChannels);
        byteArrayWriter.writeUnsignedInt(this.nSampleRate);
    }
}

