/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.libsidplay;

import de.quippy.sidplay.libsidplay.NullSID;
import de.quippy.sidplay.libsidplay.common.C64Env;
import de.quippy.sidplay.libsidplay.common.Event;
import de.quippy.sidplay.libsidplay.common.EventScheduler;
import de.quippy.sidplay.libsidplay.common.IEventContext;
import de.quippy.sidplay.libsidplay.common.ISID2Types;
import de.quippy.sidplay.libsidplay.common.SIDBuilder;
import de.quippy.sidplay.libsidplay.common.SIDEmu;
import de.quippy.sidplay.libsidplay.common.SIDEndian;
import de.quippy.sidplay.libsidplay.common.mos6510.C64Environment;
import de.quippy.sidplay.libsidplay.common.mos6510.MOS6510;
import de.quippy.sidplay.libsidplay.common.mos6510.SID6510;
import de.quippy.sidplay.libsidplay.components.mos6526.C64CIA;
import de.quippy.sidplay.libsidplay.components.mos6526.SID6526;
import de.quippy.sidplay.libsidplay.components.mos656x.C64VIC;
import de.quippy.sidplay.libsidplay.components.mos656x.MOS656X;
import de.quippy.sidplay.libsidplay.components.sidtune.SidTune;
import de.quippy.sidplay.libsidplay.components.sidtune.SidTuneInfo;
import de.quippy.sidplay.libsidplay.components.xsid.C64XSID;
import de.quippy.sidplay.libsidplay.mem.IBasic;
import de.quippy.sidplay.libsidplay.mem.IChar;
import de.quippy.sidplay.libsidplay.mem.IKernal;
import de.quippy.sidplay.libsidplay.mem.IPSIDDrv;
import de.quippy.sidplay.libsidplay.mem.IPowerOn;

public class Player
extends C64Env {
    private C64Environment envp;
    private static final double CLOCK_FREQ_NTSC = 1022727.14;
    private static final double CLOCK_FREQ_PAL = 985248.4;
    private static final double VIC_FREQ_PAL = 50.0;
    private static final double VIC_FREQ_NTSC = 60.0;
    private static final String TXT_PAL_VBI = "50 Hz VBI (PAL)";
    private static final String TXT_PAL_VBI_FIXED = "60 Hz VBI (PAL FIXED)";
    private static final String TXT_PAL_CIA = "CIA (PAL)";
    private static final String TXT_NTSC_VBI = "60 Hz VBI (NTSC)";
    private static final String TXT_NTSC_VBI_FIXED = "50 Hz VBI (NTSC FIXED)";
    private static final String TXT_NTSC_CIA = "CIA (NTSC)";
    private static final String TXT_NA = "NA";
    private static final String ERR_CONF_WHILST_ACTIVE = "SIDPLAYER ERROR: Trying to configure player whilst active.";
    private static final String ERR_UNSUPPORTED_FREQ = "SIDPLAYER ERROR: Unsupported sampling frequency.";
    private static final String ERR_UNSUPPORTED_PRECISION = "SIDPLAYER ERROR: Unsupported sample precision.";
    private static String[] credit = new String[10];
    private static final String ERR_PSIDDRV_NO_SPACE = "ERROR: No space to install psid driver in C64 ram";
    private static final String ERR_PSIDDRV_RELOC = "ERROR: Failed whilst relocating psid driver";
    private EventScheduler m_scheduler;
    private SID6510 sid6510;
    private MOS6510 mos6510;
    private MOS6510 cpu;
    private NullSID nullsid;
    private C64XSID xsid;
    private C64CIA.C64cia1 cia;
    private C64CIA.C64cia2 cia2;
    private SID6526 sid6526;
    private C64VIC vic;
    private SIDEmu[] sid = new SIDEmu[2];
    private int[] m_sidmapper = new int[32];
    private EventMixer mixerEvent;
    private EventRTC rtc;
    private SidTuneInfo m_tuneInfo = new SidTuneInfo();
    private SidTune m_tune;
    private short[] m_ram;
    private short[] m_rom;
    private ISID2Types.sid2_info_t m_info = new ISID2Types.sid2_info_t();
    private ISID2Types.sid2_config_t m_cfg = new ISID2Types.sid2_config_t();
    private String m_errorString;
    private double m_fastForwardFactor;
    private long m_mileage;
    private long m_leftVolume;
    private long m_rightVolume;
    private ISID2Types.sid2_player_t m_playerState;
    private boolean m_running;
    private int m_rand;
    private long m_sid2crc;
    private long m_sid2crcCount;
    private boolean m_emulateStereo;
    private long m_sampleClock;
    private long m_samplePeriod;
    private int m_sampleCount;
    private int m_sampleIndex;
    private short[] m_sampleBuffer;
    private Port m_port = new Port();
    private short m_playBank;
    private boolean isKernal;
    private boolean isBasic;
    private boolean isIO;
    private boolean isChar;
    private IMem m_mem;
    private IOutput output;
    private static final long[] crc32Table;
    static final int PSIDDRV_MAX_PAGE = 255;
    public static final long VOLUME_MAX = 255L;
    public static final int SID2_MAX_SIDS = 2;
    public static final int SID2_TIME_BASE = 10;
    public static final int SID2_MAPPER_SIZE = 32;
    public static final int BUF = 26;
    private file65 file = new file65();
    private char[] cmp;
    static final int EOF = -1;

    static {
        long[] lArray = new long[256];
        lArray[1] = 1996959894L;
        lArray[2] = -301047508L;
        lArray[3] = -1727442502L;
        lArray[4] = 124634137L;
        lArray[5] = 1886057615L;
        lArray[6] = -379345611L;
        lArray[7] = -1637575261L;
        lArray[8] = 249268274L;
        lArray[9] = 2044508324L;
        lArray[10] = -522852066L;
        lArray[11] = -1747789432L;
        lArray[12] = 162941995L;
        lArray[13] = 2125561021L;
        lArray[14] = -407360249L;
        lArray[15] = -1866523247L;
        lArray[16] = 498536548L;
        lArray[17] = 1789927666L;
        lArray[18] = -205950648L;
        lArray[19] = -2067906082L;
        lArray[20] = 450548861L;
        lArray[21] = 1843258603L;
        lArray[22] = -187386543L;
        lArray[23] = -2083289657L;
        lArray[24] = 325883990L;
        lArray[25] = 1684777152L;
        lArray[26] = -43845254L;
        lArray[27] = -1973040660L;
        lArray[28] = 335633487L;
        lArray[29] = 1661365465L;
        lArray[30] = -99664541L;
        lArray[31] = -1928851979L;
        lArray[32] = 997073096L;
        lArray[33] = 1281953886L;
        lArray[34] = -715111964L;
        lArray[35] = -1570279054L;
        lArray[36] = 1006888145L;
        lArray[37] = 1258607687L;
        lArray[38] = -770865667L;
        lArray[39] = -1526024853L;
        lArray[40] = 901097722L;
        lArray[41] = 1119000684L;
        lArray[42] = -608450090L;
        lArray[43] = -1396901568L;
        lArray[44] = 853044451L;
        lArray[45] = 1172266101L;
        lArray[46] = -589951537L;
        lArray[47] = -1412350631L;
        lArray[48] = 651767980L;
        lArray[49] = 1373503546L;
        lArray[50] = -925412992L;
        lArray[51] = -1076862698L;
        lArray[52] = 565507253L;
        lArray[53] = 1454621731L;
        lArray[54] = -809855591L;
        lArray[55] = -1195530993L;
        lArray[56] = 671266974L;
        lArray[57] = 1594198024L;
        lArray[58] = -972236366L;
        lArray[59] = -1324619484L;
        lArray[60] = 795835527L;
        lArray[61] = 1483230225L;
        lArray[62] = -1050600021L;
        lArray[63] = -1234817731L;
        lArray[64] = 1994146192L;
        lArray[65] = 31158534L;
        lArray[66] = -1731059524L;
        lArray[67] = -271249366L;
        lArray[68] = 1907459465L;
        lArray[69] = 112637215L;
        lArray[70] = -1614814043L;
        lArray[71] = -390540237L;
        lArray[72] = 2013776290L;
        lArray[73] = 251722036L;
        lArray[74] = -1777751922L;
        lArray[75] = -519137256L;
        lArray[76] = 2137656763L;
        lArray[77] = 141376813L;
        lArray[78] = -1855689577L;
        lArray[79] = -429695999L;
        lArray[80] = 1802195444L;
        lArray[81] = 476864866L;
        lArray[82] = -2056965928L;
        lArray[83] = -228458418L;
        lArray[84] = 1812370925L;
        lArray[85] = 453092731L;
        lArray[86] = -2113342271L;
        lArray[87] = -183516073L;
        lArray[88] = 1706088902L;
        lArray[89] = 314042704L;
        lArray[90] = -1950435094L;
        lArray[91] = -54949764L;
        lArray[92] = 1658658271L;
        lArray[93] = 366619977L;
        lArray[94] = -1932296973L;
        lArray[95] = -69972891L;
        lArray[96] = 1303535960L;
        lArray[97] = 984961486L;
        lArray[98] = -1547960204L;
        lArray[99] = -725929758L;
        lArray[100] = 1256170817L;
        lArray[101] = 1037604311L;
        lArray[102] = -1529756563L;
        lArray[103] = -740887301L;
        lArray[104] = 1131014506L;
        lArray[105] = 879679996L;
        lArray[106] = -1385723834L;
        lArray[107] = -631195440L;
        lArray[108] = 1141124467L;
        lArray[109] = 855842277L;
        lArray[110] = -1442165665L;
        lArray[111] = -586318647L;
        lArray[112] = 1342533948L;
        lArray[113] = 654459306L;
        lArray[114] = -1106571248L;
        lArray[115] = -921952122L;
        lArray[116] = 1466479909L;
        lArray[117] = 544179635L;
        lArray[118] = -1184443383L;
        lArray[119] = -832445281L;
        lArray[120] = 1591671054L;
        lArray[121] = 702138776L;
        lArray[122] = -1328506846L;
        lArray[123] = -942167884L;
        lArray[124] = 1504918807L;
        lArray[125] = 783551873L;
        lArray[126] = -1212326853L;
        lArray[127] = -1061524307L;
        lArray[128] = -306674912L;
        lArray[129] = -1698712650L;
        lArray[130] = 62317068L;
        lArray[131] = 1957810842L;
        lArray[132] = -355121351L;
        lArray[133] = -1647151185L;
        lArray[134] = 81470997L;
        lArray[135] = 1943803523L;
        lArray[136] = -480048366L;
        lArray[137] = -1805370492L;
        lArray[138] = 225274430L;
        lArray[139] = 2053790376L;
        lArray[140] = -468791541L;
        lArray[141] = -1828061283L;
        lArray[142] = 167816743L;
        lArray[143] = 2097651377L;
        lArray[144] = -267414716L;
        lArray[145] = -2029476910L;
        lArray[146] = 503444072L;
        lArray[147] = 1762050814L;
        lArray[148] = -144550051L;
        lArray[149] = -2140837941L;
        lArray[150] = 426522225L;
        lArray[151] = 1852507879L;
        lArray[152] = -19653770L;
        lArray[153] = -1982649376L;
        lArray[154] = 282753626L;
        lArray[155] = 1742555852L;
        lArray[156] = -105259153L;
        lArray[157] = -1900089351L;
        lArray[158] = 397917763L;
        lArray[159] = 1622183637L;
        lArray[160] = -690576408L;
        lArray[161] = -1580100738L;
        lArray[162] = 953729732L;
        lArray[163] = 1340076626L;
        lArray[164] = -776247311L;
        lArray[165] = -1497606297L;
        lArray[166] = 1068828381L;
        lArray[167] = 1219638859L;
        lArray[168] = -670225446L;
        lArray[169] = -1358292148L;
        lArray[170] = 906185462L;
        lArray[171] = 1090812512L;
        lArray[172] = -547295293L;
        lArray[173] = -1469587627L;
        lArray[174] = 829329135L;
        lArray[175] = 1181335161L;
        lArray[176] = -882789492L;
        lArray[177] = -1134132454L;
        lArray[178] = 628085408L;
        lArray[179] = 1382605366L;
        lArray[180] = -871598187L;
        lArray[181] = -1156888829L;
        lArray[182] = 570562233L;
        lArray[183] = 1426400815L;
        lArray[184] = -977650754L;
        lArray[185] = -1296233688L;
        lArray[186] = 733239954L;
        lArray[187] = 1555261956L;
        lArray[188] = -1026031705L;
        lArray[189] = -1244606671L;
        lArray[190] = 752459403L;
        lArray[191] = 1541320221L;
        lArray[192] = -1687895376L;
        lArray[193] = -328994266L;
        lArray[194] = 1969922972L;
        lArray[195] = 40735498L;
        lArray[196] = -1677130071L;
        lArray[197] = -351390145L;
        lArray[198] = 1913087877L;
        lArray[199] = 83908371L;
        lArray[200] = -1782625662L;
        lArray[201] = -491226604L;
        lArray[202] = 2075208622L;
        lArray[203] = 213261112L;
        lArray[204] = -1831694693L;
        lArray[205] = -438977011L;
        lArray[206] = 2094854071L;
        lArray[207] = 198958881L;
        lArray[208] = -2032938284L;
        lArray[209] = -237706686L;
        lArray[210] = 1759359992L;
        lArray[211] = 534414190L;
        lArray[212] = -2118248755L;
        lArray[213] = -155638181L;
        lArray[214] = 1873836001L;
        lArray[215] = 414664567L;
        lArray[216] = -2012718362L;
        lArray[217] = -15766928L;
        lArray[218] = 1711684554L;
        lArray[219] = 285281116L;
        lArray[220] = -1889165569L;
        lArray[221] = -127750551L;
        lArray[222] = 1634467795L;
        lArray[223] = 376229701L;
        lArray[224] = -1609899400L;
        lArray[225] = -686959890L;
        lArray[226] = 1308918612L;
        lArray[227] = 956543938L;
        lArray[228] = -1486412191L;
        lArray[229] = -799009033L;
        lArray[230] = 1231636301L;
        lArray[231] = 1047427035L;
        lArray[232] = -1362007478L;
        lArray[233] = -640263460L;
        lArray[234] = 1088359270L;
        lArray[235] = 936918000L;
        lArray[236] = -1447252397L;
        lArray[237] = -558129467L;
        lArray[238] = 1202900863L;
        lArray[239] = 817233897L;
        lArray[240] = -1111625188L;
        lArray[241] = -893730166L;
        lArray[242] = 1404277552L;
        lArray[243] = 615818150L;
        lArray[244] = -1160759803L;
        lArray[245] = -841546093L;
        lArray[246] = 1423857449L;
        lArray[247] = 601450431L;
        lArray[248] = -1285129682L;
        lArray[249] = -1000256840L;
        lArray[250] = 1567103746L;
        lArray[251] = 711928724L;
        lArray[252] = -1274298825L;
        lArray[253] = -1022587231L;
        lArray[254] = 1510334235L;
        lArray[255] = 755167117L;
        crc32Table = lArray;
    }

    private void evalBankSelect(short s) {
        this.m_port.pr_out = s;
        this.m_port.pr_in = (short)(s & this.m_port.ddr | ~this.m_port.ddr & (this.m_port.pr_in | 0x17) & 0xDF);
        s = (short)(s | ~this.m_port.ddr & 0xFF);
        this.isBasic = ((s = (short)(s & 7)) & 3) == 3;
        this.isIO = s > 4;
        this.isKernal = (s & 2) != 0;
        this.isChar = (s ^ 4) > 4;
    }

    private double clockSpeed(ISID2Types.sid2_clock_t sid2_clock_t2, ISID2Types.sid2_clock_t sid2_clock_t3, boolean bl) {
        double d = 985248.4;
        if (this.m_tuneInfo.clockSpeed == 0) {
            switch (sid2_clock_t3) {
                case SID2_CLOCK_PAL: {
                    this.m_tuneInfo.clockSpeed = 1;
                    break;
                }
                case SID2_CLOCK_NTSC: {
                    this.m_tuneInfo.clockSpeed = (short)2;
                    break;
                }
                case SID2_CLOCK_CORRECT: {
                    this.m_tuneInfo.clockSpeed = (short)3;
                }
            }
        }
        if (this.m_tuneInfo.clockSpeed == 3) {
            if (sid2_clock_t2 == ISID2Types.sid2_clock_t.SID2_CLOCK_CORRECT) {
                sid2_clock_t2 = sid2_clock_t3;
            }
            switch (sid2_clock_t2) {
                case SID2_CLOCK_NTSC: {
                    this.m_tuneInfo.clockSpeed = (short)2;
                    break;
                }
                default: {
                    this.m_tuneInfo.clockSpeed = 1;
                }
            }
        }
        if (sid2_clock_t2 == ISID2Types.sid2_clock_t.SID2_CLOCK_CORRECT) {
            switch (this.m_tuneInfo.clockSpeed) {
                case 2: {
                    sid2_clock_t2 = ISID2Types.sid2_clock_t.SID2_CLOCK_NTSC;
                    break;
                }
                case 1: {
                    sid2_clock_t2 = ISID2Types.sid2_clock_t.SID2_CLOCK_PAL;
                }
            }
        }
        if (bl) {
            this.m_tuneInfo.clockSpeed = 1;
            if (sid2_clock_t2 == ISID2Types.sid2_clock_t.SID2_CLOCK_NTSC) {
                this.m_tuneInfo.clockSpeed = (short)2;
            }
        }
        if (this.m_tuneInfo.clockSpeed == 1) {
            this.vic.chip(MOS656X.mos656x_model_t.MOS6569);
        } else {
            this.vic.chip(MOS656X.mos656x_model_t.MOS6567R8);
        }
        if (sid2_clock_t2 == ISID2Types.sid2_clock_t.SID2_CLOCK_PAL) {
            d = 985248.4;
            this.m_tuneInfo.speedString = TXT_PAL_VBI;
            if (this.m_tuneInfo.songSpeed == 60) {
                this.m_tuneInfo.speedString = TXT_PAL_CIA;
            } else if (this.m_tuneInfo.clockSpeed == 2) {
                this.m_tuneInfo.speedString = TXT_PAL_VBI_FIXED;
            }
        } else {
            d = 1022727.14;
            this.m_tuneInfo.speedString = TXT_NTSC_VBI;
            if (this.m_tuneInfo.songSpeed == 60) {
                this.m_tuneInfo.speedString = TXT_NTSC_CIA;
            } else if (this.m_tuneInfo.clockSpeed == 1) {
                this.m_tuneInfo.speedString = TXT_NTSC_VBI_FIXED;
            }
        }
        return d;
    }

    private int environment(ISID2Types.sid2_env_t sid2_env_t2) {
        switch (this.m_tuneInfo.compatibility) {
            case 2: 
            case 3: {
                sid2_env_t2 = ISID2Types.sid2_env_t.sid2_envR;
                break;
            }
            case 1: {
                if (sid2_env_t2 != ISID2Types.sid2_env_t.sid2_envR) break;
                sid2_env_t2 = ISID2Types.sid2_env_t.sid2_envBS;
            }
        }
        if (this.m_ram == null || this.m_info.environment != sid2_env_t2) {
            this.m_info.environment = sid2_env_t2;
            if (this.m_ram != null) {
                if (this.m_ram == this.m_rom) {
                    this.m_ram = null;
                } else {
                    this.m_rom = null;
                    this.m_ram = null;
                }
            }
            this.m_ram = new short[65536];
            if (this.m_info.environment == ISID2Types.sid2_env_t.sid2_envPS) {
                this.m_rom = this.m_ram;
                this.m_mem = new IMem(){

                    @Override
                    public short m_readMemByte(int n) {
                        return Player.this.readMemByte_plain(n);
                    }

                    @Override
                    public void m_writeMemByte(int n, short s) {
                        Player.this.writeMemByte_playsid(n, s);
                    }

                    @Override
                    public short m_readMemDataByte(int n) {
                        return Player.this.readMemByte_plain(n);
                    }
                };
            } else {
                this.m_rom = new short[65536];
                switch (this.m_info.environment) {
                    case sid2_envTP: {
                        this.m_mem = new IMem(){

                            @Override
                            public short m_readMemByte(int n) {
                                return Player.this.readMemByte_plain(n);
                            }

                            @Override
                            public void m_writeMemByte(int n, short s) {
                                Player.this.writeMemByte_sidplay(n, s);
                            }

                            @Override
                            public short m_readMemDataByte(int n) {
                                return Player.this.readMemByte_sidplaytp(n);
                            }
                        };
                        break;
                    }
                    case sid2_envBS: {
                        this.m_mem = new IMem(){

                            @Override
                            public short m_readMemByte(int n) {
                                return Player.this.readMemByte_plain(n);
                            }

                            @Override
                            public void m_writeMemByte(int n, short s) {
                                Player.this.writeMemByte_sidplay(n, s);
                            }

                            @Override
                            public short m_readMemDataByte(int n) {
                                return Player.this.readMemByte_sidplaybs(n);
                            }
                        };
                        break;
                    }
                    default: {
                        this.m_mem = new IMem(){

                            @Override
                            public short m_readMemByte(int n) {
                                return Player.this.readMemByte_sidplaybs(n);
                            }

                            @Override
                            public void m_writeMemByte(int n, short s) {
                                Player.this.writeMemByte_sidplay(n, s);
                            }

                            @Override
                            public short m_readMemDataByte(int n) {
                                return Player.this.readMemByte_sidplaybs(n);
                            }
                        };
                    }
                }
            }
        }
        ISID2Types.sid2_env_t sid2_env_t3 = this.m_info.environment;
        this.m_info.environment = sid2_env_t2;
        int n = this.initialise();
        this.m_info.environment = sid2_env_t3;
        return n;
    }

    private void fakeIRQ() {
        int n = this.m_tuneInfo.playAddr;
        if (n != 0) {
            this.evalBankSelect(this.m_playBank);
        } else {
            n = this.isKernal ? SIDEndian.endian_little16(this.m_ram, 788) : SIDEndian.endian_little16(this.m_ram, 65534);
        }
        this.cpu.triggerIRQ();
        this.sid6510.reset(n, (short)0, (short)0, (short)0);
    }

    private int initialise() {
        this.mileageCorrect();
        this.m_mileage += this.time();
        this.reset();
        long l = (long)this.m_tuneInfo.loadAddr + (long)this.m_tuneInfo.c64dataLen - 1L >> 8;
        if (l > 255L) {
            this.m_errorString = "SIDPLAYER ERROR: Size of music data exceeds C64 memory.";
            return -1;
        }
        if (this.psidDrvReloc(this.m_tuneInfo, this.m_info) < 0) {
            return -1;
        }
        int n = this.m_tuneInfo.loadAddr;
        int n2 = n + this.m_tuneInfo.c64dataLen;
        SIDEndian.endian_little16(this.m_ram, 45, n2);
        SIDEndian.endian_little16(this.m_ram, 47, n2);
        SIDEndian.endian_little16(this.m_ram, 49, n2);
        SIDEndian.endian_little16(this.m_ram, 172, n);
        SIDEndian.endian_little16(this.m_ram, 174, n2);
        if (!this.m_tune.placeSidTuneInC64mem(this.m_ram)) {
            this.m_errorString = this.m_tuneInfo.statusString;
            return -1;
        }
        this.psidDrvInstall(this.m_info);
        this.rtc.reset();
        this.envReset(false);
        return 0;
    }

    private void mixer() {
        short[] sArray = this.m_sampleBuffer;
        int n = this.m_sampleIndex;
        this.m_sampleClock += this.m_samplePeriod;
        long l = this.m_sampleClock >> 16;
        this.m_sampleClock &= 0xFFFFL;
        this.m_sampleIndex = (int)((long)this.m_sampleIndex + this.output.output(sArray, n));
        this.context().schedule(this.mixerEvent, l, Event.event_phase_t.EVENT_CLOCK_PHI1);
        if (this.m_sampleIndex >= this.m_sampleCount) {
            this.m_running = false;
        }
    }

    private void mixerReset() {
        this.m_sampleClock = this.m_samplePeriod & 0xFFFFL;
        this.context().schedule(this.mixerEvent, this.m_samplePeriod >> 24, Event.event_phase_t.EVENT_CLOCK_PHI1);
    }

    private void mileageCorrect() {
        if (((long)(this.m_sampleCount * 2 * 10) / this.m_cfg.frequency & 1L) != 0L) {
            ++this.m_mileage;
        }
        this.m_sampleCount = 0;
    }

    private int sidCreate(SIDBuilder sIDBuilder, ISID2Types.sid2_model_t sid2_model_t2, ISID2Types.sid2_model_t sid2_model_t3) {
        this.sid[0] = this.xsid.emulation();
        this.xsid.emulation(this.nullsid);
        int n = 0;
        while (n < 2) {
            SIDBuilder sIDBuilder2 = this.sid[n].builder();
            if (sIDBuilder2 != null) {
                sIDBuilder2.unlock(this.sid[n]);
            }
            ++n;
        }
        if (sIDBuilder == null || !sIDBuilder.bool()) {
            n = 0;
            while (n < 2) {
                this.sid[n] = this.nullsid;
                ++n;
            }
        } else {
            if (this.m_tuneInfo.sidModel == 0) {
                switch (sid2_model_t3) {
                    case SID2_MOS6581: {
                        this.m_tuneInfo.sidModel = 1;
                        break;
                    }
                    case SID2_MOS8580: {
                        this.m_tuneInfo.sidModel = 2;
                        break;
                    }
                    case SID2_MODEL_CORRECT: {
                        this.m_tuneInfo.sidModel = 3;
                    }
                }
            }
            if (this.m_tuneInfo.sidModel == 3) {
                if (sid2_model_t2 == ISID2Types.sid2_model_t.SID2_MODEL_CORRECT) {
                    sid2_model_t2 = sid2_model_t3;
                }
                switch (sid2_model_t2) {
                    case SID2_MOS8580: {
                        this.m_tuneInfo.sidModel = 2;
                        break;
                    }
                    default: {
                        this.m_tuneInfo.sidModel = 1;
                    }
                }
            }
            switch (sid2_model_t2) {
                case SID2_MODEL_CORRECT: {
                    switch (this.m_tuneInfo.sidModel) {
                        case 2: {
                            sid2_model_t2 = ISID2Types.sid2_model_t.SID2_MOS8580;
                            break;
                        }
                        case 1: {
                            sid2_model_t2 = ISID2Types.sid2_model_t.SID2_MOS6581;
                        }
                    }
                    break;
                }
                case SID2_MOS6581: {
                    this.m_tuneInfo.sidModel = 1;
                    break;
                }
                case SID2_MOS8580: {
                    this.m_tuneInfo.sidModel = 2;
                }
            }
            n = 0;
            while (n < 2) {
                this.sid[n] = sIDBuilder.lock(this, sid2_model_t2);
                if (this.sid[n] == null) {
                    this.sid[n] = this.nullsid;
                }
                if (n == 0 && !sIDBuilder.bool()) {
                    return -1;
                }
                this.sid[0].optimisation(this.m_cfg.optimisation);
                ++n;
            }
        }
        this.xsid.emulation(this.sid[0]);
        this.sid[0] = this.xsid;
        return 0;
    }

    private void sidSamples(boolean bl) {
        short s = 0;
        this.xsid.sidSamples(bl);
        if (!bl) {
            s = -25;
        }
        this.xsid.gain((short)(-100 - s));
        this.sid[0] = this.xsid.emulation();
        int n = 0;
        while (n < 2) {
            this.sid[n].gain(s);
            ++n;
        }
        this.sid[0] = this.xsid;
    }

    /*
     * Unable to fully structure code
     */
    private void reset() {
        block29: {
            block28: {
                this.m_playerState = ISID2Types.sid2_player_t.sid2_stopped;
                this.m_running = false;
                this.m_sid2crc = -1L;
                this.m_info.sid2crc = this.m_sid2crc ^ -1L;
                this.m_info.sid2crcCount = 0L;
                this.m_sid2crcCount = 0L;
                this.cpu = this.sid6510;
                this.sid6510.environment(this.m_info.environment);
                this.m_scheduler.reset();
                var1_1 = 0;
                while (var1_1 < 2) {
                    var2_2 = this.sid[var1_1];
                    var2_2.reset((short)15);
                    var2_2.write((short)4, (short)8);
                    var2_2.write((short)11, (short)8);
                    var2_2.write((short)18, (short)8);
                    var2_2.write((short)4, (short)0);
                    var2_2.write((short)11, (short)0);
                    var2_2.write((short)18, (short)0);
                    ++var1_1;
                }
                if (this.m_info.environment == ISID2Types.sid2_env_t.sid2_envR) {
                    this.cia.reset();
                    this.cia2.reset();
                    this.vic.reset();
                } else {
                    this.sid6526.reset(this.m_cfg.powerOnDelay <= 8191);
                    this.sid6526.write((short)14, (short)1);
                    if (this.m_tuneInfo.songSpeed == 0) {
                        this.sid6526.lock();
                    }
                }
                this.m_port.pr_in = 0;
                var1_1 = 0;
                while (var1_1 < 65536) {
                    this.m_ram[var1_1] = 0;
                    ++var1_1;
                }
                switch (Player.$SWITCH_TABLE$de$quippy$sidplay$libsidplay$common$ISID2Types$sid2_env_t()[this.m_info.environment.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 4: {
                        var1_1 = 1984;
                        while (var1_1 < 65536) {
                            var2_3 = 0;
                            while (var2_3 < 64) {
                                this.m_ram[var1_1 + var2_3] = 255;
                                ++var2_3;
                            }
                            var1_1 += 128;
                        }
                        var1_1 = 0;
                        while (var1_1 < 65536) {
                            this.m_rom[var1_1] = 0;
                            ++var1_1;
                        }
                        break;
                    }
                    default: {
                        var1_1 = 0;
                        while (var1_1 < 65536) {
                            this.m_rom[var1_1] = 0;
                            ++var1_1;
                        }
                        var1_1 = 0;
                        while (var1_1 < 8192) {
                            this.m_rom[40960 + var1_1] = 96;
                            ++var1_1;
                        }
                        break block0;
                    }
                }
                if (this.m_info.environment != ISID2Types.sid2_env_t.sid2_envR) break block28;
                var1_1 = 0;
                while (var1_1 < IKernal.KERNAL.length) {
                    this.m_rom[57344 + var1_1] = IKernal.KERNAL[var1_1];
                    ++var1_1;
                }
                var1_1 = 0;
                while (var1_1 < IChar.CHAR.length) {
                    this.m_rom[53248 + var1_1] = IChar.CHAR[var1_1];
                    ++var1_1;
                }
                this.m_rom[64873] = 159;
                this.m_rom[58719] = 0;
                this.m_rom[64964] = 234;
                this.m_rom[64965] = 234;
                this.m_rom[64966] = 234;
                if (this.m_tuneInfo.compatibility == 3) {
                    var1_1 = 0;
                    while (var1_1 < IBasic.BASIC.length) {
                        this.m_rom[40960 + var1_1] = IBasic.BASIC[var1_1];
                        ++var1_1;
                    }
                }
                var1_1 = 0;
                var2_4 = 0;
                while (var2_4 < IPowerOn.POWERON.length) {
                    var3_5 = IPowerOn.POWERON[var2_4++];
                    var4_6 = 0;
                    var5_7 = false;
                    if ((var3_5 & 128) != 0) {
                        var3_5 = (short)(var3_5 & 127);
                        if (((var4_6 = IPowerOn.POWERON[var2_4++]) & 128) != 0) {
                            var4_6 = (short)(var4_6 & 127);
                            var5_7 = true;
                        }
                    }
                    var4_6 = (short)(var4_6 + 1);
                    var1_1 += var3_5;
                    if (!var5_7) ** GOTO lbl112
                    var6_8 = IPowerOn.POWERON[var2_4++];
                    if (true) ** GOTO lbl107
                    do {
                        this.m_ram[var1_1++] = var6_8;
lbl107:
                        // 2 sources

                        v0 = var4_6;
                        var4_6 = (short)(v0 - 1);
                    } while (v0 > 0);
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        this.m_ram[var1_1++] = IPowerOn.POWERON[var2_4++];
lbl112:
                        // 2 sources

                        v1 = var4_6;
                        var4_6 = (short)(v1 - 1);
                        ** while (v1 > 0)
                    }
lbl115:
                    // 1 sources

                }
                break block29;
            }
            var1_1 = 0;
            while (var1_1 < 8192) {
                this.m_rom[57344 + var1_1] = 96;
                ++var1_1;
            }
            this.m_rom[53273] = 255;
            if (this.m_info.environment == ISID2Types.sid2_env_t.sid2_envPS) {
                this.m_ram[65352] = 108;
                SIDEndian.endian_little16(this.m_ram, 65353, 788);
            }
            SIDEndian.endian_little16(this.m_ram, 788, 59953);
            SIDEndian.endian_little16(this.m_ram, 790, 65126);
            SIDEndian.endian_little16(this.m_ram, 792, 65095);
            if (this.m_info.environment == ISID2Types.sid2_env_t.sid2_envPS) {
                SIDEndian.endian_little16(this.m_rom, 65530, 65530);
            } else {
                SIDEndian.endian_little16(this.m_rom, 65530, 65091);
            }
            SIDEndian.endian_little16(this.m_rom, 65532, 64738);
            SIDEndian.endian_little16(this.m_rom, 65534, 65352);
            var1_1 = 0;
            while (var1_1 < 6) {
                this.m_ram[65530 + var1_1] = this.m_rom[65530 + var1_1];
                ++var1_1;
            }
        }
        this.m_ram[678] = this.m_tuneInfo.clockSpeed == 1 ? 1 : 0;
    }

    private short iomap(int n) {
        if (this.m_info.environment != ISID2Types.sid2_env_t.sid2_envPS) {
            switch (this.m_tuneInfo.compatibility) {
                case 2: 
                case 3: {
                    return 0;
                }
            }
            if (n == 0) {
                return 0;
            }
            if (n < 40960) {
                return 55;
            }
            if (n < 53248) {
                return 54;
            }
            if (n >= 57344) {
                return 53;
            }
        }
        return 52;
    }

    private short readMemByte_plain(int n) {
        if (n > 1) {
            return this.m_ram[n & 0xFFFF];
        }
        if (n != 0) {
            return this.m_port.pr_in;
        }
        return this.m_port.ddr;
    }

    private short readMemByte_io(int n) {
        int n2 = n & 0xFC1F;
        if ((n2 & 0xFF00) != 54272) {
            if (this.m_info.environment == ISID2Types.sid2_env_t.sid2_envR) {
                switch (SIDEndian.endian_16hi8(n)) {
                    case 0: 
                    case 1: {
                        return this.readMemByte_plain(n);
                    }
                    case 220: {
                        return this.cia.read((short)(n & 0xF));
                    }
                    case 221: {
                        return this.cia2.read((short)(n & 0xF));
                    }
                    case 208: 
                    case 209: 
                    case 210: 
                    case 211: {
                        return this.vic.read((short)(n & 0x3F));
                    }
                }
                return this.m_rom[n & 0xFFFF];
            }
            switch (SIDEndian.endian_16hi8(n)) {
                case 0: 
                case 1: {
                    return this.readMemByte_plain(n);
                }
                case 220: {
                    return this.sid6526.read((short)(n & 0xF));
                }
                case 208: {
                    switch (n & 0x3F) {
                        case 17: 
                        case 18: {
                            return this.sid6526.read((short)(n - 13 & 0xF));
                        }
                    }
                }
            }
            return this.m_rom[n & 0xFFFF];
        }
        int n3 = this.m_sidmapper[n >> 5 & 0x1F];
        return this.sid[n3].read((short)(n2 & 0xFF));
    }

    private short readMemByte_sidplaytp(int n) {
        if (n < 53248) {
            return this.readMemByte_plain(n);
        }
        switch (n >> 12) {
            case 13: {
                if (this.isIO) {
                    return this.readMemByte_io(n);
                }
                return this.m_ram[n];
            }
        }
        return this.m_ram[n & 0xFFFF];
    }

    private short readMemByte_sidplaybs(int n) {
        if (n < 40960) {
            return this.readMemByte_plain(n);
        }
        switch (n >> 12) {
            case 10: 
            case 11: {
                if (this.isBasic) {
                    return this.m_rom[n];
                }
                return this.m_ram[n];
            }
            case 12: {
                return this.m_ram[n];
            }
            case 13: {
                if (this.isIO) {
                    return this.readMemByte_io(n);
                }
                if (this.isChar) {
                    return this.m_rom[n];
                }
                return this.m_ram[n];
            }
        }
        if (this.isKernal) {
            return this.m_rom[n & 0xFFFF];
        }
        return this.m_ram[n & 0xFFFF];
    }

    private void writeMemByte_plain(int n, short s) {
        if (n > 1) {
            this.m_ram[n & 0xFFFF] = s;
        } else if (n != 0) {
            this.evalBankSelect(s);
        } else {
            this.m_port.ddr = s;
            this.evalBankSelect(this.m_port.pr_out);
        }
    }

    private void writeMemByte_playsid(int n, short s) {
        int n2 = n & 0xFC1F;
        if ((n2 & 0xFF00) != 54272) {
            if (this.m_info.environment == ISID2Types.sid2_env_t.sid2_envR) {
                switch (SIDEndian.endian_16hi8(n)) {
                    case 0: 
                    case 1: {
                        this.writeMemByte_plain(n, s);
                        return;
                    }
                    case 220: {
                        this.cia.write((short)(n & 0xF), s);
                        return;
                    }
                    case 221: {
                        this.cia2.write((short)(n & 0xF), s);
                        return;
                    }
                    case 208: 
                    case 209: 
                    case 210: 
                    case 211: {
                        this.vic.write((short)(n & 0x3F), s);
                        return;
                    }
                }
                this.m_rom[n & 0xFFFF] = s;
                return;
            }
            switch (SIDEndian.endian_16hi8(n)) {
                case 0: 
                case 1: {
                    this.writeMemByte_plain(n, s);
                    return;
                }
                case 220: {
                    this.sid6526.write((short)(n & 0xF), s);
                    return;
                }
            }
            this.m_rom[n & 0xFFFF] = s;
            return;
        }
        this.sid2crc(s);
        if ((n2 & 0xFF) >= 29) {
            this.xsid.write16(n & 0x1FF, s);
        } else {
            int n3 = this.m_sidmapper[n >> 5 & 0x1F];
            this.sid[n3].write((short)(n2 & 0xFF), s);
            if (this.m_emulateStereo) {
                this.sid[1].write((short)(n2 & 0xFF), s);
            }
        }
    }

    private void writeMemByte_sidplay(int n, short s) {
        if (n < 40960) {
            this.writeMemByte_plain(n, s);
        } else {
            switch (n >> 12) {
                case 10: 
                case 11: 
                case 12: {
                    this.m_ram[n] = s;
                    break;
                }
                case 13: {
                    if (this.isIO) {
                        this.writeMemByte_playsid(n, s);
                        break;
                    }
                    this.m_ram[n] = s;
                    break;
                }
                default: {
                    this.m_ram[n & 0xFFFF] = s;
                }
            }
        }
    }

    private void envReset(boolean bl) {
        short s;
        if (bl) {
            if (this.m_info.environment == ISID2Types.sid2_env_t.sid2_envR) {
                short[] sArray = new short[]{169, 127, 141, 13, 220, 96};
                ISID2Types.sid2_info_t sid2_info_t2 = new ISID2Types.sid2_info_t();
                SidTuneInfo sidTuneInfo = new SidTuneInfo();
                sidTuneInfo.relocStartPage = (short)9;
                sidTuneInfo.relocPages = (short)32;
                sidTuneInfo.initAddr = 2048;
                sidTuneInfo.songSpeed = (short)60;
                sid2_info_t2.environment = this.m_info.environment;
                this.psidDrvReloc(sidTuneInfo, sid2_info_t2);
                int n = 0;
                while (n < sArray.length) {
                    this.m_ram[2048 + n] = sArray[n];
                    ++n;
                }
                this.psidDrvInstall(sid2_info_t2);
            } else {
                this.sid6526.reset();
            }
            s = 0;
            while (s < 2) {
                this.sid[s].reset((short)0);
                ++s;
            }
        }
        this.m_port.ddr = (short)47;
        if (this.m_info.environment != ISID2Types.sid2_env_t.sid2_envR) {
            s = (short)(this.m_tuneInfo.currentSong - 1);
            short s2 = this.iomap(this.m_tuneInfo.initAddr);
            this.evalBankSelect(s2);
            this.m_playBank = this.iomap(this.m_tuneInfo.playAddr);
            if (this.m_info.environment != ISID2Types.sid2_env_t.sid2_envPS) {
                this.sid6510.reset(this.m_tuneInfo.initAddr, s, (short)0, (short)0);
            } else {
                this.sid6510.reset(this.m_tuneInfo.initAddr, s, s, s);
            }
        } else {
            this.evalBankSelect((short)55);
            this.cpu.reset();
        }
        this.mixerReset();
        this.xsid.suppress(true);
    }

    private long monoOutGenericLeftIn(short s) {
        return this.sid[0].output(s) * this.m_leftVolume / 255L;
    }

    private long monoOutGenericStereoIn(short s) {
        return (this.sid[0].output(s) * this.m_leftVolume + this.sid[1].output(s) * this.m_rightVolume) / 510L;
    }

    private long monoOutGenericRightIn(short s) {
        return this.sid[1].output(s) * this.m_rightVolume / 255L;
    }

    private long monoOut8MonoIn(short[] sArray, int n) {
        sArray[n] = (byte)(this.monoOutGenericLeftIn((short)8) ^ 0x80L);
        return 1L;
    }

    private long monoOut8StereoIn(short[] sArray, int n) {
        sArray[n] = (byte)(this.monoOutGenericStereoIn((short)8) ^ 0x80L);
        return 1L;
    }

    private long monoOut8StereoRIn(short[] sArray, int n) {
        sArray[n] = (byte)(this.monoOutGenericRightIn((short)8) ^ 0x80L);
        return 1L;
    }

    private long stereoOut8MonoIn(short[] sArray, int n) {
        short s;
        sArray[n + 0] = s = (short)((byte)(this.monoOutGenericLeftIn((short)8) ^ 0x80L));
        sArray[n + 1] = s;
        return 2L;
    }

    private long stereoOut8StereoIn(short[] sArray, int n) {
        sArray[n + 0] = (byte)(this.monoOutGenericLeftIn((short)8) ^ 0x80L);
        sArray[n + 1] = (byte)(this.monoOutGenericRightIn((short)8) ^ 0x80L);
        return 2L;
    }

    private long monoOut16MonoIn(short[] sArray, int n) {
        SIDEndian.endian_16(sArray, n, (int)this.monoOutGenericLeftIn((short)16));
        return 2L;
    }

    private long monoOut16StereoIn(short[] sArray, int n) {
        SIDEndian.endian_16(sArray, n, (int)this.monoOutGenericStereoIn((short)16));
        return 2L;
    }

    private long monoOut16StereoRIn(short[] sArray, int n) {
        SIDEndian.endian_16(sArray, n, (int)this.monoOutGenericRightIn((short)16));
        return 2L;
    }

    private long stereoOut16MonoIn(short[] sArray, int n) {
        int n2 = (int)this.monoOutGenericLeftIn((short)16);
        SIDEndian.endian_16(sArray, n, n2);
        SIDEndian.endian_16(sArray, n + 2, n2);
        return 4L;
    }

    private long stereoOut16StereoIn(short[] sArray, int n) {
        SIDEndian.endian_16(sArray, n, (int)this.monoOutGenericLeftIn((short)16));
        SIDEndian.endian_16(sArray, n + 2, (int)this.monoOutGenericRightIn((short)16));
        return 4L;
    }

    @Override
    public void interruptIRQ(boolean bl) {
        if (bl) {
            if (this.m_info.environment == ISID2Types.sid2_env_t.sid2_envR) {
                this.cpu.triggerIRQ();
            } else {
                this.fakeIRQ();
            }
        } else {
            this.cpu.clearIRQ();
        }
    }

    @Override
    public void interruptNMI() {
        this.cpu.triggerNMI();
    }

    @Override
    public void interruptRST() {
        this.stop();
    }

    @Override
    public void signalAEC(boolean bl) {
        this.cpu.aecSignal(bl);
    }

    @Override
    public short readMemRamByte(int n) {
        return this.m_ram[n];
    }

    @Override
    public void sid2crc(short s) {
        if (this.m_sid2crcCount < this.m_cfg.sid2crcCount) {
            this.m_info.sid2crcCount = ++this.m_sid2crcCount;
            this.m_sid2crc = this.m_sid2crc >> 8 ^ crc32Table[(int)(this.m_sid2crc & 0xFFL ^ (long)s)];
            this.m_info.sid2crc = this.m_sid2crc ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    @Override
    public void lightpen() {
        this.vic.lightpen();
    }

    private int psidDrvReloc(SidTuneInfo sidTuneInfo, ISID2Types.sid2_info_t sid2_info_t2) {
        int n = sidTuneInfo.loadAddr >> 8;
        int n2 = sidTuneInfo.loadAddr + (sidTuneInfo.c64dataLen - 1) >> 8;
        if (sid2_info_t2.environment != ISID2Types.sid2_env_t.sid2_envR) {
            sid2_info_t2.driverAddr = 0;
            sid2_info_t2.driverLength = 0;
            sid2_info_t2.powerOnDelay = 0;
            return 0;
        }
        if (sidTuneInfo.compatibility == 3) {
            sidTuneInfo.relocStartPage = (short)4;
            sidTuneInfo.relocPages = (short)3;
        }
        if (sidTuneInfo.relocStartPage == 255) {
            sidTuneInfo.relocPages = 0;
        } else if (sidTuneInfo.relocStartPage == 0) {
            this.psidRelocAddr(sidTuneInfo, n, n2);
        }
        if (sidTuneInfo.relocPages < 1) {
            this.m_errorString = ERR_PSIDDRV_NO_SPACE;
            return -1;
        }
        short[] sArray = IPSIDDrv.PSIDDRV;
        int n3 = IPSIDDrv.PSIDDRV.length;
        int n4 = sidTuneInfo.relocStartPage << 8;
        BufPos bufPos = this.reloc65(sArray, n3, n4 - 10);
        if (bufPos == null) {
            this.m_errorString = ERR_PSIDDRV_RELOC;
            return -1;
        }
        sArray = bufPos.fBuf;
        int n5 = bufPos.fPos;
        n3 = bufPos.fSize;
        sid2_info_t2.driverAddr = n4;
        sid2_info_t2.driverLength = n3 -= 10;
        sid2_info_t2.driverLength += 255;
        sid2_info_t2.driverLength &= 0xFF00;
        this.m_rom[65532] = sArray[n5 + 0];
        this.m_rom[65533] = sArray[n5 + 1];
        if (sidTuneInfo.compatibility == 3) {
            short[] sArray2 = new short[]{169, (short)(sidTuneInfo.currentSong - 1), 141, 12, 3, 32, 44, 168, 76, 177, 167};
            int n6 = 0;
            while (n6 < sArray2.length) {
                this.m_rom[48979 + n6] = sArray2[n6];
                ++n6;
            }
            this.m_rom[42926] = 76;
            SIDEndian.endian_little16(this.m_rom, 42927, 48979);
        } else {
            if (sidTuneInfo.compatibility == 2) {
                this.m_ram[788] = sArray[n5 + 2];
                this.m_ram[789] = sArray[n5 + 2 + 1];
            } else {
                this.m_ram[788] = sArray[n5 + 2];
                this.m_ram[789] = sArray[n5 + 2 + 1];
                this.m_ram[790] = sArray[n5 + 2 + 2];
                this.m_ram[791] = sArray[n5 + 2 + 3];
                this.m_ram[792] = sArray[n5 + 2 + 4];
                this.m_ram[793] = sArray[n5 + 2 + 5];
            }
            int n7 = SIDEndian.endian_little16(sArray, n5 + 8);
            this.m_rom[42926] = 76;
            SIDEndian.endian_little16(this.m_rom, 42927, 65505);
            SIDEndian.endian_little16(this.m_ram, 808, n7);
        }
        int n8 = 0;
        while (n8 < n3) {
            this.m_rom[n8] = sArray[n5 + 10 + n8];
            ++n8;
        }
        sArray = this.m_rom;
        n3 = 0;
        sArray[n3++] = (short)(sidTuneInfo.currentSong - 1);
        sArray[n3] = sidTuneInfo.songSpeed == 0 ? (short)0 : 1;
        SIDEndian.endian_little16(sArray, ++n3, sidTuneInfo.compatibility == 3 ? 48981 : sidTuneInfo.initAddr);
        SIDEndian.endian_little16(sArray, n3 += 2, sidTuneInfo.playAddr);
        n3 += 2;
        sid2_info_t2.powerOnDelay = this.m_cfg.powerOnDelay;
        if (sid2_info_t2.powerOnDelay > 8191) {
            sid2_info_t2.powerOnDelay = (short)(this.m_rand >> 3) & 0x1FFF;
        }
        SIDEndian.endian_little16(sArray, n3, sid2_info_t2.powerOnDelay);
        n3 += 2;
        this.m_rand = this.m_rand * 13 + 1;
        sArray[n3++] = this.iomap(this.m_tuneInfo.initAddr);
        sArray[n3++] = this.iomap(this.m_tuneInfo.playAddr);
        short s = this.m_ram[678];
        sArray[n3 + 0] = s;
        sArray[n3 + 1] = s;
        ++n3;
        switch (this.m_tune.getInfo().clockSpeed) {
            case 1: {
                sArray[n3++] = 1;
                break;
            }
            case 2: {
                sArray[n3++] = 0;
                break;
            }
            default: {
                ++n3;
            }
        }
        sArray[n3++] = sidTuneInfo.compatibility >= 2 ? 0 : 4;
        return 0;
    }

    private void psidDrvInstall(ISID2Types.sid2_info_t sid2_info_t2) {
        int n = 0;
        while (n < sid2_info_t2.driverLength) {
            this.m_ram[sid2_info_t2.driverAddr + n] = this.m_rom[n];
            ++n;
        }
    }

    private void psidRelocAddr(SidTuneInfo sidTuneInfo, int n, int n2) {
        int n3;
        boolean[] blArray = new boolean[256];
        int[] nArray = new int[8];
        nArray[1] = 3;
        nArray[2] = 160;
        nArray[3] = 191;
        nArray[4] = 208;
        nArray[5] = 255;
        nArray[6] = n;
        nArray[7] = n <= n2 && n2 <= 255 ? n2 : 255;
        int[] nArray2 = nArray;
        int n4 = 0;
        while (n4 < blArray.length) {
            blArray[n4] = false;
            ++n4;
        }
        n4 = 0;
        while (n4 < nArray2.length) {
            n3 = nArray2[n4];
            while (n3 <= nArray2[n4 + 1]) {
                blArray[n3] = true;
                ++n3;
            }
            n4 += 2;
        }
        n3 = 0;
        sidTuneInfo.relocPages = 0;
        int n5 = 0;
        while (n5 < blArray.length) {
            if (blArray[n5]) {
                n4 = n5 - n3;
                if (n4 > sidTuneInfo.relocPages) {
                    sidTuneInfo.relocStartPage = (short)n3;
                    sidTuneInfo.relocPages = (short)n4;
                }
                n3 = n5 + 1;
            }
            ++n5;
        }
        if (sidTuneInfo.relocPages == 0) {
            sidTuneInfo.relocStartPage = (short)255;
        }
    }

    public Player() {
        super(new EventScheduler("SIDPlay 2"));
        char[] cArray = new char[5];
        cArray[0] = '\u0001';
        cArray[2] = 111;
        cArray[3] = 54;
        cArray[4] = 53;
        this.cmp = cArray;
        this.m_scheduler = (EventScheduler)this.context();
        this.envp = new C64Environment(){

            @Override
            protected void envReset() {
                Player.this.envReset(true);
            }

            @Override
            protected short envReadMemByte(int n) {
                return Player.this.m_mem.m_readMemByte(n);
            }

            @Override
            protected void envWriteMemByte(int n, short s) {
                Player.this.m_mem.m_writeMemByte(n, s);
            }

            @Override
            protected boolean envCheckBankJump(int n) {
                block0 : switch (((Player)Player.this).m_info.environment) {
                    case sid2_envBS: {
                        if (n < 40960) break;
                        switch (n >> 12) {
                            case 10: 
                            case 11: {
                                if (!Player.this.isBasic) break block0;
                                return false;
                            }
                            case 12: {
                                break block0;
                            }
                            case 13: {
                                if (!Player.this.isIO) break block0;
                                return false;
                            }
                        }
                        if (!Player.this.isKernal) break;
                        return false;
                    }
                    case sid2_envTP: {
                        if (n < 53248 || !Player.this.isKernal) break;
                        return false;
                    }
                }
                return true;
            }

            @Override
            protected short envReadMemDataByte(int n) {
                return Player.this.m_mem.m_readMemDataByte(n);
            }

            @Override
            protected void envSleep() {
                if (((Player)Player.this).m_info.environment != ISID2Types.sid2_env_t.sid2_envR) {
                    Player.this.xsid.suppress(false);
                    Player.this.xsid.suppress(true);
                }
            }

            @Override
            protected void envLoadFile(String string) {
                StringBuffer stringBuffer = new StringBuffer("E:/testsuite/");
                stringBuffer.append(string);
                stringBuffer.append(".prg");
                Player.this.m_tune.load(stringBuffer.toString());
                Player.this.stop();
            }
        };
        this.sid6510 = new SID6510(this.m_scheduler);
        this.mos6510 = new MOS6510(this.m_scheduler);
        this.cpu = this.sid6510;
        this.nullsid = new NullSID();
        this.xsid = new C64XSID(this, this.nullsid);
        this.cia = new C64CIA.C64cia1(this);
        this.cia2 = new C64CIA.C64cia2(this);
        this.sid6526 = new SID6526(this);
        this.vic = new C64VIC(this);
        this.mixerEvent = new EventMixer(this);
        this.rtc = new EventRTC(this.m_scheduler);
        this.m_tune = null;
        this.m_ram = null;
        this.m_rom = null;
        this.m_errorString = TXT_NA;
        this.m_fastForwardFactor = 1.0;
        this.m_mileage = 0L;
        this.m_playerState = ISID2Types.sid2_player_t.sid2_stopped;
        this.m_running = false;
        this.m_sid2crc = -1L;
        this.m_sid2crcCount = 0L;
        this.m_emulateStereo = true;
        this.m_sampleCount = 0;
        this.m_rand = (int)System.currentTimeMillis();
        this.sid6510.setEnvironment(this.envp);
        this.mos6510.setEnvironment(this.envp);
        int n = 0;
        while (n < 2) {
            this.sid[n] = this.nullsid;
            ++n;
        }
        this.xsid.emulation(this.sid[0]);
        this.sid[0] = this.xsid;
        n = 0;
        while (n < 32) {
            this.m_sidmapper[n] = 0;
            ++n;
        }
        this.m_info.credits = credit;
        this.m_info.channels = 1;
        this.m_info.driverAddr = 0;
        this.m_info.driverLength = 0;
        this.m_info.name = "libsidplay";
        this.m_info.tuneInfo = null;
        this.m_info.version = "2.1.1";
        this.m_info.eventContext = this.context();
        this.m_info.maxsids = 2;
        this.m_info.environment = ISID2Types.sid2_env_t.sid2_envR;
        this.m_info.sid2crc = 0L;
        this.m_info.sid2crcCount = 0L;
        this.m_cfg.clockDefault = ISID2Types.sid2_clock_t.SID2_CLOCK_CORRECT;
        this.m_cfg.clockForced = false;
        this.m_cfg.clockSpeed = ISID2Types.sid2_clock_t.SID2_CLOCK_CORRECT;
        this.m_cfg.environment = this.m_info.environment;
        this.m_cfg.forceDualSids = false;
        this.m_cfg.emulateStereo = this.m_emulateStereo;
        this.m_cfg.frequency = 44100L;
        this.m_cfg.optimisation = 1;
        this.m_cfg.playback = ISID2Types.sid2_playback_t.sid2_mono;
        this.m_cfg.precision = 16;
        this.m_cfg.sidDefault = ISID2Types.sid2_model_t.SID2_MODEL_CORRECT;
        this.m_cfg.sidEmulation = null;
        this.m_cfg.sidModel = ISID2Types.sid2_model_t.SID2_MODEL_CORRECT;
        this.m_cfg.sidSamples = true;
        this.m_cfg.leftVolume = 255L;
        this.m_cfg.rightVolume = 255L;
        this.m_cfg.sampleFormat = ISID2Types.sid2_sample_t.SID2_LITTLE_SIGNED;
        this.m_cfg.powerOnDelay = 8192;
        this.m_cfg.sid2crcCount = 0L;
        this.config(this.m_cfg);
        Player.credit[0] = "libsidplay V2.1.1 Engine:\n\tCopyright (C) 2000 Simon White <sidplay2@yahoo.com>\n\thttp://sidplay2.sourceforge.net\n";
        Player.credit[1] = this.xsid.credits();
        Player.credit[2] = "*MOS6510 (CPU) Emulation:\n\tCopyright (C) 2000 Simon White <sidplay2@yahoo.com>\n";
        Player.credit[3] = this.cia.credits();
        Player.credit[4] = this.vic.credits();
        Player.credit[5] = null;
    }

    public final ISID2Types.sid2_config_t config() {
        return this.m_cfg;
    }

    public final ISID2Types.sid2_info_t info() {
        return this.m_info;
    }

    public int config(ISID2Types.sid2_config_t sid2_config_t2) {
        boolean bl = false;
        if (this.m_running) {
            this.m_errorString = ERR_CONF_WHILST_ACTIVE;
            return -1;
        }
        if (sid2_config_t2.frequency < 4000L) {
            this.m_errorString = ERR_UNSUPPORTED_FREQ;
            return -1;
        }
        switch (sid2_config_t2.precision) {
            case 8: 
            case 16: 
            case 24: {
                if (sid2_config_t2.precision <= 16) break;
                this.m_errorString = ERR_UNSUPPORTED_PRECISION;
                return -1;
            }
            default: {
                this.m_errorString = ERR_UNSUPPORTED_PRECISION;
                return -1;
            }
        }
        if (this.m_tune != null && this.m_tune.bool()) {
            if (this.m_playerState != ISID2Types.sid2_player_t.sid2_paused) {
                this.m_tuneInfo = this.m_tune.getInfo();
            }
            if (this.sidCreate(sid2_config_t2.sidEmulation, sid2_config_t2.sidModel, sid2_config_t2.sidDefault) < 0) {
                this.m_errorString = sid2_config_t2.sidEmulation.error();
                this.m_cfg.sidEmulation = null;
                if (this.m_cfg != sid2_config_t2) {
                    this.config(this.m_cfg);
                }
                return -1;
            }
            if (this.m_playerState != ISID2Types.sid2_player_t.sid2_paused) {
                double d = this.clockSpeed(sid2_config_t2.clockSpeed, sid2_config_t2.clockDefault, sid2_config_t2.clockForced);
                this.m_samplePeriod = (long)(d / (double)sid2_config_t2.frequency * 65536.0 * this.m_fastForwardFactor);
                this.sid6526.clock((int)(d / 50.0 + 0.5));
                if (this.m_tuneInfo.songSpeed == 60 || this.m_tuneInfo.clockSpeed == 2) {
                    this.sid6526.clock((int)(d / 60.0 + 0.5));
                }
                if (this.m_tuneInfo.clockSpeed == 1) {
                    this.cia.clock(d / 50.0);
                    this.cia2.clock(d / 50.0);
                } else {
                    this.cia.clock(d / 60.0);
                    this.cia2.clock(d / 60.0);
                }
                if (this.environment(sid2_config_t2.environment) < 0) {
                    if (this.m_cfg != sid2_config_t2) {
                        this.config(this.m_cfg);
                    }
                    return -1;
                }
                this.rtc.clock(d);
            }
        }
        this.sidSamples(sid2_config_t2.sidSamples);
        int n = 0;
        while (n < 32) {
            this.m_sidmapper[n] = 0;
            ++n;
        }
        if (this.m_tuneInfo.sidChipBase2 != 0) {
            bl = false;
            this.m_sidmapper[this.m_tuneInfo.sidChipBase2 >> 5 & 0x1F] = 1;
        }
        bl = this.m_tuneInfo.sidChipBase2 == 0;
        this.m_info.channels = 1;
        this.m_emulateStereo = false;
        if (sid2_config_t2.playback == ISID2Types.sid2_playback_t.sid2_stereo) {
            ++this.m_info.channels;
            if (bl && this.sid[1] != this.nullsid) {
                this.m_emulateStereo = sid2_config_t2.emulateStereo;
            }
        }
        if (bl && sid2_config_t2.forceDualSids) {
            bl = false;
            this.m_sidmapper[8] = 1;
        }
        this.m_leftVolume = sid2_config_t2.leftVolume;
        this.m_rightVolume = sid2_config_t2.rightVolume;
        if (sid2_config_t2.playback != ISID2Types.sid2_playback_t.sid2_mono) {
            if (this.m_emulateStereo) {
                this.sid[0].voice((short)0, (short)0, true);
                this.sid[0].voice((short)2, (short)0, true);
                this.sid[1].voice((short)1, (short)0, true);
                bl = false;
            }
            if (sid2_config_t2.playback == ISID2Types.sid2_playback_t.sid2_left) {
                this.xsid.mute(true);
            }
        }
        block3 : switch (sid2_config_t2.precision) {
            case 8: {
                if (bl) {
                    if (sid2_config_t2.playback == ISID2Types.sid2_playback_t.sid2_stereo) {
                        this.output = new IOutput(){

                            @Override
                            public long output(short[] sArray, int n) {
                                return Player.this.stereoOut8MonoIn(sArray, n);
                            }
                        };
                        break;
                    }
                    this.output = new IOutput(){

                        @Override
                        public long output(short[] sArray, int n) {
                            return Player.this.monoOut8MonoIn(sArray, n);
                        }
                    };
                    break;
                }
                switch (sid2_config_t2.playback) {
                    case sid2_stereo: {
                        this.output = new IOutput(){

                            @Override
                            public long output(short[] sArray, int n) {
                                return Player.this.stereoOut8StereoIn(sArray, n);
                            }
                        };
                        break;
                    }
                    case sid2_right: {
                        this.output = new IOutput(){

                            @Override
                            public long output(short[] sArray, int n) {
                                return Player.this.monoOut8StereoRIn(sArray, n);
                            }
                        };
                        break;
                    }
                    case sid2_left: {
                        this.output = new IOutput(){

                            @Override
                            public long output(short[] sArray, int n) {
                                return Player.this.monoOut8MonoIn(sArray, n);
                            }
                        };
                        break;
                    }
                    case sid2_mono: {
                        this.output = new IOutput(){

                            @Override
                            public long output(short[] sArray, int n) {
                                return Player.this.monoOut8StereoIn(sArray, n);
                            }
                        };
                    }
                }
                break;
            }
            case 16: {
                if (bl) {
                    if (sid2_config_t2.playback == ISID2Types.sid2_playback_t.sid2_stereo) {
                        this.output = new IOutput(){

                            @Override
                            public long output(short[] sArray, int n) {
                                return Player.this.stereoOut16MonoIn(sArray, n);
                            }
                        };
                        break;
                    }
                    this.output = new IOutput(){

                        @Override
                        public long output(short[] sArray, int n) {
                            return Player.this.monoOut16MonoIn(sArray, n);
                        }
                    };
                    break;
                }
                switch (sid2_config_t2.playback) {
                    case sid2_stereo: {
                        this.output = new IOutput(){

                            @Override
                            public long output(short[] sArray, int n) {
                                return Player.this.stereoOut16StereoIn(sArray, n);
                            }
                        };
                        break block3;
                    }
                    case sid2_right: {
                        this.output = new IOutput(){

                            @Override
                            public long output(short[] sArray, int n) {
                                return Player.this.monoOut16StereoRIn(sArray, n);
                            }
                        };
                        break block3;
                    }
                    case sid2_left: {
                        this.output = new IOutput(){

                            @Override
                            public long output(short[] sArray, int n) {
                                return Player.this.monoOut16MonoIn(sArray, n);
                            }
                        };
                        break block3;
                    }
                    case sid2_mono: {
                        this.output = new IOutput(){

                            @Override
                            public long output(short[] sArray, int n) {
                                return Player.this.monoOut16StereoIn(sArray, n);
                            }
                        };
                    }
                }
            }
        }
        this.m_cfg = sid2_config_t2;
        if (this.m_cfg.optimisation > 2) {
            this.m_cfg.optimisation = (byte)2;
        }
        return 0;
    }

    public int fastForward(int n) {
        if (n > 3200) {
            this.m_errorString = "SIDPLAYER ERROR: Percentage value out of range";
            return -1;
        }
        double d = (double)n / 100.0;
        this.m_samplePeriod = (long)((double)this.m_samplePeriod / this.m_fastForwardFactor * d);
        this.m_fastForwardFactor = d;
        return 0;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public int load(SidTune sidTune) {
        this.m_tune = sidTune;
        if (sidTune == null || !sidTune.bool()) {
            this.m_info.tuneInfo = null;
            return 0;
        }
        this.xsid.mute(false);
        int n = 0;
        while (n < 2) {
            block6: {
                short s;
                short s2;
                block5: {
                    s2 = 3;
                    if (!true) break block5;
                    s = s2;
                    s2 = (short)(s - 1);
                    if (s == 0) break block6;
                }
                do {
                    this.sid[n].voice(s2, (short)0, false);
                    s = s2;
                    s2 = (short)(s - 1);
                } while (s != 0);
            }
            ++n;
        }
        n = this.config(this.m_cfg);
        if (n < 0) {
            this.m_tune = null;
            return -1;
        }
        this.m_info.tuneInfo = this.m_tuneInfo;
        return 0;
    }

    public long mileage() {
        return this.m_mileage + this.time();
    }

    public void pause() {
        if (this.m_running) {
            this.m_playerState = ISID2Types.sid2_player_t.sid2_paused;
            this.m_running = false;
        }
    }

    public long play(short[] sArray, int n) {
        if (!this.m_tune.bool()) {
            return 0L;
        }
        this.m_sampleIndex = 0;
        this.m_sampleCount = n;
        this.m_sampleBuffer = sArray;
        this.m_playerState = ISID2Types.sid2_player_t.sid2_playing;
        this.m_running = true;
        while (this.m_running) {
            this.m_scheduler.clock();
        }
        if (this.m_playerState == ISID2Types.sid2_player_t.sid2_stopped) {
            this.initialise();
        }
        return this.m_sampleIndex;
    }

    public ISID2Types.sid2_player_t state() {
        return this.m_playerState;
    }

    public void stop() {
        if (this.m_tune != null && this.m_tune.bool() && this.m_playerState != ISID2Types.sid2_player_t.sid2_stopped) {
            if (!this.m_running) {
                this.initialise();
            } else {
                this.m_playerState = ISID2Types.sid2_player_t.sid2_stopped;
                this.m_running = false;
            }
        }
    }

    public long time() {
        return this.rtc.getTime();
    }

    public void debug(boolean bl) {
        this.cpu.debug(bl);
    }

    public final String error() {
        return this.m_errorString;
    }

    private int read_options(short[] sArray, int n) {
        int n2 = 0;
        int n3 = sArray[n + 0];
        while (n3 != 0 && n3 != -1) {
            n3 = sArray[n + (n2 += (n3 &= 0xFF))];
        }
        return ++n2;
    }

    private int read_undef(short[] sArray, int n) {
        int n2 = 2;
        int n3 = sArray[n + 0] + 256 * sArray[n + 1];
        while (n3 != 0) {
            --n3;
            while (sArray[n + n2++] == 0) {
            }
        }
        return n2;
    }

    private int reloc_seg(short[] sArray, int n, int n2, short[] sArray2, int n3, file65 file652) {
        int n4 = -1;
        while (sArray2[n3] != 0) {
            if ((sArray2[n3] & 0xFF) == 255) {
                n4 += 254;
                ++n3;
                continue;
            }
            n4 += sArray2[n3] & 0xFF;
            int n5 = sArray2[++n3] & 0xE0;
            int n6 = sArray2[n3] & 7;
            ++n3;
            switch (n5) {
                case 128: {
                    int n7 = sArray[n + n4] + 256 * sArray[n + n4 + 1];
                    int n8 = n7 + this.reldiff(n6, file652);
                    sArray[n + n4] = (short)(n8 & 0xFF);
                    sArray[n + n4 + 1] = (short)(n8 >> 8 & 0xFF);
                    break;
                }
                case 64: {
                    int n7 = sArray[n + n4] * 256 + sArray2[n3];
                    int n8 = n7 + this.reldiff(n6, file652);
                    sArray[n + n4] = (short)(n8 >> 8 & 0xFF);
                    sArray2[n3] = (short)(n8 & 0xFF);
                    ++n3;
                    break;
                }
                case 32: {
                    int n7 = sArray[n + n4];
                    int n8 = n7 + this.reldiff(n6, file652);
                    sArray[n + n4] = (short)(n8 & 0xFF);
                }
            }
            if (n6 != 0) continue;
            n3 += 2;
        }
        return ++n3;
    }

    private int reloc_globals(short[] sArray, int n, file65 file652) {
        int n2 = sArray[n + 0] + 256 * sArray[n + 1];
        n += 2;
        while (n2 != 0) {
            while (sArray[n++] != 0) {
            }
            short s = sArray[n];
            int n3 = sArray[n + 1] + 256 * sArray[n + 2];
            int n4 = n3 + this.reldiff(s, file652);
            sArray[n + 1] = (short)(n4 & 0xFF);
            sArray[n + 2] = (short)(n4 >> 8 & 0xFF);
            n += 3;
            --n2;
        }
        return n;
    }

    private BufPos reloc65(short[] sArray, int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        this.file.buf = sArray;
        bl = true;
        n3 = n2;
        n7 = 1;
        int n8 = 0;
        while (n8 < 5) {
            if (this.file.buf[n8] != this.cmp[n8]) {
                return null;
            }
            ++n8;
        }
        int n9 = this.file.buf[7] * 256 + this.file.buf[6];
        if ((n9 & 0x2000) != 0) {
            return null;
        }
        if ((n9 & 0x4000) != 0) {
            return null;
        }
        int n10 = 26 + this.read_options(this.file.buf, 26);
        this.file.tbase = this.file.buf[9] * 256 + this.file.buf[8];
        this.file.tlen = this.file.buf[11] * 256 + this.file.buf[10];
        this.file.tdiff = bl ? n3 - this.file.tbase : 0;
        this.file.dbase = this.file.buf[13] * 256 + this.file.buf[12];
        this.file.dlen = this.file.buf[15] * 256 + this.file.buf[14];
        this.file.ddiff = bl2 ? n4 - this.file.dbase : 0;
        this.file.bbase = this.file.buf[17] * 256 + this.file.buf[16];
        this.file.bdiff = bl3 ? n5 - this.file.bbase : 0;
        this.file.zbase = this.file.buf[21] * 256 + this.file.buf[20];
        this.file.zdiff = bl4 ? n6 - this.file.zbase : 0;
        this.file.segt = this.file.buf;
        n8 = n10;
        this.file.segd = this.file.segt;
        int n11 = n8 + this.file.tlen;
        this.file.utab = this.file.segd;
        int n12 = n11 + this.file.dlen;
        this.file.rttab = this.file.utab;
        int n13 = n12 + this.read_undef(this.file.utab, n12);
        this.file.rdtab = this.file.rttab;
        this.file.extab = this.file.rdtab;
        int n14 = this.reloc_seg(this.file.segt, n8, this.file.tlen, this.file.rttab, n13, this.file);
        int n15 = this.reloc_seg(this.file.segd, n11, this.file.dlen, this.file.rdtab, n14, this.file);
        this.reloc_globals(this.file.extab, n15, this.file);
        if (bl) {
            ((file65)this.file).buf[9] = (short)(n3 >> 8 & 0xFF);
            ((file65)this.file).buf[8] = (short)(n3 & 0xFF);
        }
        if (bl2) {
            ((file65)this.file).buf[13] = (short)(n4 >> 8 & 0xFF);
            ((file65)this.file).buf[12] = (short)(n4 & 0xFF);
        }
        if (bl3) {
            ((file65)this.file).buf[17] = (short)(n5 >> 8 & 0xFF);
            ((file65)this.file).buf[16] = (short)(n5 & 0xFF);
        }
        if (bl4) {
            ((file65)this.file).buf[21] = (short)(n6 >> 8 & 0xFF);
            ((file65)this.file).buf[20] = (short)(n6 & 0xFF);
        }
        switch (n7) {
            case 0: {
                return new BufPos(sArray, 0, n);
            }
            case 1: {
                return new BufPos(this.file.segt, n8, this.file.tlen);
            }
            case 2: {
                return new BufPos(this.file.segd, n11, this.file.dlen);
            }
        }
        return null;
    }

    private int reldiff(int n, file65 file652) {
        return n == 2 ? file652.tdiff : (n == 3 ? file652.ddiff : (n == 4 ? file652.bdiff : (n == 5 ? file652.zdiff : 0)));
    }

    private static class BufPos {
        short[] fBuf;
        int fPos;
        int fSize;

        public BufPos(short[] sArray, int n, int n2) {
            this.fBuf = sArray;
            this.fPos = n;
            this.fSize = n2;
        }
    }

    private static class EventMixer
    extends Event {
        private Player m_player;

        @Override
        public void event() {
            this.m_player.mixer();
        }

        public EventMixer(Player player) {
            super("Mixer");
            this.m_player = player;
        }
    }

    private static class EventRTC
    extends Event {
        private IEventContext m_eventContext;
        private long m_seconds;
        private long m_period;
        private long m_clk;

        @Override
        public void event() {
            this.m_clk += this.m_period;
            long l = this.m_clk >> 7;
            this.m_clk &= 0x7FL;
            ++this.m_seconds;
            this.m_eventContext.schedule(this, l, Event.event_phase_t.EVENT_CLOCK_PHI1);
        }

        public EventRTC(IEventContext iEventContext) {
            super("RTC");
            this.m_eventContext = iEventContext;
            this.m_seconds = 0L;
        }

        public long getTime() {
            return this.m_seconds;
        }

        public void reset() {
            this.m_seconds = 0L;
            this.m_clk = this.m_period & 0x7FL;
            this.m_eventContext.schedule(this, this.m_period >> 7, Event.event_phase_t.EVENT_CLOCK_PHI1);
        }

        public void clock(double d) {
            this.m_period = (long)(d / 10.0 * 128.0);
            this.reset();
        }
    }

    private static interface IMem {
        public short m_readMemByte(int var1);

        public void m_writeMemByte(int var1, short var2);

        public short m_readMemDataByte(int var1);
    }

    static interface IOutput {
        public long output(short[] var1, int var2);
    }

    private static class Port {
        short pr_out;
        short ddr;
        short pr_in;

        private Port() {
        }
    }

    private static class file65 {
        private short[] buf;
        private int tbase;
        private int tlen;
        private int dbase;
        private int dlen;
        private int bbase;
        private int zbase;
        private int tdiff;
        private int ddiff;
        private int bdiff;
        private int zdiff;
        private short[] segt;
        private short[] segd;
        private short[] utab;
        private short[] rttab;
        private short[] rdtab;
        private short[] extab;

        private file65() {
        }
    }
}

