/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.resid_builder.resid;

import de.quippy.sidplay.resid_builder.resid.EnvelopeGenerator;
import de.quippy.sidplay.resid_builder.resid.ISIDDefs;
import de.quippy.sidplay.resid_builder.resid.WaveformGenerator;

public class Voice {
    protected WaveformGenerator wave = new WaveformGenerator();
    protected EnvelopeGenerator envelope = new EnvelopeGenerator();
    protected boolean muted = false;
    protected int wave_zero;
    protected int voice_DC;

    public int output() {
        if (!this.muted) {
            return (this.wave.output() - this.wave_zero) * this.envelope.output() + this.voice_DC;
        }
        return 0;
    }

    public Voice() {
        this.set_chip_model(ISIDDefs.chip_model.MOS6581);
    }

    public void set_chip_model(ISIDDefs.chip_model chip_model2) {
        this.wave.set_chip_model(chip_model2);
        if (chip_model2 == ISIDDefs.chip_model.MOS6581) {
            this.wave_zero = 896;
            this.voice_DC = 522240;
        } else {
            this.wave_zero = 2048;
            this.voice_DC = 0;
        }
    }

    public void set_sync_source(Voice voice) {
        this.wave.set_sync_source(voice.wave);
    }

    public void writeCONTROL_REG(int n) {
        this.wave.writeCONTROL_REG(n);
        this.envelope.writeCONTROL_REG(n);
    }

    public void reset() {
        this.wave.reset();
        this.envelope.reset();
    }

    public void mute(boolean bl) {
        this.muted = bl;
    }
}

