/*
 * Decompiled with CFR 0.152.
 */
package xtrememp;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtrememp.XtremeMP;
import xtrememp.playlist.PlaylistIO;
import xtrememp.playlist.PlaylistItem;
import xtrememp.util.file.AudioFileFilter;
import xtrememp.util.file.PlaylistFileFilter;

public class MultipleInstancesHandler {
    private final Logger logger = LoggerFactory.getLogger(MultipleInstancesHandler.class);
    private static final MultipleInstancesHandler instance = new MultipleInstancesHandler();
    private final AudioFileFilter audioFileFilter = AudioFileFilter.INSTANCE;
    private final PlaylistFileFilter playlistFileFilter = PlaylistFileFilter.INSTANCE;
    public static final int MULTIPLE_INSTANCES_SOCKET = 9999;
    private ServerSocket serverSocket;
    private static boolean closing = false;

    private MultipleInstancesHandler() {
    }

    public static MultipleInstancesHandler getInstance() {
        return instance;
    }

    public void dispose() {
        if (this.serverSocket != null) {
            closing = true;
            try {
                this.serverSocket.close();
            }
            catch (IOException ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public boolean isFirstInstance() {
        try {
            this.serverSocket = new ServerSocket(9999);
            this.logger.info("Listening on port {} for other instances", (Object)9999);
            PlaylistItemQueue queue = new PlaylistItemQueue();
            SocketListener listener = new SocketListener(this.serverSocket, queue);
            queue.start();
            listener.start();
            return true;
        }
        catch (Exception ex) {
            this.logger.info("Another instance is running");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendArgumentsToFirstInstance(String ... args) {
        block7: {
            Socket clientSocket = null;
            PrintWriter output = null;
            try {
                clientSocket = new Socket("localhost", 9999);
                output = new PrintWriter(clientSocket.getOutputStream(), true);
                for (String arg : args) {
                    File file = new File(arg);
                    if (this.audioFileFilter.accept(file) || this.playlistFileFilter.accept(file)) {
                        this.logger.info("Sending arg {}", (Object)arg);
                        output.write(arg);
                        continue;
                    }
                    this.logger.info("Sending command {}", (Object)arg);
                    output.write(arg);
                }
                IOUtils.closeQuietly(output);
            }
            catch (IOException ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
                break block7;
            }
            finally {
                IOUtils.closeQuietly(output);
                IOUtils.closeQuietly(clientSocket);
            }
            IOUtils.closeQuietly(clientSocket);
        }
    }

    private class PlaylistItemQueue
    extends Thread {
        private List<PlaylistItem> queue = new ArrayList<PlaylistItem>();
        private volatile long lastItemAdded = 0L;

        PlaylistItemQueue() {
        }

        public void addItem(PlaylistItem item) {
            this.queue.add(item);
            this.lastItemAdded = System.currentTimeMillis();
        }

        @Override
        public void run() {
            try {
                while (true) {
                    if (!this.queue.isEmpty() && this.lastItemAdded < System.currentTimeMillis() - 1000L) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ArrayList<PlaylistItem> auxList = new ArrayList<PlaylistItem>(PlaylistItemQueue.this.queue);
                                PlaylistItemQueue.this.queue.clear();
                                XtremeMP.getInstance().addToPlaylistAndPlay(auxList);
                            }
                        });
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException ex) {
                MultipleInstancesHandler.this.logger.error(ex.getMessage(), (Throwable)ex);
                return;
            }
        }
    }

    private class SocketListener
    extends Thread {
        private ServerSocket serverSocket;
        private PlaylistItemQueue queue;

        SocketListener(ServerSocket serverSocket, PlaylistItemQueue queue) {
            this.serverSocket = serverSocket;
            this.queue = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Socket s = null;
            BufferedReader br = null;
            OutputStream bos = null;
            try {
                try {
                    while (true) {
                        String line;
                        s = this.serverSocket.accept();
                        br = new BufferedReader(new InputStreamReader(s.getInputStream()));
                        while ((line = br.readLine()) != null) {
                            File file = new File(line);
                            MultipleInstancesHandler.this.logger.info("Received connection with content: {}", (Object)line);
                            if (MultipleInstancesHandler.this.audioFileFilter.accept(file)) {
                                String fileName = file.getName().substring(0, file.getName().lastIndexOf(".")).trim();
                                PlaylistItem newPli = new PlaylistItem(fileName, file.getAbsolutePath(), -1L, true);
                                this.queue.addItem(newPli);
                                continue;
                            }
                            if (!MultipleInstancesHandler.this.playlistFileFilter.accept(file)) continue;
                            List<PlaylistItem> pliList = PlaylistIO.load(file.getAbsolutePath());
                            for (PlaylistItem pli : pliList) {
                                this.queue.addItem(pli);
                            }
                        }
                        IOUtils.closeQuietly(br);
                        IOUtils.closeQuietly(s);
                        MultipleInstancesHandler.this.logger.info("Connection finished");
                    }
                }
                catch (Exception ex) {
                    if (!closing) {
                        MultipleInstancesHandler.this.logger.error(ex.getMessage(), (Throwable)ex);
                    }
                    IOUtils.closeQuietly(bos);
                    IOUtils.closeQuietly(br);
                    IOUtils.closeQuietly(s);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bos);
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly(s);
                throw throwable;
            }
        }
    }
}

