/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.player.audio;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.spi.PropertiesContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tritonus.share.sampled.TAudioFormat;
import org.tritonus.share.sampled.file.TAudioFileFormat;
import xtrememp.player.audio.Playback;
import xtrememp.player.audio.PlaybackEvent;
import xtrememp.player.audio.PlaybackEventLauncher;
import xtrememp.player.audio.PlaybackListener;
import xtrememp.player.audio.PlayerException;
import xtrememp.player.dsp.DigitalSignalSynchronizer;

public class AudioPlayer
implements Callable<Void> {
    private final Logger logger = LoggerFactory.getLogger(AudioPlayer.class);
    protected final int READ_BUFFER_SIZE = 4096;
    protected final Lock lock = new ReentrantLock();
    protected final Condition pauseCondition = this.lock.newCondition();
    protected Object audioSource;
    protected DigitalSignalSynchronizer dss;
    protected AudioFileFormat audioFileFormat;
    protected AudioInputStream audioInputStream;
    protected SourceDataLine sourceDataLine;
    protected String mixerName;
    protected List<PlaybackListener> listeners;
    protected ExecutorService execService;
    protected Future<Void> future;
    protected Map<String, Object> properties;
    protected FloatControl gainControl;
    protected FloatControl panControl;
    protected BooleanControl muteControl;
    protected int bufferSize = -1;
    public static final int INIT = 0;
    public static final int PLAY = 1;
    public static final int PAUSE = 2;
    public static final int SEEK = 3;
    public static final int STOP = 4;
    protected volatile int state = -1;
    protected Map<String, Object> emptyMap = new HashMap<String, Object>();
    protected long oldPosition = 0L;

    public AudioPlayer() {
        this.execService = Executors.newFixedThreadPool(1);
        this.dss = new DigitalSignalSynchronizer();
        this.listeners = new ArrayList<PlaybackListener>();
        this.reset();
    }

    public void addPlaybackListener(PlaybackListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePlaybackListener(PlaybackListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public List<PlaybackListener> getPlaybackListeners() {
        return this.listeners;
    }

    protected void notifyEvent(Playback state) {
        this.notifyEvent(state, this.emptyMap);
    }

    protected void notifyEvent(Playback state, Map properties) {
        for (PlaybackListener listener : this.listeners) {
            PlaybackEventLauncher launcher = new PlaybackEventLauncher(this, state, this.getPosition() - this.oldPosition, properties, listener);
            launcher.start();
        }
        this.logger.info("{}", (Object)state);
    }

    private void reset() {
        if (this.sourceDataLine != null) {
            this.sourceDataLine.flush();
            this.sourceDataLine.close();
            this.sourceDataLine = null;
        }
        this.audioFileFormat = null;
        this.gainControl = null;
        this.panControl = null;
        this.muteControl = null;
        this.future = null;
        this.emptyMap.clear();
        this.oldPosition = 0L;
    }

    public void open(File file) throws PlayerException {
        if (file != null) {
            this.audioSource = file;
            this.init();
        }
    }

    public void open(URL url) throws PlayerException {
        if (url != null) {
            this.audioSource = url;
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws PlayerException {
        this.notifyEvent(Playback.BUFFERING);
        int oldState = this.state;
        this.state = -1;
        if (oldState == 0 || oldState == 2) {
            this.lock.lock();
            try {
                this.pauseCondition.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
        this.awaitTermination();
        this.lock.lock();
        try {
            this.reset();
            this.initAudioInputStream();
            this.initSourceDataLine();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void initAudioInputStream() throws PlayerException {
        this.closeStream();
        if (this.audioInputStream == null) {
            try {
                AudioFormat audioFormat;
                this.logger.info("Data source: {}", this.audioSource);
                if (this.audioSource instanceof File) {
                    this.initAudioInputStream((File)this.audioSource);
                } else if (this.audioSource instanceof URL) {
                    this.initAudioInputStream((URL)this.audioSource);
                }
                AudioFormat sourceAudioFormat = this.audioInputStream.getFormat();
                this.logger.info("Source format: {}", (Object)sourceAudioFormat);
                int nSampleSizeInBits = sourceAudioFormat.getSampleSizeInBits();
                if (nSampleSizeInBits <= 0) {
                    nSampleSizeInBits = 16;
                }
                if (sourceAudioFormat.getEncoding() == AudioFormat.Encoding.ULAW || sourceAudioFormat.getEncoding() == AudioFormat.Encoding.ALAW) {
                    nSampleSizeInBits = 16;
                }
                if (nSampleSizeInBits != 8) {
                    nSampleSizeInBits = 16;
                }
                AudioFormat targetAudioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sourceAudioFormat.getSampleRate(), nSampleSizeInBits, sourceAudioFormat.getChannels(), sourceAudioFormat.getChannels() * (nSampleSizeInBits / 8), sourceAudioFormat.getSampleRate(), false);
                this.logger.info("Target format: {}", (Object)targetAudioFormat);
                this.audioInputStream = AudioSystem.getAudioInputStream(targetAudioFormat, this.audioInputStream);
                if (this.audioFileFormat instanceof TAudioFileFormat) {
                    this.properties = ((TAudioFileFormat)this.audioFileFormat).properties();
                    this.properties = this.deepCopy(this.properties);
                } else {
                    this.properties = new HashMap<String, Object>();
                }
                if (this.audioFileFormat.getByteLength() > 0) {
                    this.properties.put("audio.length.bytes", new Integer(this.audioFileFormat.getByteLength()));
                }
                if (this.audioFileFormat.getFrameLength() > 0) {
                    this.properties.put("audio.length.frames", new Integer(this.audioFileFormat.getFrameLength()));
                }
                if (this.audioFileFormat.getType() != null) {
                    this.properties.put("audio.type", this.audioFileFormat.getType().toString());
                }
                if ((audioFormat = this.audioFileFormat.getFormat()).getFrameRate() > 0.0f) {
                    this.properties.put("audio.framerate.fps", new Float(audioFormat.getFrameRate()));
                }
                if (audioFormat.getFrameSize() > 0) {
                    this.properties.put("audio.framesize.bytes", new Integer(audioFormat.getFrameSize()));
                }
                if (audioFormat.getSampleRate() > 0.0f) {
                    this.properties.put("audio.samplerate.hz", new Float(audioFormat.getSampleRate()));
                }
                if (audioFormat.getSampleSizeInBits() > 0) {
                    this.properties.put("audio.samplesize.bits", new Integer(audioFormat.getSampleSizeInBits()));
                }
                if (audioFormat.getChannels() > 0) {
                    this.properties.put("audio.channels", new Integer(audioFormat.getChannels()));
                }
                if (audioFormat instanceof TAudioFormat) {
                    this.properties.putAll(((TAudioFormat)audioFormat).properties());
                }
                for (String key : this.properties.keySet()) {
                    this.logger.info("Audio Format Properties: {} = {}", (Object)key, this.properties.get(key));
                }
            }
            catch (UnsupportedAudioFileException ex) {
                throw new PlayerException(ex);
            }
            catch (IOException ex) {
                throw new PlayerException(ex);
            }
        }
    }

    protected void initAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        this.audioInputStream = AudioSystem.getAudioInputStream(file);
        this.audioFileFormat = AudioSystem.getAudioFileFormat(file);
    }

    protected void initAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        this.audioInputStream = AudioSystem.getAudioInputStream(url);
        this.audioFileFormat = AudioSystem.getAudioFileFormat(url);
    }

    protected void initSourceDataLine() throws PlayerException {
        if (this.sourceDataLine == null) {
            try {
                Mixer mixer;
                this.logger.info("Create Source Data Line");
                AudioFormat audioFormat = this.audioInputStream.getFormat();
                DataLine.Info lineInfo = new DataLine.Info(SourceDataLine.class, audioFormat, -1);
                if (!AudioSystem.isLineSupported(lineInfo)) {
                    throw new PlayerException(lineInfo + " is not supported");
                }
                if (this.mixerName == null) {
                    this.mixerName = this.getMixers().get(0);
                }
                if ((mixer = this.getMixer(this.mixerName)) != null) {
                    this.logger.info("Mixer: {}", (Object)mixer.getMixerInfo().toString());
                    this.sourceDataLine = (SourceDataLine)mixer.getLine(lineInfo);
                } else {
                    this.sourceDataLine = (SourceDataLine)AudioSystem.getLine(lineInfo);
                    this.mixerName = null;
                }
                this.sourceDataLine.addLineListener(this.dss);
                this.logger.info("Line Info: {}", (Object)this.sourceDataLine.getLineInfo().toString());
                this.logger.info("Line AudioFormat: {}", (Object)this.sourceDataLine.getFormat().toString());
                if (this.bufferSize <= 0) {
                    this.bufferSize = this.sourceDataLine.getBufferSize();
                }
                this.sourceDataLine.open(audioFormat, this.bufferSize);
                this.logger.info("Line BufferSize: {}", (Object)this.sourceDataLine.getBufferSize());
                for (Control c : this.sourceDataLine.getControls()) {
                    this.logger.info("Line Controls: {}", (Object)c);
                }
                if (this.sourceDataLine.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                    this.gainControl = (FloatControl)this.sourceDataLine.getControl(FloatControl.Type.MASTER_GAIN);
                }
                if (this.sourceDataLine.isControlSupported(FloatControl.Type.PAN)) {
                    this.panControl = (FloatControl)this.sourceDataLine.getControl(FloatControl.Type.PAN);
                }
                if (this.sourceDataLine.isControlSupported(BooleanControl.Type.MUTE)) {
                    this.muteControl = (BooleanControl)this.sourceDataLine.getControl(BooleanControl.Type.MUTE);
                }
                this.sourceDataLine.start();
                this.state = 0;
                this.future = this.execService.submit(this);
                this.notifyEvent(Playback.OPENED);
            }
            catch (LineUnavailableException ex) {
                throw new PlayerException(ex);
            }
        }
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize <= 0 ? -1 : bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    protected Map<String, Object> deepCopy(Map<String, Object> src) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (src != null) {
            Set<String> keySet = src.keySet();
            for (String key : keySet) {
                Object value = src.get(key);
                map.put(key, value);
            }
        }
        return map;
    }

    public List<String> getMixers() {
        ArrayList<String> mixers = new ArrayList<String>();
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        if (mixerInfos != null) {
            int len = mixerInfos.length;
            for (int i = 0; i < len; ++i) {
                Line.Info lineInfo = new Line.Info(SourceDataLine.class);
                Mixer _mixer = AudioSystem.getMixer(mixerInfos[i]);
                if (!_mixer.isLineSupported(lineInfo)) continue;
                mixers.add(mixerInfos[i].getName());
            }
        }
        return mixers;
    }

    public Mixer getMixer(String name) {
        Mixer.Info[] mixerInfos;
        Mixer _mixer = null;
        if (name != null && (mixerInfos = AudioSystem.getMixerInfo()) != null) {
            int len = mixerInfos.length;
            for (int i = 0; i < len; ++i) {
                if (!mixerInfos[i].getName().equals(name)) continue;
                _mixer = AudioSystem.getMixer(mixerInfos[i]);
                break;
            }
        }
        return _mixer;
    }

    public String getMixerName() {
        return this.mixerName;
    }

    public void setMixerName(String name) {
        this.mixerName = name;
    }

    public long getDuration() {
        long duration = -1L;
        duration = this.properties.containsKey("duration") ? ((Long)this.properties.get("duration")).longValue() : this.getTimeLengthEstimation(this.properties);
        return duration;
    }

    public int getByteLength() {
        int bytesLength = -1;
        if (this.properties != null && this.properties.containsKey("audio.length.bytes")) {
            bytesLength = (Integer)this.properties.get("audio.length.bytes");
        }
        return bytesLength;
    }

    public int getPositionByte() {
        int positionByte = -1;
        if (this.properties != null) {
            if (this.properties.containsKey("mp3.position.byte")) {
                positionByte = (Integer)this.properties.get("mp3.position.byte");
                return positionByte;
            }
            if (this.properties.containsKey("ogg.position.byte")) {
                positionByte = (Integer)this.properties.get("ogg.position.byte");
                return positionByte;
            }
        }
        return positionByte;
    }

    protected long getTimeLengthEstimation(Map properties) {
        long milliseconds = -1L;
        int byteslength = -1;
        if (properties != null) {
            if (properties.containsKey("audio.length.bytes")) {
                byteslength = (Integer)properties.get("audio.length.bytes");
            }
            if (properties.containsKey("duration")) {
                milliseconds = (int)((Long)properties.get("duration")).longValue() / 1000;
            } else {
                int bitspersample = -1;
                int channels = -1;
                float samplerate = -1.0f;
                int framesize = -1;
                if (properties.containsKey("audio.samplesize.bits")) {
                    bitspersample = (Integer)properties.get("audio.samplesize.bits");
                }
                if (properties.containsKey("audio.channels")) {
                    channels = (Integer)properties.get("audio.channels");
                }
                if (properties.containsKey("audio.samplerate.hz")) {
                    samplerate = ((Float)properties.get("audio.samplerate.hz")).floatValue();
                }
                if (properties.containsKey("audio.framesize.bytes")) {
                    framesize = (Integer)properties.get("audio.framesize.bytes");
                }
                milliseconds = bitspersample > 0 ? (long)(1000.0f * (float)byteslength / (samplerate * (float)channels * (float)(bitspersample / 8))) : (long)(1000.0f * (float)byteslength / (samplerate * (float)framesize));
            }
        }
        return milliseconds * 1000L;
    }

    public void setGain(float gain) throws PlayerException {
        if (this.gainControl == null) {
            throw new PlayerException("Gain control not supported");
        }
        double minGain = this.gainControl.getMinimum();
        double maxGain = this.gainControl.getMaximum();
        double ampGain = 0.5 * maxGain - minGain;
        double cste = Math.log(10.0) / 20.0;
        double value = minGain + 1.0 / cste * Math.log(1.0 + (Math.exp(cste * ampGain) - 1.0) * (double)gain);
        this.gainControl.setValue((float)value);
        this.logger.info("{}", (Object)this.gainControl.toString());
    }

    public float getGain() {
        float gain = 0.0f;
        if (this.gainControl != null) {
            gain = this.gainControl.getValue();
        }
        return gain;
    }

    public void setPan(float pan) throws PlayerException {
        if (this.panControl == null) {
            throw new PlayerException("Pan control not supported");
        }
        this.panControl.setValue(pan);
        this.logger.info("{}", (Object)this.panControl.toString());
    }

    public float getPan() {
        float pan = 0.0f;
        if (this.panControl != null) {
            pan = this.panControl.getValue();
        }
        return pan;
    }

    public void setMuted(boolean mute) throws PlayerException {
        if (this.muteControl == null) {
            throw new PlayerException("Mute control not supported");
        }
        this.muteControl.setValue(mute);
        this.logger.info("{}", (Object)this.muteControl.toString());
    }

    public boolean isMuted() {
        boolean muted = false;
        if (this.muteControl != null) {
            muted = this.muteControl.getValue();
        }
        return muted;
    }

    public long getPosition() {
        long pos = 0L;
        if (this.sourceDataLine != null) {
            pos = this.sourceDataLine.getMicrosecondPosition();
        }
        return pos;
    }

    public int getState() {
        return this.state;
    }

    public DigitalSignalSynchronizer getDSS() {
        return this.dss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Void call() throws PlayerException {
        this.logger.info("Decoding thread started");
        nBytesRead = 0;
        audioDataLength = 4096;
        audioDataBuffer = ByteBuffer.allocate(audioDataLength);
        audioDataBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.lock.lock();
lbl8:
        // 2 sources

        try {
            while (nBytesRead != -1 && this.state != 4 && this.state != 3 && this.state != -1) {
                try {
                    block14: {
                        if (this.state != 1) break block14;
                        totalRead = 0;
                        for (toRead = audioDataLength; toRead > 0 && (nBytesRead = this.audioInputStream.read(audioDataBuffer.array(), totalRead, toRead)) != -1; totalRead += nBytesRead, toRead -= nBytesRead) {
                        }
                        if (totalRead <= 0) continue;
                        trimBuffer = audioDataBuffer.array();
                        if (totalRead < trimBuffer.length) {
                            trimBuffer = new byte[totalRead];
                            System.arraycopy(audioDataBuffer.array(), 0, trimBuffer, 0, totalRead);
                        }
                        this.sourceDataLine.write(trimBuffer, 0, totalRead);
                        this.dss.writeAudioData(trimBuffer, 0, totalRead);
                        for (PlaybackListener pl : this.listeners) {
                            pe = new PlaybackEvent(this, Playback.PLAYING, this.getPosition() - this.oldPosition, this.emptyMap);
                            if (this.audioInputStream instanceof PropertiesContainer) {
                                pe.setProperties(((PropertiesContainer)this.audioInputStream).properties());
                            }
                            pl.playbackProgress(pe);
                        }
                        ** GOTO lbl8
                    }
                    if (this.state != 0 && this.state != 2) continue;
                    if (this.sourceDataLine != null && this.sourceDataLine.isRunning()) {
                        this.sourceDataLine.flush();
                        this.sourceDataLine.stop();
                    }
                    this.pauseCondition.awaitUninterruptibly();
                }
                catch (IOException ex) {
                    this.logger.error("Decoder Exception: ", (Throwable)ex);
                    this.state = 4;
                    this.notifyEvent(Playback.STOPPED);
                    throw new PlayerException(ex);
                }
            }
            if (this.sourceDataLine != null) {
                this.sourceDataLine.flush();
                this.sourceDataLine.stop();
                this.sourceDataLine.close();
                this.sourceDataLine = null;
            }
            this.closeStream();
            if (nBytesRead == -1) {
                this.notifyEvent(Playback.EOM);
            }
        }
        finally {
            this.lock.unlock();
        }
        this.logger.info("Decoding thread completed");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitTermination() {
        if (this.future != null && !this.future.isDone()) {
            try {
                this.future.get();
            }
            catch (InterruptedException ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
            }
            catch (ExecutionException ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
            }
            finally {
                this.future.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() throws PlayerException {
        this.lock.lock();
        try {
            switch (this.state) {
                case 4: {
                    this.initAudioInputStream();
                    this.initSourceDataLine();
                }
            }
            if (this.sourceDataLine != null && !this.sourceDataLine.isRunning()) {
                this.sourceDataLine.start();
            }
            this.state = 1;
            this.pauseCondition.signal();
            this.notifyEvent(Playback.PLAYING);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void pause() {
        if (this.sourceDataLine != null && this.state == 1) {
            this.state = 2;
            this.notifyEvent(Playback.PAUSED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.state != 4) {
            int oldState = this.state;
            this.state = 4;
            if (oldState == 0 || oldState == 2) {
                this.lock.lock();
                try {
                    this.pauseCondition.signal();
                }
                finally {
                    this.lock.unlock();
                }
            }
            this.awaitTermination();
            this.notifyEvent(Playback.STOPPED);
        }
    }

    public long seek(long bytes) throws PlayerException {
        long totalSkipped = 0L;
        if (this.audioSource instanceof File) {
            int bytesLength = this.getByteLength();
            if (bytesLength <= 0 || bytes >= (long)bytesLength) {
                this.notifyEvent(Playback.EOM);
                return totalSkipped;
            }
            this.logger.info("Bytes to skip: {}", (Object)bytes);
            this.oldPosition = this.getPosition();
            int oldState = this.state;
            if (this.state == 1) {
                this.state = 2;
            }
            this.lock.lock();
            try {
                this.notifyEvent(Playback.SEEKING);
                this.initAudioInputStream();
                if (this.audioInputStream != null) {
                    totalSkipped = this.audioInputStream.skip(bytes);
                    this.logger.info("Skipped bytes: {}/{}", (Object)totalSkipped, (Object)bytes);
                    if (totalSkipped == -1L) {
                        throw new PlayerException("Seek not supported");
                    }
                    this.initSourceDataLine();
                }
            }
            catch (IOException ex) {
                throw new PlayerException(ex);
            }
            finally {
                this.lock.unlock();
            }
            if (oldState == 1) {
                this.play();
            }
        }
        return totalSkipped;
    }

    protected void closeStream() {
        if (this.audioInputStream != null) {
            try {
                this.audioInputStream.close();
                this.audioInputStream = null;
                this.logger.info("Stream closed");
            }
            catch (IOException ex) {
                this.logger.error("Cannot close stream", (Throwable)ex);
            }
        }
    }
}

