/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.playlist;

import com.melloware.jspiff.jaxp.XspfPlaylist;
import com.melloware.jspiff.jaxp.XspfPlaylistTrackList;
import com.melloware.jspiff.jaxp.XspfTrack;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtrememp.playlist.Playlist;
import xtrememp.playlist.PlaylistException;
import xtrememp.playlist.PlaylistItem;
import xtrememp.tag.TagInfo;
import xtrememp.util.Utilities;

public final class PlaylistIO {
    private static final Logger logger = LoggerFactory.getLogger(PlaylistIO.class);

    public static List<PlaylistItem> load(String location) throws PlaylistException {
        if (!Utilities.isNullOrEmpty(location)) {
            String filenameExt = FilenameUtils.getExtension(location);
            if (filenameExt.equalsIgnoreCase("m3u")) {
                return PlaylistIO.loadM3U(location);
            }
            if (filenameExt.equalsIgnoreCase("pls")) {
                return PlaylistIO.loadPLS(location);
            }
            if (filenameExt.equalsIgnoreCase("xspf")) {
                return PlaylistIO.loadXSPF(location);
            }
        }
        return null;
    }

    protected static List<PlaylistItem> loadM3U(String location) throws PlaylistException {
        ArrayList<PlaylistItem> itemList = new ArrayList<PlaylistItem>();
        BufferedReader br = null;
        try {
            br = Utilities.startWithProtocol(location) ? new BufferedReader(new InputStreamReader(new URL(location).openStream())) : new BufferedReader(new FileReader(location));
            String line = null;
            String songName = null;
            String songFile = null;
            String songLength = null;
            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (line.startsWith("#")) {
                    int indB;
                    if (!line.toUpperCase().startsWith("#EXTINF")) continue;
                    int indA = line.indexOf(",", 0);
                    if (indA != -1) {
                        songName = line.substring(indA + 1, line.length());
                    }
                    if ((indB = line.indexOf(":", 0)) == -1 || indB >= indA) continue;
                    songLength = line.substring(indB + 1, indA).trim();
                    continue;
                }
                songFile = line;
                if (songName == null) {
                    songName = songFile;
                }
                if (songLength == null) {
                    songLength = "-1";
                }
                PlaylistItem pli = null;
                if (Utilities.startWithProtocol(songFile)) {
                    pli = new PlaylistItem(songName, songFile, Integer.parseInt(songLength), false);
                } else {
                    File f = new File(songFile);
                    if (f.exists()) {
                        pli = new PlaylistItem(songName, songFile, Integer.parseInt(songLength), true);
                    } else {
                        String parent = new File(location).getParent();
                        f = new File(parent, songFile);
                        if (f.exists()) {
                            pli = new PlaylistItem(songName, f.getAbsolutePath(), Integer.parseInt(songLength), true);
                        }
                    }
                }
                if (pli != null) {
                    itemList.add(pli);
                }
                songFile = null;
                songName = null;
                songLength = null;
            }
        }
        catch (Exception ex) {
            try {
                logger.error("Can't load M3U playlist", (Throwable)ex);
                throw new PlaylistException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(br);
        return itemList;
    }

    protected static List<PlaylistItem> loadPLS(String location) throws PlaylistException {
        ArrayList<PlaylistItem> itemList = new ArrayList<PlaylistItem>();
        BufferedReader br = null;
        try {
            br = Utilities.startWithProtocol(location) ? new BufferedReader(new InputStreamReader(new URL(location).openStream())) : new BufferedReader(new FileReader(location));
            String line = null;
            boolean markerFound = false;
            int numberOfEntries = -1;
            int lineNumber = 0;
            while ((line = br.readLine()) != null) {
                line = line.trim();
                ++lineNumber;
                if (line.length() <= 0) continue;
                if (!markerFound) {
                    if (!line.equalsIgnoreCase("[playlist]")) {
                        logger.warn("Not a PLS playlist format");
                    }
                    markerFound = true;
                    continue;
                }
                if (line.indexOf(61) <= 0) {
                    logger.error("Malformed PLS playlist {}", (Object)location);
                    break;
                }
                StringTokenizer st = new StringTokenizer(line, "=");
                String key = st.nextToken().trim();
                String value = st.nextToken().trim();
                if (key.equalsIgnoreCase("numberofentries")) {
                    int tmpValue;
                    try {
                        tmpValue = Integer.parseInt(value);
                    }
                    catch (NumberFormatException ex) {
                        logger.error("Error on parsing NumberOfEntries in PLS playlist: {} at line {}", (Object)location, (Object)lineNumber);
                        break;
                    }
                    if (tmpValue < 0) {
                        logger.warn("Invalid NumberOfEntries in PLS playlist: {} at line {}", (Object)location, (Object)lineNumber);
                    }
                    if (numberOfEntries >= 0 && numberOfEntries != tmpValue) {
                        logger.warn("PLS playlist number of entries already specified with a different value");
                    }
                    numberOfEntries = tmpValue;
                    continue;
                }
                if (key.toLowerCase().startsWith("file")) {
                    PlaylistItem pli = null;
                    if (Utilities.startWithProtocol(value)) {
                        pli = new PlaylistItem(value, value, -1L, false);
                    } else {
                        File f = new File(value);
                        if (f.exists()) {
                            pli = new PlaylistItem(value, value, -1L, true);
                        } else {
                            String parent = new File(location).getParent();
                            f = new File(parent, value);
                            if (f.exists()) {
                                pli = new PlaylistItem(value, f.getAbsolutePath(), -1L, true);
                            }
                        }
                    }
                    if (pli == null) continue;
                    itemList.add(pli);
                    continue;
                }
                if (key.toLowerCase().startsWith("title")) {
                    try {
                        int index = Integer.parseInt(key.substring(5)) - 1;
                        PlaylistItem pli = (PlaylistItem)itemList.get(index);
                        pli.setFormattedName(value);
                    }
                    catch (Exception ex) {
                        logger.warn("Corrupted PLS playlist {} at line {}", (Object)location, (Object)lineNumber);
                    }
                    continue;
                }
                if (key.toLowerCase().startsWith("length")) {
                    try {
                        int duration = Integer.parseInt(value);
                        int index = Integer.parseInt(key.substring(6)) - 1;
                        PlaylistItem pli = (PlaylistItem)itemList.get(index);
                        pli.setDuration(duration);
                    }
                    catch (Exception ex) {
                        logger.warn("Corrupted PLS playlist {} at line {}", (Object)location, (Object)lineNumber);
                    }
                    continue;
                }
                if (!key.equalsIgnoreCase("version") || value.equals("2")) continue;
                logger.error("Unknown PLS version " + value);
                break;
            }
            if (numberOfEntries < 0) {
                logger.warn("No number of entries in PLS playlist");
            }
        }
        catch (Exception ex) {
            try {
                logger.error("Can't load PLS playlist", (Throwable)ex);
                throw new PlaylistException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(br);
        return itemList;
    }

    protected static List<PlaylistItem> loadXSPF(String location) throws PlaylistException {
        ArrayList<PlaylistItem> itemList = new ArrayList<PlaylistItem>();
        XspfPlaylist xspfPlaylist = new XspfPlaylist();
        try {
            if (Utilities.startWithProtocol(location)) {
                xspfPlaylist.setup(new URL(location));
            } else {
                xspfPlaylist.setup((Reader)new FileReader(location));
            }
            XspfPlaylistTrackList tracks = xspfPlaylist.getPlaylistTrackList();
            for (XspfTrack track : tracks.getTrack()) {
                String baseName;
                File f;
                PlaylistItem pli = null;
                String trackLocation = track.getLocation(0);
                if (Utilities.startWithProtocol(trackLocation)) {
                    if (Utilities.startWithProtocol(trackLocation, "file:")) {
                        f = new File(new URI(trackLocation));
                        if (f.exists()) {
                            baseName = FilenameUtils.getBaseName(f.getName());
                            pli = new PlaylistItem(baseName, f.getAbsolutePath(), -1L, true);
                        }
                    } else {
                        String trackTitle = track.getTitle();
                        pli = Utilities.isNullOrEmpty(trackTitle) ? new PlaylistItem(trackLocation, trackLocation, -1L, false) : new PlaylistItem(trackTitle, trackLocation, -1L, false);
                    }
                } else {
                    f = new File(trackLocation);
                    if (f.exists()) {
                        baseName = FilenameUtils.getBaseName(f.getName());
                        pli = new PlaylistItem(baseName, f.getAbsolutePath(), -1L, true);
                    }
                }
                if (pli != null) {
                    itemList.add(pli);
                }
                trackLocation = null;
            }
        }
        catch (Exception ex) {
            logger.error("Can't load XSPF playlist", (Throwable)ex);
            throw new PlaylistException(ex.getMessage(), ex.getCause());
        }
        return itemList;
    }

    public static boolean saveM3U(Playlist playlist, String location) throws PlaylistException {
        if (playlist != null) {
            boolean i$;
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter(new FileWriter(location));
                bw.write("#EXTM3U");
                bw.newLine();
                for (PlaylistItem pli : playlist.listAllItems()) {
                    bw.write("#EXTINF:" + pli.getM3UExtInf());
                    bw.newLine();
                    bw.write(pli.getLocation());
                    bw.newLine();
                }
                playlist.setModified(false);
                i$ = true;
            }
            catch (IOException ex) {
                try {
                    logger.error("Can't save playlist in M3U format", (Throwable)ex);
                    throw new PlaylistException(ex.getMessage(), ex.getCause());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bw);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(bw);
            return i$;
        }
        return false;
    }

    public static boolean saveXSPF(Playlist playlist, String location) throws PlaylistException {
        if (playlist != null) {
            boolean bl;
            File xspfFile = new File(location);
            XspfPlaylist xspfPlaylist = new XspfPlaylist();
            xspfPlaylist.setVersion("1");
            xspfPlaylist.setTitle("Playlist");
            xspfPlaylist.setLocation(xspfFile.toURI().toString());
            XspfPlaylistTrackList tracks = new XspfPlaylistTrackList();
            for (PlaylistItem pli : playlist.listAllItems()) {
                XspfTrack track = new XspfTrack();
                track.setIdentifier(String.valueOf(playlist.indexOf(pli)));
                if (pli.isFile()) {
                    track.setLocation(new File(pli.getLocation()).toURI().toString());
                } else {
                    track.setLocation(pli.getLocation());
                }
                if (pli.isFile()) {
                    TagInfo tagInfo = pli.getTagInfo();
                    if (tagInfo != null) {
                        long duration;
                        String genre;
                        String trackNum;
                        String album;
                        String artist;
                        String title = tagInfo.getTitle();
                        if (!Utilities.isNullOrEmpty(title)) {
                            track.setTitle(title);
                        }
                        if (!Utilities.isNullOrEmpty(artist = tagInfo.getArtist())) {
                            track.setCreator(artist);
                        }
                        if (!Utilities.isNullOrEmpty(album = tagInfo.getAlbum())) {
                            track.setAlbum(album);
                        }
                        if (!Utilities.isNullOrEmpty(trackNum = tagInfo.getTrack())) {
                            try {
                                track.setTrackNum(new BigInteger(trackNum));
                            }
                            catch (NumberFormatException ex) {
                                logger.debug("{} is not a valid number", (Object)trackNum, (Object)ex);
                            }
                        }
                        if (!Utilities.isNullOrEmpty(genre = tagInfo.getGenre())) {
                            track.setAnnotation(genre);
                        }
                        if ((duration = pli.getDuration()) >= 0L) {
                            try {
                                track.setDuration(new BigInteger(String.valueOf(duration)));
                            }
                            catch (NumberFormatException ex) {
                                logger.debug("{} is not a valid number", (Object)duration, (Object)ex);
                            }
                        }
                    }
                } else {
                    String name = pli.getFormattedName();
                    if (!Utilities.isNullOrEmpty(name)) {
                        track.setTitle(name.trim());
                    }
                }
                tracks.addTrack(track);
            }
            xspfPlaylist.setPlaylistTrackList(tracks);
            OutputFormat format = OutputFormat.createPrettyPrint();
            FileWriter fw = null;
            Document doc = null;
            try {
                fw = new FileWriter(xspfFile);
                XMLWriter xmlWriter = new XMLWriter((Writer)fw, format);
                doc = DocumentHelper.parseText((String)xspfPlaylist.makeTextDocument());
                xmlWriter.write(doc);
                bl = true;
            }
            catch (Exception ex) {
                try {
                    logger.error("Can't save playlist in XSPF format", (Throwable)ex);
                    throw new PlaylistException(ex.getMessage(), ex.getCause());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fw);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(fw);
            return bl;
        }
        return false;
    }
}

