/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.tag;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.flac.FlacInfoReader;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.flac.FlacTag;
import org.kc7bfi.jflac.FLACDecoder;
import org.kc7bfi.jflac.metadata.StreamInfo;
import xtrememp.tag.TagInfo;
import xtrememp.util.Utilities;

public class FlacInfo
extends TagInfo {
    protected StreamInfo info = null;
    protected int bitspersample = -1;

    @Override
    public void load(File file) throws IOException, UnsupportedAudioFileException {
        this.size = file.length();
        this.location = file.getPath();
        FileInputStream is = new FileInputStream(file);
        FLACDecoder decoder = new FLACDecoder((InputStream)is);
        decoder.readMetadata();
        this.info = decoder.getStreamInfo();
        try {
            AudioFile flacFile = AudioFileIO.read((File)file);
            FlacTag flacTag = (FlacTag)flacFile.getTag();
            FlacInfoReader fir = new FlacInfoReader();
            GenericAudioHeader gah = fir.read(new RandomAccessFile(file, "r"));
            if (gah != null) {
                this.encodingType = gah.getEncodingType();
                this.channelsAsNumber = gah.getChannelNumber();
                this.sampleRateAsNumber = gah.getSampleRateAsNumber();
                this.bitRateAsNumber = (int)gah.getBitRateAsNumber();
                this.duration = gah.getTrackLength();
            }
            if (flacTag != null) {
                this.title = flacTag.getFirst(FieldKey.TITLE);
                this.artist = flacTag.getFirst(FieldKey.ARTIST);
                this.album = flacTag.getFirst(FieldKey.ALBUM);
                this.year = flacTag.getFirst(FieldKey.YEAR);
                this.genre = flacTag.getFirst(FieldKey.GENRE);
                this.track = flacTag.getFirst(FieldKey.TRACK);
                this.comment = flacTag.getFirst(FieldKey.COMMENT);
            }
        }
        catch (CannotReadException ex) {
            throw new IOException(ex);
        }
        catch (TagException ex) {
            throw new UnsupportedAudioFileException("Not Flac audio format");
        }
        catch (ReadOnlyFileException ex) {
            throw new IOException(ex);
        }
        catch (InvalidAudioFrameException ex) {
            throw new UnsupportedAudioFileException("Not Flac audio format");
        }
    }

    @Override
    public void load(URL input) throws IOException, UnsupportedAudioFileException {
        this.location = input.toString();
        FLACDecoder decoder = new FLACDecoder(input.openStream());
        decoder.readMetadata();
        this.info = decoder.getStreamInfo();
        AudioFileFormat aff = AudioSystem.getAudioFileFormat(input);
        this.loadInfo(aff);
    }

    @Override
    public void load(InputStream input) throws IOException, UnsupportedAudioFileException {
        FLACDecoder decoder = new FLACDecoder(input);
        decoder.readMetadata();
        this.info = decoder.getStreamInfo();
        AudioFileFormat aff = AudioSystem.getAudioFileFormat(input);
        this.loadInfo(aff);
    }

    protected void loadInfo(AudioFileFormat aff) throws UnsupportedAudioFileException {
        this.encodingType = aff.getType().toString();
        if (!this.encodingType.equalsIgnoreCase("flac")) {
            throw new UnsupportedAudioFileException("Not Flac audio format");
        }
        this.channelsAsNumber = this.info.getChannels();
        this.sampleRateAsNumber = this.info.getSampleRate();
        this.bitspersample = this.info.getBitsPerSample();
        this.duration = Math.round(this.info.getTotalSamples() / (long)this.info.getSampleRate());
    }

    public long getSize() {
        return this.size;
    }

    public String getLocation() {
        return this.location;
    }

    public int getBitsPerSample() {
        return this.bitspersample;
    }

    @Override
    public String getCodecDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><b>Encoding Type: </b>");
        sb.append(this.getEncodingType().toUpperCase());
        sb.append("<br><b>Sampling rate: </b>");
        sb.append(this.getSampleRateAsNumber()).append(" Hz");
        sb.append("<br><b>Bitrate: </b>");
        sb.append(this.getBitRateAsNumber()).append(" Kbps");
        sb.append("<br><b>Channels: </b>");
        sb.append(this.getChannelsAsNumber());
        if (this.size > 0L) {
            sb.append("<br><b>Size: </b>");
            sb.append(Utilities.byteCountToDisplaySize(this.size));
        }
        sb.append("</html>");
        return sb.toString();
    }
}

