/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.ui.table;

import java.util.Comparator;
import xtrememp.playlist.PlaylistItem;
import xtrememp.playlist.sort.AlbumComparator;
import xtrememp.playlist.sort.ArtistComparator;
import xtrememp.playlist.sort.DurationComparator;
import xtrememp.playlist.sort.GenreComparator;
import xtrememp.playlist.sort.TitleComparator;
import xtrememp.playlist.sort.TrackComparator;
import xtrememp.util.Utilities;

public enum PlaylistColumn {
    TRACK(Utilities.tr("MainFrame.PlaylistManager.PlaylistColumn.Track"), 100, new TrackComparator()),
    TITLE(Utilities.tr("MainFrame.PlaylistManager.PlaylistColumn.Title"), 850, new TitleComparator()),
    DURATION(Utilities.tr("MainFrame.PlaylistManager.PlaylistColumn.Duration"), 150, new DurationComparator()),
    ARTIST(Utilities.tr("MainFrame.PlaylistManager.PlaylistColumn.Artist"), 500, new ArtistComparator()),
    ALBUM(Utilities.tr("MainFrame.PlaylistManager.PlaylistColumn.Album"), 300, new AlbumComparator()),
    GENRE(Utilities.tr("MainFrame.PlaylistManager.PlaylistColumn.Genre"), 200, new GenreComparator());

    private String displayName;
    private int width;
    private Comparator<PlaylistItem> comparator;

    private PlaylistColumn(String displayName, int width, Comparator<PlaylistItem> comparator) {
        this.displayName = displayName;
        this.width = width;
        this.comparator = comparator;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public Comparator<PlaylistItem> getComparator() {
        return this.comparator;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name());
        sb.append("[").append(this.displayName);
        sb.append(",").append(this.width);
        sb.append(",").append(this.comparator).append("]");
        return sb.toString();
    }
}

