/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.visualization;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Point;
import java.awt.Toolkit;
import java.nio.FloatBuffer;
import java.text.DecimalFormat;
import java.util.Map;
import javax.sound.sampled.SourceDataLine;
import xtrememp.player.dsp.DssContext;
import xtrememp.visualization.Visualization;
import xtrememp.visualization.spectrum.Band;
import xtrememp.visualization.spectrum.BandDistribution;
import xtrememp.visualization.spectrum.BandGain;
import xtrememp.visualization.spectrum.FFT;
import xtrememp.visualization.spectrum.FlatBandGain;
import xtrememp.visualization.spectrum.FrequencyBandGain;
import xtrememp.visualization.spectrum.LinearBandDistribution;
import xtrememp.visualization.spectrum.LogBandDistribution;

public final class SpectrumBars
extends Visualization {
    public static final String NAME = "Spectrum Bars";
    public static final BandDistribution BAND_DISTRIBUTION_LINEAR = new LinearBandDistribution();
    public static final BandDistribution BAND_DISTRIBUTION_LOG = new LogBandDistribution(4, 20.0);
    public static final BandGain BAND_GAIN_FLAT = new FlatBandGain(4.0f);
    public static final BandGain BAND_GAIN_FREQUENCY = new FrequencyBandGain(4.0f);
    public static final BandDistribution DEFAULT_SPECTRUM_ANALYSER_BAND_DISTRIBUTION = BAND_DISTRIBUTION_LOG;
    public static final BandGain DEFAULT_SPECTRUM_ANALYSER_BAND_GAIN = BAND_GAIN_FREQUENCY;
    public static final int DEFAULT_SPECTRUM_ANALYSER_BAND_COUNT = 20;
    public static final int DEFAULT_SPECTRUM_ANALYSER_PEAK_DELAY = 25;
    public static final float DEFAULT_SPECTRUM_ANALYSER_DECAY = 0.02f;
    public static final float DEFAULT_SPECTRUM_ANALYSER_GAIN = 1.0f;
    private BandDistribution bandDistribution = DEFAULT_SPECTRUM_ANALYSER_BAND_DISTRIBUTION;
    private BandGain bandGain = DEFAULT_SPECTRUM_ANALYSER_BAND_GAIN;
    private Band[] bdTable;
    private float[] bgTable;
    private int bands;
    private int fftSampleSize;
    private float fftSampleRate;
    private FFT fft;
    private float decay = 0.02f;
    private float gain = 1.0f;
    private int[] peaks = new int[20];
    private int[] peaksDelay = new int[20];
    private int peakDelay = 25;
    private boolean peaksEnabled = true;
    private float bandWidth;
    private boolean showFrequencies = true;
    private float[] old_FFT;
    private LinearGradientPaint lgp;
    private Map desktopHints;
    private Font freqFont;

    public SpectrumBars() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.desktopHints = (Map)tk.getDesktopProperty("awt.font.desktophints");
        this.freqFont = new Font("Arial", 0, 10);
        this.setBandCount(20);
    }

    public synchronized void setBandCount(int count) {
        this.bands = count;
        this.computeBandTables();
    }

    private void computeBandTables() {
        if (this.bands > 0 && this.fftSampleSize > 0 & this.fft != null) {
            this.bdTable = this.bandDistribution.create(this.bands, this.fft, this.fftSampleRate);
            this.bands = this.bdTable.length;
            this.resolveBandDescriptions(this.bdTable);
            this.bgTable = this.bandGain.create(this.fft, this.fftSampleRate);
        }
    }

    private void resolveBandDescriptions(Band[] bandTable) {
        DecimalFormat df = new DecimalFormat("###.#");
        for (Band band : bandTable) {
            band.description = band.frequency >= 1000.0f ? df.format(band.frequency / 1000.0f) + "k" : df.format(band.frequency);
        }
    }

    @Override
    public void init(int sampleSize, SourceDataLine sourceDataLine) {
        this.fftSampleSize = sampleSize;
        this.fftSampleRate = sourceDataLine.getFormat().getFrameRate();
        this.fft = new FFT(this.fftSampleSize);
        this.old_FFT = new float[this.bands];
        this.computeBandTables();
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }

    @Override
    public synchronized void render(DssContext dssContext, Graphics2D g2d, int width, int height) {
        float c = 0.0f;
        int li = 0;
        int bm = 1;
        if (this.showFrequencies) {
            g2d.setRenderingHints(this.desktopHints);
            g2d.setFont(this.freqFont);
            bm = Math.round(32.0f / this.bandWidth);
            if (bm == 0) {
                bm = 1;
            }
        }
        FloatBuffer[] channelsBuffer = dssContext.getDataNormalized();
        float[] _fft = this.fft.calculate(this.channelsMerge(channelsBuffer));
        this.bandWidth = (float)width / (float)this.bands;
        g2d.setColor(this.backgroundColor);
        g2d.fillRect(0, 0, width, height);
        for (int bd = 0; bd < this.bands; ++bd) {
            int i = this.bdTable[bd].distribution;
            float m = 0.0f;
            int mi = 0;
            for (int b = li; b < i; ++b) {
                float lf = _fft[b];
                if (!(lf > m)) continue;
                m = lf;
                mi = b;
            }
            li = i;
            float fs = m * this.bgTable[mi] * this.gain;
            if (fs > 1.0f) {
                fs = 1.0f;
            }
            if (fs >= this.old_FFT[bd] - this.decay) {
                this.old_FFT[bd] = fs;
            } else {
                int n = bd;
                this.old_FFT[n] = this.old_FFT[n] - this.decay;
                if (this.old_FFT[bd] < 0.0f) {
                    this.old_FFT[bd] = 0.0f;
                }
                fs = this.old_FFT[bd];
            }
            if (this.lgp == null || this.lgp.getEndPoint().getY() != (double)height) {
                Point start = new Point(0, 0);
                Point end = new Point(0, height);
                float[] dist = new float[]{0.0f, 0.25f, 0.75f, 1.0f};
                Color[] colors = new Color[]{Color.red, Color.yellow, Color.green, Color.green.darker().darker()};
                this.lgp = new LinearGradientPaint(start, end, dist, colors, MultipleGradientPaint.CycleMethod.REPEAT);
            }
            g2d.setPaint(this.lgp);
            this.renderSpectrumBar(g2d, Math.round(c), height - 18, Math.round(this.bandWidth) - 1, Math.round(fs * (float)(height - 20)), bd, this.bdTable[bd], this.showFrequencies && bd % bm == 0);
            c += this.bandWidth;
        }
    }

    private void renderSpectrumBar(Graphics2D g2d, int x, int y, int w, int h, int bd, Band band, boolean renderFrequency) {
        g2d.fillRect(x, y - h, w, h);
        if (this.peaksEnabled) {
            g2d.setColor(this.foregroundColor);
            if (h > this.peaks[bd]) {
                this.peaks[bd] = h;
                this.peaksDelay[bd] = this.peakDelay;
            } else {
                int n = bd;
                this.peaksDelay[n] = this.peaksDelay[n] - 1;
                if (this.peaksDelay[bd] < 0) {
                    int n2 = bd;
                    this.peaks[n2] = this.peaks[n2] - 1;
                }
                if (this.peaks[bd] < 0) {
                    this.peaks[bd] = 0;
                }
            }
            g2d.fillRect(x, y - this.peaks[bd], w, 1);
        }
        if (renderFrequency) {
            g2d.setColor(this.foregroundColor);
            int sx = x + (w - g2d.getFontMetrics().stringWidth(band.description) >> 1);
            g2d.drawString(band.description, sx, y + g2d.getFontMetrics().getHeight());
        }
    }
}

